/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.WaitStrategy;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.async.AsyncLoggerConfigDefaultExceptionHandler;
import org.apache.logging.log4j.core.async.AsyncLoggerConfigDisruptor;
import org.apache.logging.log4j.core.async.AsyncLoggerDefaultExceptionHandler;
import org.apache.logging.log4j.core.async.AsyncWaitStrategyFactory;
import org.apache.logging.log4j.core.async.DefaultAsyncWaitStrategyFactory;
import org.apache.logging.log4j.core.async.RingBufferLogEvent;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.core.util.Integers;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.PropertiesUtil;

final class DisruptorUtil {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final int RINGBUFFER_MIN_SIZE = 128;
    private static final int RINGBUFFER_DEFAULT_SIZE = 262144;
    private static final int RINGBUFFER_NO_GC_DEFAULT_SIZE = 4096;
    static final boolean ASYNC_LOGGER_SYNCHRONIZE_ENQUEUE_WHEN_QUEUE_FULL = PropertiesUtil.getProperties().getBooleanProperty("AsyncLogger.SynchronizeEnqueueWhenQueueFull", true);
    static final boolean ASYNC_CONFIG_SYNCHRONIZE_ENQUEUE_WHEN_QUEUE_FULL = PropertiesUtil.getProperties().getBooleanProperty("AsyncLoggerConfig.SynchronizeEnqueueWhenQueueFull", true);

    private DisruptorUtil() {
    }

    /*
     * WARNING - void declaration
     */
    static WaitStrategy createWaitStrategy(String propertyName, AsyncWaitStrategyFactory asyncWaitStrategyFactory) {
        void var1_1;
        if (asyncWaitStrategyFactory == null) {
            String string;
            LOGGER.debug("No AsyncWaitStrategyFactory was configured in the configuration, using default factory...");
            return new DefaultAsyncWaitStrategyFactory(string).createWaitStrategy();
        }
        LOGGER.debug("Using configured AsyncWaitStrategyFactory {}", (Object)asyncWaitStrategyFactory.getClass().getName());
        return var1_1.createWaitStrategy();
    }

    /*
     * WARNING - void declaration
     */
    static int calculateRingBufferSize(String propertyName) {
        void var1_1;
        int ringBufferSize = Constants.ENABLE_THREADLOCALS ? 4096 : 262144;
        String userPreferredRBSize = PropertiesUtil.getProperties().getStringProperty(propertyName, String.valueOf(ringBufferSize));
        try {
            void var2_2;
            int size = Integers.parseInt(userPreferredRBSize);
            if (size < 128) {
                size = 128;
                LOGGER.warn("Invalid RingBufferSize {}, using minimum size {}.", (Object)userPreferredRBSize, (Object)128);
            }
            ringBufferSize = var2_2;
        }
        catch (Exception exception) {
            String string;
            LOGGER.warn("Invalid RingBufferSize {}, using default size {}.", (Object)string, (Object)ringBufferSize);
        }
        return Integers.ceilingNextPowerOfTwo((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static ExceptionHandler<RingBufferLogEvent> getAsyncLoggerExceptionHandler() {
        String cls = PropertiesUtil.getProperties().getStringProperty("AsyncLogger.ExceptionHandler");
        if (cls == null) {
            return new AsyncLoggerDefaultExceptionHandler();
        }
        try {
            Class<?> clazz = Loader.loadClass(cls);
            return (ExceptionHandler)clazz.newInstance();
        }
        catch (Exception ignored) {
            void var1_2;
            void var0;
            LOGGER.debug("Invalid AsyncLogger.ExceptionHandler value: error creating {}: ", (Object)var0, (Object)var1_2);
            return new AsyncLoggerDefaultExceptionHandler();
        }
    }

    /*
     * WARNING - void declaration
     */
    static ExceptionHandler<AsyncLoggerConfigDisruptor.Log4jEventWrapper> getAsyncLoggerConfigExceptionHandler() {
        String cls = PropertiesUtil.getProperties().getStringProperty("AsyncLoggerConfig.ExceptionHandler");
        if (cls == null) {
            return new AsyncLoggerConfigDefaultExceptionHandler();
        }
        try {
            Class<?> clazz = Loader.loadClass(cls);
            return (ExceptionHandler)clazz.newInstance();
        }
        catch (Exception ignored) {
            void var1_2;
            void var0;
            LOGGER.debug("Invalid AsyncLoggerConfig.ExceptionHandler value: error creating {}: ", (Object)var0, (Object)var1_2);
            return new AsyncLoggerConfigDefaultExceptionHandler();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static long getExecutorThreadId(ExecutorService executor) {
        Future<Long> result = executor.submit(() -> Thread.currentThread().getId());
        try {
            return (Long)result.get();
        }
        catch (Exception ex) {
            void var0_1;
            throw new IllegalStateException("Could not obtain executor thread Id. Giving up to avoid the risk of application deadlock.", (Throwable)var0_1);
        }
    }
}

