/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.BusySpinWaitStrategy;
import com.lmax.disruptor.SleepingWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.YieldingWaitStrategy;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.async.AsyncWaitStrategyFactory;
import org.apache.logging.log4j.core.async.TimeoutBlockingWaitStrategy;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.Strings;

class DefaultAsyncWaitStrategyFactory
implements AsyncWaitStrategyFactory {
    static final String DEFAULT_WAIT_STRATEGY_CLASSNAME = TimeoutBlockingWaitStrategy.class.getName();
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final String propertyName;

    /*
     * WARNING - void declaration
     */
    public DefaultAsyncWaitStrategyFactory(String propertyName) {
        void var1_1;
        this.propertyName = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public WaitStrategy createWaitStrategy() {
        String strategy = PropertiesUtil.getProperties().getStringProperty(this.propertyName, "TIMEOUT");
        LOGGER.trace("DefaultAsyncWaitStrategyFactory property {}={}", (Object)this.propertyName, (Object)strategy);
        switch (Strings.toRootUpperCase((String)strategy)) {
            case "SLEEP": {
                void var1_2;
                long sleepTimeNs = DefaultAsyncWaitStrategyFactory.parseAdditionalLongProperty(this.propertyName, "SleepTimeNs", 100L);
                String key = DefaultAsyncWaitStrategyFactory.getFullPropertyKey(this.propertyName, "Retries");
                int retries = PropertiesUtil.getProperties().getIntegerProperty(key, 200);
                LOGGER.trace("DefaultAsyncWaitStrategyFactory creating SleepingWaitStrategy(retries={}, sleepTimeNs={})", (Object)retries, (Object)sleepTimeNs);
                return new SleepingWaitStrategy((int)var1_2, sleepTimeNs);
            }
            case "YIELD": {
                LOGGER.trace("DefaultAsyncWaitStrategyFactory creating YieldingWaitStrategy");
                return new YieldingWaitStrategy();
            }
            case "BLOCK": {
                LOGGER.trace("DefaultAsyncWaitStrategyFactory creating BlockingWaitStrategy");
                return new BlockingWaitStrategy();
            }
            case "BUSYSPIN": {
                LOGGER.trace("DefaultAsyncWaitStrategyFactory creating BusySpinWaitStrategy");
                return new BusySpinWaitStrategy();
            }
            case "TIMEOUT": {
                return DefaultAsyncWaitStrategyFactory.createDefaultWaitStrategy(this.propertyName);
            }
        }
        return DefaultAsyncWaitStrategyFactory.createDefaultWaitStrategy(this.propertyName);
    }

    /*
     * WARNING - void declaration
     */
    static WaitStrategy createDefaultWaitStrategy(String propertyName) {
        void var1_1;
        long timeoutMillis = DefaultAsyncWaitStrategyFactory.parseAdditionalLongProperty(propertyName, "Timeout", 10L);
        LOGGER.trace("DefaultAsyncWaitStrategyFactory creating TimeoutBlockingWaitStrategy(timeout={}, unit=MILLIS)", (Object)timeoutMillis);
        return new TimeoutBlockingWaitStrategy((long)var1_1, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - void declaration
     */
    private static String getFullPropertyKey(String strategyKey, String additionalKey) {
        void var1_1;
        String string;
        if (strategyKey.startsWith("AsyncLogger.")) {
            return "AsyncLogger." + additionalKey;
        }
        if (strategyKey.startsWith("AsyncLoggerConfig.")) {
            return "AsyncLoggerConfig." + additionalKey;
        }
        return string + (String)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static long parseAdditionalLongProperty(String propertyName, String additionalKey, long defaultValue) {
        void var2_2;
        String string;
        void var1_1;
        String key = DefaultAsyncWaitStrategyFactory.getFullPropertyKey(propertyName, (String)var1_1);
        return PropertiesUtil.getProperties().getLongProperty(string, (long)var2_2);
    }
}

