/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.async.AsyncQueueFullPolicy;
import org.apache.logging.log4j.core.async.DefaultAsyncQueueFullPolicy;
import org.apache.logging.log4j.core.async.DiscardingAsyncQueueFullPolicy;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.PropertiesUtil;

public class AsyncQueueFullPolicyFactory {
    static final String PROPERTY_NAME_ASYNC_EVENT_ROUTER = "log4j2.AsyncQueueFullPolicy";
    static final String PROPERTY_VALUE_DEFAULT_ASYNC_EVENT_ROUTER = "Default";
    static final String PROPERTY_VALUE_DISCARDING_ASYNC_EVENT_ROUTER = "Discard";
    static final String PROPERTY_NAME_DISCARDING_THRESHOLD_LEVEL = "log4j2.DiscardThreshold";
    private static final Logger LOGGER = StatusLogger.getLogger();

    /*
     * WARNING - void declaration
     */
    public static AsyncQueueFullPolicy create() {
        void var0;
        String router = PropertiesUtil.getProperties().getStringProperty(PROPERTY_NAME_ASYNC_EVENT_ROUTER);
        if (router == null || AsyncQueueFullPolicyFactory.isRouterSelected(router, DefaultAsyncQueueFullPolicy.class, PROPERTY_VALUE_DEFAULT_ASYNC_EVENT_ROUTER)) {
            return new DefaultAsyncQueueFullPolicy();
        }
        if (AsyncQueueFullPolicyFactory.isRouterSelected(router, DiscardingAsyncQueueFullPolicy.class, PROPERTY_VALUE_DISCARDING_ASYNC_EVENT_ROUTER)) {
            return AsyncQueueFullPolicyFactory.createDiscardingAsyncQueueFullPolicy();
        }
        return AsyncQueueFullPolicyFactory.createCustomRouter((String)var0);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isRouterSelected(String propertyValue, Class<? extends AsyncQueueFullPolicy> policy, String shortPropertyValue) {
        String string;
        void var1_1;
        void var2_2;
        return propertyValue != null && (var2_2.equalsIgnoreCase(propertyValue) || policy.getName().equals(propertyValue) || var1_1.getSimpleName().equals(string));
    }

    /*
     * WARNING - void declaration
     */
    private static AsyncQueueFullPolicy createCustomRouter(String router) {
        try {
            Class<AsyncQueueFullPolicy> cls = Loader.loadClass(router).asSubclass(AsyncQueueFullPolicy.class);
            LOGGER.debug("Creating custom AsyncQueueFullPolicy '{}'", (Object)router);
            return cls.newInstance();
        }
        catch (Exception ex) {
            void var1_2;
            String string;
            LOGGER.debug("Using DefaultAsyncQueueFullPolicy. Could not create custom AsyncQueueFullPolicy '{}': {}", (Object)string, (Object)var1_2.toString());
            return new DefaultAsyncQueueFullPolicy();
        }
    }

    private static AsyncQueueFullPolicy createDiscardingAsyncQueueFullPolicy() {
        Object object = PropertiesUtil.getProperties();
        object = object.getStringProperty(PROPERTY_NAME_DISCARDING_THRESHOLD_LEVEL, Level.INFO.name());
        Level thresholdLevel = Level.toLevel((String)object, (Level)Level.INFO);
        LOGGER.debug("Creating custom DiscardingAsyncQueueFullPolicy(discardThreshold:{})", (Object)thresholdLevel);
        return new DiscardingAsyncQueueFullPolicy((Level)object);
    }
}

