/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.EventTranslator;
import com.lmax.disruptor.EventTranslatorVararg;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.TimeoutException;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.async.AsyncLogger;
import org.apache.logging.log4j.core.async.AsyncQueueFullPolicy;
import org.apache.logging.log4j.core.async.AsyncQueueFullPolicyFactory;
import org.apache.logging.log4j.core.async.AsyncWaitStrategyFactory;
import org.apache.logging.log4j.core.async.DiscardingAsyncQueueFullPolicy;
import org.apache.logging.log4j.core.async.DisruptorUtil;
import org.apache.logging.log4j.core.async.EventRoute;
import org.apache.logging.log4j.core.async.RingBufferLogEvent;
import org.apache.logging.log4j.core.async.RingBufferLogEventHandler;
import org.apache.logging.log4j.core.async.RingBufferLogEventTranslator;
import org.apache.logging.log4j.core.jmx.RingBufferAdmin;
import org.apache.logging.log4j.core.util.Log4jThread;
import org.apache.logging.log4j.core.util.Log4jThreadFactory;
import org.apache.logging.log4j.core.util.Throwables;
import org.apache.logging.log4j.message.Message;

class AsyncLoggerDisruptor
extends AbstractLifeCycle {
    private static final int SLEEP_MILLIS_BETWEEN_DRAIN_ATTEMPTS = 50;
    private static final int MAX_DRAIN_ATTEMPTS_BEFORE_SHUTDOWN = 200;
    private final Object queueFullEnqueueLock = new Object();
    private volatile Disruptor<RingBufferLogEvent> disruptor;
    private String contextName;
    private final Supplier<AsyncWaitStrategyFactory> waitStrategyFactorySupplier;
    private boolean useThreadLocalTranslator = true;
    private long backgroundThreadId;
    private AsyncQueueFullPolicy asyncQueueFullPolicy;
    private int ringBufferSize;
    private WaitStrategy waitStrategy;

    /*
     * WARNING - void declaration
     */
    AsyncLoggerDisruptor(String contextName, Supplier<AsyncWaitStrategyFactory> waitStrategyFactorySupplier) {
        void var2_2;
        void var1_1;
        this.contextName = var1_1;
        this.waitStrategyFactorySupplier = (Supplier)Objects.requireNonNull(var2_2, "waitStrategyFactorySupplier");
    }

    WaitStrategy getWaitStrategy() {
        return this.waitStrategy;
    }

    public String getContextName() {
        return this.contextName;
    }

    /*
     * WARNING - void declaration
     */
    public void setContextName(String name) {
        void var1_1;
        this.contextName = var1_1;
    }

    Disruptor<RingBufferLogEvent> getDisruptor() {
        return this.disruptor;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void start() {
        void var1_1;
        void var2_2;
        if (this.disruptor != null) {
            LOGGER.trace("[{}] AsyncLoggerDisruptor not starting new disruptor for this context, using existing object.", (Object)this.contextName);
            return;
        }
        if (this.isStarting()) {
            LOGGER.trace("[{}] AsyncLoggerDisruptor is already starting.", (Object)this.contextName);
            return;
        }
        this.setStarting();
        LOGGER.trace("[{}] AsyncLoggerDisruptor creating new disruptor for this context.", (Object)this.contextName);
        this.ringBufferSize = DisruptorUtil.calculateRingBufferSize("AsyncLogger.RingBufferSize");
        AsyncWaitStrategyFactory factory = this.waitStrategyFactorySupplier.get();
        this.waitStrategy = DisruptorUtil.createWaitStrategy("AsyncLogger.WaitStrategy", factory);
        Log4jThreadFactory threadFactory = new Log4jThreadFactory(this, "AsyncLogger[" + this.contextName + "]", true, 5){
            final /* synthetic */ AsyncLoggerDisruptor this$0;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super((String)var2_2, (boolean)var3_3, priority);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Thread newThread(Runnable r) {
                void var1_1;
                Thread result = super.newThread(r);
                AsyncLoggerDisruptor.access$002(this.this$0, result.getId());
                return var1_1;
            }
        };
        this.asyncQueueFullPolicy = AsyncQueueFullPolicyFactory.create();
        this.disruptor = new Disruptor((EventFactory)RingBufferLogEvent.FACTORY, this.ringBufferSize, (ThreadFactory)threadFactory, ProducerType.MULTI, this.waitStrategy);
        ExceptionHandler<RingBufferLogEvent> errorHandler = DisruptorUtil.getAsyncLoggerExceptionHandler();
        this.disruptor.setDefaultExceptionHandler(errorHandler);
        RingBufferLogEventHandler[] handlers = new RingBufferLogEventHandler[]{new RingBufferLogEventHandler()};
        this.disruptor.handleEventsWith((EventHandler[])var2_2);
        LOGGER.debug("[{}] Starting AsyncLogger disruptor for this context with ringbufferSize={}, waitStrategy={}, exceptionHandler={}...", (Object)this.contextName, (Object)this.disruptor.getRingBuffer().getBufferSize(), (Object)this.waitStrategy.getClass().getSimpleName(), (Object)var1_1);
        this.disruptor.start();
        LOGGER.trace("[{}] AsyncLoggers use a {} translator", (Object)this.contextName, (Object)(this.useThreadLocalTranslator ? "threadlocal" : "vararg"));
        super.start();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean stop(long timeout, TimeUnit timeUnit) {
        Disruptor<RingBufferLogEvent> temp = this.getDisruptor();
        if (temp == null) {
            LOGGER.trace("[{}] AsyncLoggerDisruptor: disruptor for this context already shut down.", (Object)this.contextName);
            return true;
        }
        this.setStopping();
        LOGGER.debug("[{}] AsyncLoggerDisruptor: shutting down disruptor for this context.", (Object)this.contextName);
        this.disruptor = null;
        for (int i = 0; AsyncLoggerDisruptor.hasBacklog(temp) && i < 200; ++i) {
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            temp.shutdown(timeout, timeUnit);
        }
        catch (TimeoutException timeoutException) {
            void var3_2;
            void var1_1;
            LOGGER.warn("[{}] AsyncLoggerDisruptor: shutdown timed out after {} {}", (Object)this.contextName, (Object)((long)var1_1), (Object)var3_2);
            temp.halt();
        }
        LOGGER.trace("[{}] AsyncLoggerDisruptor: disruptor has been shut down.", (Object)this.contextName);
        if (DiscardingAsyncQueueFullPolicy.getDiscardCount(this.asyncQueueFullPolicy) > 0L) {
            LOGGER.trace("AsyncLoggerDisruptor: {} discarded {} events.", (Object)this.asyncQueueFullPolicy, (Object)DiscardingAsyncQueueFullPolicy.getDiscardCount(this.asyncQueueFullPolicy));
        }
        this.setStopped();
        return true;
    }

    private static boolean hasBacklog(Disruptor<?> theDisruptor) {
        RingBuffer ringBuffer;
        RingBuffer ringBuffer2 = theDisruptor.getRingBuffer();
        return !ringBuffer2.hasAvailableCapacity(ringBuffer.getBufferSize());
    }

    /*
     * WARNING - void declaration
     */
    public RingBufferAdmin createRingBufferAdmin(String jmxContextName) {
        void var1_1;
        RingBuffer ringBuffer = this.disruptor == null ? null : this.disruptor.getRingBuffer();
        return RingBufferAdmin.forAsyncLogger(ringBuffer, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    EventRoute getEventRoute(Level logLevel) {
        void var1_1;
        int n = this.remainingDisruptorCapacity();
        if (n < 0) {
            return EventRoute.DISCARD;
        }
        return this.asyncQueueFullPolicy.getRoute(this.backgroundThreadId, (Level)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private int remainingDisruptorCapacity() {
        void var1_1;
        Disruptor<RingBufferLogEvent> temp = this.disruptor;
        if (this.hasLog4jBeenShutDown(temp)) {
            return -1;
        }
        return (int)var1_1.getRingBuffer().remainingCapacity();
    }

    private boolean hasLog4jBeenShutDown(Disruptor<RingBufferLogEvent> aDisruptor) {
        if (aDisruptor == null) {
            LOGGER.warn("Ignoring log event after log4j was shut down");
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    boolean tryPublish(RingBufferLogEventTranslator translator) {
        try {
            return this.disruptor.getRingBuffer().tryPublishEvent((EventTranslator)translator);
        }
        catch (NullPointerException nullPointerException) {
            void var1_1;
            this.logWarningOnNpeFromDisruptorPublish((RingBufferLogEventTranslator)var1_1);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    void enqueueLogMessageWhenQueueFull(RingBufferLogEventTranslator translator) {
        try {
            if (this.synchronizeEnqueueWhenQueueFull()) {
                Object object = this.queueFullEnqueueLock;
                synchronized (object) {
                    this.disruptor.publishEvent((EventTranslator)translator);
                }
            } else {
                this.disruptor.publishEvent((EventTranslator)translator);
            }
            return;
        }
        catch (NullPointerException nullPointerException) {
            void var1_1;
            this.logWarningOnNpeFromDisruptorPublish((RingBufferLogEventTranslator)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void enqueueLogMessageWhenQueueFull(EventTranslatorVararg<RingBufferLogEvent> translator, AsyncLogger asyncLogger, StackTraceElement location, String fqcn, Level level, Marker marker, Message msg, Throwable thrown) {
        try {
            if (this.synchronizeEnqueueWhenQueueFull()) {
                Object object = this.queueFullEnqueueLock;
                synchronized (object) {
                    this.disruptor.getRingBuffer().publishEvent(translator, new Object[]{asyncLogger, location, fqcn, level, marker, msg, thrown});
                }
            } else {
                void var3_4;
                void var2_3;
                void var1_1;
                this.disruptor.getRingBuffer().publishEvent((EventTranslatorVararg)var1_1, new Object[]{var2_3, var3_4, fqcn, level, marker, msg, thrown});
            }
            return;
        }
        catch (NullPointerException nullPointerException) {
            this.logWarningOnNpeFromDisruptorPublish(level, fqcn, msg, thrown);
            return;
        }
    }

    private boolean synchronizeEnqueueWhenQueueFull() {
        return DisruptorUtil.ASYNC_LOGGER_SYNCHRONIZE_ENQUEUE_WHEN_QUEUE_FULL && this.backgroundThreadId != Thread.currentThread().getId() && !(Thread.currentThread() instanceof Log4jThread);
    }

    /*
     * WARNING - void declaration
     */
    private void logWarningOnNpeFromDisruptorPublish(RingBufferLogEventTranslator translator) {
        void var1_1;
        this.logWarningOnNpeFromDisruptorPublish(translator.level, translator.loggerName, translator.message, var1_1.thrown);
    }

    /*
     * WARNING - void declaration
     */
    private void logWarningOnNpeFromDisruptorPublish(Level level, String fqcn, Message msg, Throwable thrown) {
        void var3_3;
        void var2_2;
        void var1_1;
        LOGGER.warn("[{}] Ignoring log event after log4j was shut down: {} [{}] {}{}", (Object)this.contextName, (Object)var1_1, (Object)var2_2, (Object)var3_3.getFormattedMessage(), thrown == null ? "" : Throwables.toStringList(thrown));
    }

    public boolean isUseThreadLocals() {
        return this.useThreadLocalTranslator;
    }

    /*
     * WARNING - void declaration
     */
    public void setUseThreadLocals(boolean allow) {
        void var1_1;
        this.useThreadLocalTranslator = var1_1;
        LOGGER.trace("[{}] AsyncLoggers have been modified to use a {} translator", (Object)this.contextName, (Object)(this.useThreadLocalTranslator ? "threadlocal" : "vararg"));
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ long access$002(AsyncLoggerDisruptor x0, long x1) {
        void var1_1;
        x0.backgroundThreadId = var1_1;
        return x0.backgroundThreadId;
    }
}

