/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.EventTranslatorTwoArg;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceReportingEventHandler;
import com.lmax.disruptor.TimeoutException;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.async.AsyncLoggerConfig;
import org.apache.logging.log4j.core.async.AsyncLoggerConfigDelegate;
import org.apache.logging.log4j.core.async.AsyncQueueFullPolicy;
import org.apache.logging.log4j.core.async.AsyncQueueFullPolicyFactory;
import org.apache.logging.log4j.core.async.AsyncWaitStrategyFactory;
import org.apache.logging.log4j.core.async.DiscardingAsyncQueueFullPolicy;
import org.apache.logging.log4j.core.async.DisruptorUtil;
import org.apache.logging.log4j.core.async.EventRoute;
import org.apache.logging.log4j.core.async.InternalAsyncUtil;
import org.apache.logging.log4j.core.async.RingBufferLogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.impl.LogEventFactory;
import org.apache.logging.log4j.core.impl.MutableLogEvent;
import org.apache.logging.log4j.core.impl.ReusableLogEventFactory;
import org.apache.logging.log4j.core.jmx.RingBufferAdmin;
import org.apache.logging.log4j.core.util.Log4jThread;
import org.apache.logging.log4j.core.util.Log4jThreadFactory;
import org.apache.logging.log4j.core.util.Throwables;
import org.apache.logging.log4j.message.ReusableMessage;

public class AsyncLoggerConfigDisruptor
extends AbstractLifeCycle
implements AsyncLoggerConfigDelegate {
    private static final int MAX_DRAIN_ATTEMPTS_BEFORE_SHUTDOWN = 200;
    private static final int SLEEP_MILLIS_BETWEEN_DRAIN_ATTEMPTS = 50;
    private static final EventFactory<Log4jEventWrapper> FACTORY = Log4jEventWrapper::new;
    private static final EventFactory<Log4jEventWrapper> MUTABLE_FACTORY = () -> new Log4jEventWrapper(new MutableLogEvent());
    private static final EventTranslatorTwoArg<Log4jEventWrapper, LogEvent, AsyncLoggerConfig> TRANSLATOR = (ringBufferElement, sequence, logEvent, loggerConfig) -> {
        Log4jEventWrapper log4jEventWrapper;
        void var3_2;
        Log4jEventWrapper.access$002(ringBufferElement, (LogEvent)var3_2);
        Log4jEventWrapper.access$102(log4jEventWrapper, loggerConfig);
    };
    private static final EventTranslatorTwoArg<Log4jEventWrapper, LogEvent, AsyncLoggerConfig> MUTABLE_TRANSLATOR = (ringBufferElement, sequence, logEvent, loggerConfig) -> {
        Log4jEventWrapper log4jEventWrapper;
        void var3_2;
        ((MutableLogEvent)((Log4jEventWrapper)ringBufferElement).event).initFrom((LogEvent)var3_2);
        Log4jEventWrapper.access$102(log4jEventWrapper, loggerConfig);
    };
    private int ringBufferSize;
    private AsyncQueueFullPolicy asyncQueueFullPolicy;
    private Boolean mutable = Boolean.FALSE;
    private volatile Disruptor<Log4jEventWrapper> disruptor;
    private long backgroundThreadId;
    private EventFactory<Log4jEventWrapper> factory;
    private EventTranslatorTwoArg<Log4jEventWrapper, LogEvent, AsyncLoggerConfig> translator;
    private volatile boolean alreadyLoggedWarning;
    private final AsyncWaitStrategyFactory asyncWaitStrategyFactory;
    private WaitStrategy waitStrategy;
    private final Object queueFullEnqueueLock = new Object();

    /*
     * WARNING - void declaration
     */
    public AsyncLoggerConfigDisruptor(AsyncWaitStrategyFactory asyncWaitStrategyFactory) {
        void var1_1;
        this.asyncWaitStrategyFactory = var1_1;
    }

    WaitStrategy getWaitStrategy() {
        return this.waitStrategy;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setLogEventFactory(LogEventFactory logEventFactory) {
        void var1_1;
        this.mutable = this.mutable != false || var1_1 instanceof ReusableLogEventFactory;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void start() {
        void var1_1;
        void var2_2;
        if (this.disruptor != null) {
            LOGGER.trace("AsyncLoggerConfigDisruptor not starting new disruptor for this configuration, using existing object.");
            return;
        }
        LOGGER.trace("AsyncLoggerConfigDisruptor creating new disruptor for this configuration.");
        this.ringBufferSize = DisruptorUtil.calculateRingBufferSize("AsyncLoggerConfig.RingBufferSize");
        this.waitStrategy = DisruptorUtil.createWaitStrategy("AsyncLoggerConfig.WaitStrategy", this.asyncWaitStrategyFactory);
        Log4jThreadFactory threadFactory = new Log4jThreadFactory(this, "AsyncLoggerConfig", true, 5){
            final /* synthetic */ AsyncLoggerConfigDisruptor this$0;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super((String)var2_2, (boolean)var3_3, priority);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Thread newThread(Runnable r) {
                void var1_1;
                Thread result = super.newThread(r);
                AsyncLoggerConfigDisruptor.access$202(this.this$0, result.getId());
                return var1_1;
            }
        };
        this.asyncQueueFullPolicy = AsyncQueueFullPolicyFactory.create();
        this.translator = this.mutable != false ? MUTABLE_TRANSLATOR : TRANSLATOR;
        this.factory = this.mutable != false ? MUTABLE_FACTORY : FACTORY;
        this.disruptor = new Disruptor(this.factory, this.ringBufferSize, (ThreadFactory)threadFactory, ProducerType.MULTI, this.waitStrategy);
        ExceptionHandler<Log4jEventWrapper> errorHandler = DisruptorUtil.getAsyncLoggerConfigExceptionHandler();
        this.disruptor.setDefaultExceptionHandler(errorHandler);
        Log4jEventWrapperHandler[] handlers = new Log4jEventWrapperHandler[]{new Log4jEventWrapperHandler()};
        this.disruptor.handleEventsWith((EventHandler[])var2_2);
        LOGGER.debug("Starting AsyncLoggerConfig disruptor for this configuration with ringbufferSize={}, waitStrategy={}, exceptionHandler={}...", (Object)this.disruptor.getRingBuffer().getBufferSize(), (Object)this.waitStrategy.getClass().getSimpleName(), (Object)var1_1);
        this.disruptor.start();
        super.start();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean stop(long timeout, TimeUnit timeUnit) {
        Disruptor<Log4jEventWrapper> temp = this.disruptor;
        if (temp == null) {
            LOGGER.trace("AsyncLoggerConfigDisruptor: disruptor for this configuration already shut down.");
            return true;
        }
        this.setStopping();
        LOGGER.trace("AsyncLoggerConfigDisruptor: shutting down disruptor for this configuration.");
        this.disruptor = null;
        for (int i = 0; AsyncLoggerConfigDisruptor.hasBacklog(temp) && i < 200; ++i) {
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            temp.shutdown(timeout, timeUnit);
        }
        catch (TimeoutException timeoutException) {
            void var3_2;
            void var1_1;
            LOGGER.warn("AsyncLoggerConfigDisruptor: shutdown timed out after {} {}", (Object)((long)var1_1), (Object)var3_2);
            temp.halt();
        }
        LOGGER.trace("AsyncLoggerConfigDisruptor: disruptor has been shut down.");
        if (DiscardingAsyncQueueFullPolicy.getDiscardCount(this.asyncQueueFullPolicy) > 0L) {
            LOGGER.trace("AsyncLoggerConfigDisruptor: {} discarded {} events.", (Object)this.asyncQueueFullPolicy, (Object)DiscardingAsyncQueueFullPolicy.getDiscardCount(this.asyncQueueFullPolicy));
        }
        this.setStopped();
        return true;
    }

    private static boolean hasBacklog(Disruptor<?> theDisruptor) {
        RingBuffer ringBuffer;
        RingBuffer ringBuffer2 = theDisruptor.getRingBuffer();
        return !ringBuffer2.hasAvailableCapacity(ringBuffer.getBufferSize());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public EventRoute getEventRoute(Level logLevel) {
        void var1_1;
        int n = this.remainingDisruptorCapacity();
        if (n < 0) {
            return EventRoute.DISCARD;
        }
        return this.asyncQueueFullPolicy.getRoute(this.backgroundThreadId, (Level)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private int remainingDisruptorCapacity() {
        void var1_1;
        Disruptor<Log4jEventWrapper> temp = this.disruptor;
        if (this.hasLog4jBeenShutDown(temp)) {
            return -1;
        }
        return (int)var1_1.getRingBuffer().remainingCapacity();
    }

    private boolean hasLog4jBeenShutDown(Disruptor<Log4jEventWrapper> aDisruptor) {
        if (aDisruptor == null) {
            LOGGER.warn("Ignoring log event after log4j was shut down");
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void enqueueEvent(LogEvent event, AsyncLoggerConfig asyncLoggerConfig) {
        try {
            void var2_2;
            void var3_3;
            LogEvent logEvent = this.prepareEvent(event);
            this.enqueue((LogEvent)var3_3, (AsyncLoggerConfig)var2_2);
            return;
        }
        catch (NullPointerException nullPointerException) {
            void var1_1;
            LOGGER.warn("Ignoring log event after log4j was shut down: {} [{}] {}", (Object)event.getLevel(), (Object)event.getLoggerName(), (Object)(event.getMessage().getFormattedMessage() + (event.getThrown() == null ? "" : Throwables.toStringList(var1_1.getThrown()))));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private LogEvent prepareEvent(LogEvent event) {
        void var1_1;
        LogEvent logEvent = this.ensureImmutable(event);
        if (logEvent.getMessage() instanceof ReusableMessage) {
            if (logEvent instanceof Log4jLogEvent) {
                ((Log4jLogEvent)logEvent).makeMessageImmutable();
            } else if (logEvent instanceof MutableLogEvent) {
                if (this.translator != MUTABLE_TRANSLATOR) {
                    logEvent = ((MutableLogEvent)logEvent).createMemento();
                }
            } else {
                this.showWarningAboutCustomLogEventWithReusableMessage(logEvent);
            }
        } else {
            InternalAsyncUtil.makeMessageImmutable(logEvent.getMessage());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void showWarningAboutCustomLogEventWithReusableMessage(LogEvent logEvent) {
        if (!this.alreadyLoggedWarning) {
            void var1_1;
            LOGGER.warn("Custom log event of type {} contains a mutable message of type {}. AsyncLoggerConfig does not know how to make an immutable copy of this message. This may result in ConcurrentModificationExceptions or incorrect log messages if the application modifies objects in the message while the background thread is writing it to the appenders.", (Object)logEvent.getClass().getName(), (Object)var1_1.getMessage().getClass().getName());
            this.alreadyLoggedWarning = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void enqueue(LogEvent logEvent, AsyncLoggerConfig asyncLoggerConfig) {
        if (this.synchronizeEnqueueWhenQueueFull()) {
            Object object = this.queueFullEnqueueLock;
            synchronized (object) {
                this.disruptor.getRingBuffer().publishEvent(this.translator, (Object)logEvent, (Object)asyncLoggerConfig);
            }
        } else {
            void var2_3;
            void var1_1;
            this.disruptor.getRingBuffer().publishEvent(this.translator, (Object)var1_1, (Object)var2_3);
        }
    }

    private boolean synchronizeEnqueueWhenQueueFull() {
        return DisruptorUtil.ASYNC_CONFIG_SYNCHRONIZE_ENQUEUE_WHEN_QUEUE_FULL && this.backgroundThreadId != Thread.currentThread().getId() && !(Thread.currentThread() instanceof Log4jThread);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean tryEnqueue(LogEvent event, AsyncLoggerConfig asyncLoggerConfig) {
        void var2_2;
        void var1_1;
        LogEvent logEvent = this.prepareEvent(event);
        return this.disruptor.getRingBuffer().tryPublishEvent(this.translator, (Object)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private LogEvent ensureImmutable(LogEvent event) {
        void var2_2;
        LogEvent result = event;
        if (event instanceof RingBufferLogEvent) {
            void var1_1;
            result = ((RingBufferLogEvent)var1_1).createMemento();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public RingBufferAdmin createRingBufferAdmin(String contextName, String loggerConfigName) {
        void var2_2;
        void var1_1;
        return RingBufferAdmin.forAsyncLoggerConfig(this.disruptor.getRingBuffer(), (String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ long access$202(AsyncLoggerConfigDisruptor x0, long x1) {
        void var1_1;
        x0.backgroundThreadId = var1_1;
        return x0.backgroundThreadId;
    }

    private static class Log4jEventWrapperHandler
    implements SequenceReportingEventHandler<Log4jEventWrapper> {
        private static final int NOTIFY_PROGRESS_THRESHOLD = 50;
        private Sequence sequenceCallback;
        private int counter;

        private Log4jEventWrapperHandler() {
        }

        /*
         * WARNING - void declaration
         */
        public void setSequenceCallback(Sequence sequenceCallback) {
            void var1_1;
            this.sequenceCallback = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void onEvent(Log4jEventWrapper event, long sequence, boolean endOfBatch) throws Exception {
            void var2_2;
            void var1_1;
            event.event.setEndOfBatch(endOfBatch);
            event.loggerConfig.logToAsyncLoggerConfigsOnCurrentThread(event.event);
            var1_1.clear();
            this.notifyIntermediateProgress((long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private void notifyIntermediateProgress(long sequence) {
            if (++this.counter > 50) {
                void var1_1;
                this.sequenceCallback.set((long)var1_1);
                this.counter = 0;
            }
        }
    }

    public static class Log4jEventWrapper {
        private AsyncLoggerConfig loggerConfig;
        private LogEvent event;

        public Log4jEventWrapper() {
        }

        /*
         * WARNING - void declaration
         */
        public Log4jEventWrapper(MutableLogEvent mutableLogEvent) {
            void var1_1;
            this.event = var1_1;
        }

        public void clear() {
            this.loggerConfig = null;
            if (this.event instanceof MutableLogEvent) {
                ((MutableLogEvent)this.event).clear();
                return;
            }
            this.event = null;
        }

        public String toString() {
            return String.valueOf(this.event);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ AsyncLoggerConfig access$102(Log4jEventWrapper x0, AsyncLoggerConfig x1) {
            void var1_1;
            x0.loggerConfig = var1_1;
            return x0.loggerConfig;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ LogEvent access$002(Log4jEventWrapper x0, LogEvent x1) {
            void var1_1;
            x0.event = var1_1;
            return x0.event;
        }
    }
}

