/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.async.AsyncLoggerConfigDelegate;
import org.apache.logging.log4j.core.async.AsyncQueueFullMessageUtil;
import org.apache.logging.log4j.core.async.EventRoute;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.jmx.RingBufferAdmin;
import org.apache.logging.log4j.core.util.Booleans;
import org.apache.logging.log4j.spi.AbstractLogger;

@Plugin(name="asyncLogger", category="Core", printObject=true)
public class AsyncLoggerConfig
extends LoggerConfig {
    private static final ThreadLocal<Boolean> ASYNC_LOGGER_ENTERED = new ThreadLocal<Boolean>(){

        @Override
        protected final Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private final AsyncLoggerConfigDelegate delegate;

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newAsyncBuilder() {
        return (B)((Builder)new Builder().asBuilder());
    }

    /*
     * WARNING - void declaration
     */
    protected AsyncLoggerConfig(String name, List<AppenderRef> appenders, Filter filter, Level level, boolean additive, Property[] properties, Configuration config, boolean includeLocation) {
        super((String)var1_1, (List<AppenderRef>)var2_2, (Filter)var3_3, level, additive, properties, config, includeLocation);
        void var3_3;
        void var2_2;
        void var1_1;
        this.delegate = config.getAsyncLoggerConfigDelegate();
        this.delegate.setLogEventFactory(this.getLogEventFactory());
    }

    AsyncLoggerConfigDelegate getAsyncLoggerConfigDelegate() {
        return this.delegate;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void log(LogEvent event, LoggerConfig.LoggerConfigPredicate predicate) {
        if (predicate == LoggerConfig.LoggerConfigPredicate.ALL && ASYNC_LOGGER_ENTERED.get() == Boolean.FALSE && this.hasAppenders()) {
            ASYNC_LOGGER_ENTERED.set(Boolean.TRUE);
            try {
                super.log(event, LoggerConfig.LoggerConfigPredicate.SYNCHRONOUS_ONLY);
                this.logToAsyncDelegate(event);
            }
            finally {
                ASYNC_LOGGER_ENTERED.set(Boolean.FALSE);
            }
        } else {
            void var2_3;
            void var1_1;
            super.log((LogEvent)var1_1, (LoggerConfig.LoggerConfigPredicate)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void callAppenders(LogEvent event) {
        void var1_1;
        super.callAppenders((LogEvent)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void logToAsyncDelegate(LogEvent event) {
        if (!this.isFiltered(event)) {
            this.populateLazilyInitializedFields(event);
            if (!this.delegate.tryEnqueue(event, this)) {
                void var1_1;
                this.handleQueueFull((LogEvent)var1_1);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handleQueueFull(LogEvent event) {
        void var1_1;
        if (AbstractLogger.getRecursionDepth() > 1) {
            AsyncQueueFullMessageUtil.logWarningToStatusLogger();
            this.logToAsyncLoggerConfigsOnCurrentThread(event);
            return;
        }
        EventRoute eventRoute = this.delegate.getEventRoute(event.getLevel());
        eventRoute.logMessage(this, (LogEvent)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void populateLazilyInitializedFields(LogEvent event) {
        void var1_1;
        event.getSource();
        var1_1.getThreadName();
    }

    /*
     * WARNING - void declaration
     */
    void logInBackgroundThread(LogEvent event) {
        void var1_1;
        this.delegate.enqueueEvent((LogEvent)var1_1, this);
    }

    /*
     * WARNING - void declaration
     */
    void logToAsyncLoggerConfigsOnCurrentThread(LogEvent event) {
        void var1_1;
        this.log((LogEvent)var1_1, LoggerConfig.LoggerConfigPredicate.ASYNCHRONOUS_ONLY);
    }

    private String displayName() {
        if ("".equals(this.getName())) {
            return "root";
        }
        return this.getName();
    }

    @Override
    public void start() {
        LOGGER.trace("AsyncLoggerConfig[{}] starting...", (Object)this.displayName());
        super.start();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean stop(long timeout, TimeUnit timeUnit) {
        void var3_2;
        void var1_1;
        this.setStopping();
        super.stop((long)var1_1, (TimeUnit)var3_2, false);
        LOGGER.trace("AsyncLoggerConfig[{}] stopping...", (Object)this.displayName());
        this.setStopped();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public RingBufferAdmin createRingBufferAdmin(String contextName) {
        void var1_1;
        return this.delegate.createRingBufferAdmin((String)var1_1, this.getName());
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static LoggerConfig createLogger(String additivity, String levelName, String loggerName, String includeLocation, AppenderRef[] refs, Property[] properties, Configuration config, Filter filter) {
        void var3_4;
        void var0_1;
        void var1_2;
        void var2_3;
        Level level;
        if (loggerName == null) {
            LOGGER.error("Loggers cannot be configured without a name");
            return null;
        }
        List<AppenderRef> appenderRefs = Arrays.asList(refs);
        try {
            level = Level.toLevel((String)levelName, (Level)Level.ERROR);
        }
        catch (Exception exception) {
            LOGGER.error("Invalid Log level specified: {}. Defaulting to Error", (Object)levelName);
            level = Level.ERROR;
        }
        String name = loggerName.equals("root") ? "" : var2_3;
        boolean additive = Booleans.parseBoolean(additivity, true);
        return new AsyncLoggerConfig((String)var1_2, appenderRefs, filter, level, (boolean)var0_1, properties, config, AsyncLoggerConfig.includeLocation((String)var3_4));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static LoggerConfig createLogger(@PluginAttribute(value="additivity", defaultBoolean=true) boolean additivity, @PluginAttribute(value="level") Level level, @Required(message="Loggers cannot be configured without a name") @PluginAttribute(value="name") String loggerName, @PluginAttribute(value="includeLocation") String includeLocation, @PluginElement(value="AppenderRef") AppenderRef[] refs, @PluginElement(value="Properties") Property[] properties, @PluginConfiguration Configuration config, @PluginElement(value="Filter") Filter filter) {
        void var3_3;
        boolean bl;
        void var1_1;
        void var2_2;
        String name;
        name = loggerName.equals("root") ? "" : name;
        return new AsyncLoggerConfig((String)var2_2, Arrays.asList(refs), filter, (Level)var1_1, bl, properties, config, AsyncLoggerConfig.includeLocation((String)var3_3));
    }

    protected static boolean includeLocation(String includeLocationConfigValue) {
        return Boolean.parseBoolean(includeLocationConfigValue);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ LoggerConfig.LevelAndRefs access$000(Level x0, AppenderRef[] x1, String x2, Configuration x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return AsyncLoggerConfig.getLevelAndRefs(x0, (AppenderRef[])var1_1, (String)var2_2, (Configuration)var3_3);
    }

    @Plugin(name="asyncRoot", category="Core", printObject=true)
    public static class RootLogger
    extends LoggerConfig {
        @PluginBuilderFactory
        public static <B extends Builder<B>> B newAsyncRootBuilder() {
            return (B)((Builder)new Builder().asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public static LoggerConfig createLogger(String additivity, String levelName, String includeLocation, AppenderRef[] refs, Property[] properties, Configuration config, Filter filter) {
            void var2_3;
            void var0_1;
            void var3_4;
            Level level;
            List<AppenderRef> appenderRefs = Arrays.asList(refs);
            try {
                level = Level.toLevel((String)levelName, (Level)Level.ERROR);
            }
            catch (Exception exception) {
                void var1_2;
                LOGGER.error("Invalid Log level specified: {}. Defaulting to Error", (Object)var1_2);
                level = Level.ERROR;
            }
            boolean additive = Booleans.parseBoolean(additivity, true);
            return new AsyncLoggerConfig("", (List<AppenderRef>)var3_4, filter, level, (boolean)var0_1, properties, config, AsyncLoggerConfig.includeLocation((String)var2_3));
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public static LoggerConfig createLogger(@PluginAttribute(value="additivity") String additivity, @PluginAttribute(value="level") Level level, @PluginAttribute(value="includeLocation") String includeLocation, @PluginElement(value="AppenderRef") AppenderRef[] refs, @PluginElement(value="Properties") Property[] properties, @PluginConfiguration Configuration config, @PluginElement(value="Filter") Filter filter) {
            void var2_3;
            void var0_1;
            void var1_2;
            void var3_4;
            Level actualLevel;
            List<AppenderRef> appenderRefs = Arrays.asList(refs);
            actualLevel = level == null ? Level.ERROR : actualLevel;
            boolean additive = Booleans.parseBoolean(additivity, true);
            return new AsyncLoggerConfig("", (List<AppenderRef>)var3_4, filter, (Level)var1_2, (boolean)var0_1, properties, config, AsyncLoggerConfig.includeLocation((String)var2_3));
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ LoggerConfig.LevelAndRefs access$100(Level x0, AppenderRef[] x1, String x2, Configuration x3) {
            void var3_3;
            void var2_2;
            void var1_1;
            return RootLogger.getLevelAndRefs(x0, (AppenderRef[])var1_1, (String)var2_2, (Configuration)var3_3);
        }

        public static class Builder<B extends Builder<B>>
        extends LoggerConfig.RootLogger.Builder<B> {
            /*
             * WARNING - void declaration
             */
            @Override
            public LoggerConfig build() {
                void var1_1;
                LoggerConfig.LevelAndRefs container = RootLogger.access$100(this.getLevel(), this.getRefs(), this.getLevelAndRefs(), this.getConfig());
                return new AsyncLoggerConfig("", container.refs, this.getFilter(), var1_1.level, this.isAdditivity(), this.getProperties(), this.getConfig(), AsyncLoggerConfig.includeLocation(this.getIncludeLocation()));
            }
        }
    }

    public static class Builder<B extends Builder<B>>
    extends LoggerConfig.Builder<B> {
        /*
         * WARNING - void declaration
         */
        @Override
        public LoggerConfig build() {
            void var2_2;
            void var1_1;
            String name = this.getLoggerName().equals("root") ? "" : this.getLoggerName();
            LoggerConfig.LevelAndRefs container = AsyncLoggerConfig.access$000(this.getLevel(), this.getRefs(), this.getLevelAndRefs(), this.getConfig());
            return new AsyncLoggerConfig((String)var1_1, container.refs, this.getFilter(), var2_2.level, this.isAdditivity(), this.getProperties(), this.getConfig(), AsyncLoggerConfig.includeLocation(this.getIncludeLocation()));
        }
    }
}

