/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import com.lmax.disruptor.EventTranslatorVararg;
import com.lmax.disruptor.dsl.Disruptor;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.ContextDataInjector;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.async.AsyncLoggerDisruptor;
import org.apache.logging.log4j.core.async.AsyncQueueFullMessageUtil;
import org.apache.logging.log4j.core.async.EventRoute;
import org.apache.logging.log4j.core.async.InternalAsyncUtil;
import org.apache.logging.log4j.core.async.RingBufferLogEvent;
import org.apache.logging.log4j.core.async.RingBufferLogEventTranslator;
import org.apache.logging.log4j.core.async.ThreadNameCachingStrategy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.ReliabilityStrategy;
import org.apache.logging.log4j.core.impl.ContextDataFactory;
import org.apache.logging.log4j.core.impl.ContextDataInjectorFactory;
import org.apache.logging.log4j.core.util.Clock;
import org.apache.logging.log4j.core.util.ClockFactory;
import org.apache.logging.log4j.core.util.NanoClock;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.ReusableMessage;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.StackLocatorUtil;
import org.apache.logging.log4j.util.StringMap;

public class AsyncLogger
extends Logger
implements EventTranslatorVararg<RingBufferLogEvent> {
    private static final StatusLogger LOGGER = StatusLogger.getLogger();
    private static final Clock CLOCK = ClockFactory.getClock();
    private static final ContextDataInjector CONTEXT_DATA_INJECTOR = ContextDataInjectorFactory.createInjector();
    private static final ThreadNameCachingStrategy THREAD_NAME_CACHING_STRATEGY = ThreadNameCachingStrategy.create();
    private final ThreadLocal<RingBufferLogEventTranslator> threadLocalTranslator = new ThreadLocal();
    private final AsyncLoggerDisruptor loggerDisruptor;
    private volatile boolean includeLocation;
    private volatile NanoClock nanoClock;
    private final TranslatorType threadLocalTranslatorType = new TranslatorType(){
        {
            void var1_1;
            super((AsyncLogger)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void log(String fqcn, StackTraceElement location, Level level, Marker marker, Message message, Throwable thrown) {
            void var3_3;
            void var2_2;
            void var1_1;
            AsyncLogger.access$000(AsyncLogger.this, (String)var1_1, (StackTraceElement)var2_2, (Level)var3_3, marker, message, thrown);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void log(String fqcn, Level level, Marker marker, Message message, Throwable thrown) {
            void var3_3;
            void var2_2;
            void var1_1;
            AsyncLogger.access$100(AsyncLogger.this, (String)var1_1, (Level)var2_2, (Marker)var3_3, message, thrown);
        }
    };
    private final TranslatorType varargTranslatorType = new TranslatorType(){
        {
            void var1_1;
            super((AsyncLogger)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void log(String fqcn, StackTraceElement location, Level level, Marker marker, Message message, Throwable thrown) {
            void var3_3;
            void var2_2;
            void var1_1;
            AsyncLogger.access$200(AsyncLogger.this, (String)var1_1, (StackTraceElement)var2_2, (Level)var3_3, marker, message, thrown);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void log(String fqcn, Level level, Marker marker, Message message, Throwable thrown) {
            void var3_3;
            void var2_2;
            void var1_1;
            AsyncLogger.access$300(AsyncLogger.this, (String)var1_1, (Level)var2_2, (Marker)var3_3, message, thrown);
        }
    };

    /*
     * WARNING - void declaration
     */
    public AsyncLogger(LoggerContext context, String name, MessageFactory messageFactory, AsyncLoggerDisruptor loggerDisruptor) {
        super(context, (String)var2_2, (MessageFactory)var3_3);
        void var1_1;
        void var3_3;
        void var2_2;
        this.loggerDisruptor = loggerDisruptor;
        this.includeLocation = this.privateConfig.loggerConfig.isIncludeLocation();
        this.nanoClock = var1_1.getConfiguration().getNanoClock();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void updateConfiguration(Configuration newConfig) {
        void var1_1;
        this.nanoClock = newConfig.getNanoClock();
        this.includeLocation = newConfig.getLoggerConfig(this.name).isIncludeLocation();
        super.updateConfiguration((Configuration)var1_1);
    }

    NanoClock getNanoClock() {
        return this.nanoClock;
    }

    /*
     * WARNING - void declaration
     */
    private RingBufferLogEventTranslator getCachedTranslator() {
        void var1_1;
        RingBufferLogEventTranslator result = this.threadLocalTranslator.get();
        if (result == null) {
            result = new RingBufferLogEventTranslator();
            this.threadLocalTranslator.set(result);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logMessage(String fqcn, Level level, Marker marker, Message message, Throwable thrown) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.getTranslatorType().log((String)var1_1, (Level)var2_2, (Marker)var3_3, message, thrown);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, Marker marker, String fqcn, StackTraceElement location, Message message, Throwable throwable) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.getTranslatorType().log((String)var3_3, location, (Level)var1_1, (Marker)var2_2, message, throwable);
    }

    private TranslatorType getTranslatorType() {
        if (this.loggerDisruptor.isUseThreadLocals()) {
            return this.threadLocalTranslatorType;
        }
        return this.varargTranslatorType;
    }

    private boolean isReused(Message message) {
        return message instanceof ReusableMessage;
    }

    /*
     * WARNING - void declaration
     */
    private void logWithThreadLocalTranslator(String fqcn, Level level, Marker marker, Message message, Throwable thrown) {
        void var3_3;
        void var2_2;
        void var1_1;
        RingBufferLogEventTranslator translator = this.getCachedTranslator();
        this.initTranslator(translator, (String)var1_1, (Level)var2_2, (Marker)var3_3, message, thrown);
        this.initTranslatorThreadValues(translator);
        this.publish(translator);
    }

    /*
     * WARNING - void declaration
     */
    private void logWithThreadLocalTranslator(String fqcn, StackTraceElement location, Level level, Marker marker, Message message, Throwable thrown) {
        void var3_3;
        void var2_2;
        void var1_1;
        RingBufferLogEventTranslator translator = this.getCachedTranslator();
        this.initTranslator(translator, (String)var1_1, (StackTraceElement)var2_2, (Level)var3_3, marker, message, thrown);
        this.initTranslatorThreadValues(translator);
        this.publish(translator);
    }

    /*
     * WARNING - void declaration
     */
    private void publish(RingBufferLogEventTranslator translator) {
        if (!this.loggerDisruptor.tryPublish(translator)) {
            void var1_1;
            this.handleRingBufferFull((RingBufferLogEventTranslator)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handleRingBufferFull(RingBufferLogEventTranslator translator) {
        void var2_2;
        if (AbstractLogger.getRecursionDepth() > 1) {
            AsyncQueueFullMessageUtil.logWarningToStatusLogger();
            this.logMessageInCurrentThread(translator.fqcn, translator.level, translator.marker, translator.message, translator.thrown);
            translator.clear();
            return;
        }
        EventRoute eventRoute = this.loggerDisruptor.getEventRoute(translator.level);
        switch (eventRoute) {
            case ENQUEUE: {
                this.loggerDisruptor.enqueueLogMessageWhenQueueFull(translator);
                return;
            }
            case SYNCHRONOUS: {
                this.logMessageInCurrentThread(translator.fqcn, translator.level, translator.marker, translator.message, translator.thrown);
                translator.clear();
                return;
            }
            case DISCARD: {
                void var1_1;
                var1_1.clear();
                return;
            }
        }
        throw new IllegalStateException("Unknown EventRoute " + var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void initTranslator(RingBufferLogEventTranslator translator, String fqcn, StackTraceElement location, Level level, Marker marker, Message message, Throwable thrown) {
        void var3_3;
        void var2_2;
        AsyncLogger asyncLogger = this;
        translator.setBasicValues(asyncLogger, asyncLogger.name, marker, (String)var2_2, level, message, thrown, ThreadContext.getImmutableStack(), (StackTraceElement)var3_3, CLOCK, this.nanoClock);
    }

    /*
     * WARNING - void declaration
     */
    private void initTranslator(RingBufferLogEventTranslator translator, String fqcn, Level level, Marker marker, Message message, Throwable thrown) {
        void var2_2;
        void var3_3;
        AsyncLogger asyncLogger = this;
        translator.setBasicValues(asyncLogger, asyncLogger.name, marker, fqcn, (Level)var3_3, message, thrown, ThreadContext.getImmutableStack(), this.calcLocationIfRequested((String)var2_2), CLOCK, this.nanoClock);
    }

    /*
     * WARNING - void declaration
     */
    private void initTranslatorThreadValues(RingBufferLogEventTranslator translator) {
        if (THREAD_NAME_CACHING_STRATEGY == ThreadNameCachingStrategy.UNCACHED) {
            void var1_1;
            var1_1.updateThreadValues();
        }
    }

    /*
     * WARNING - void declaration
     */
    private StackTraceElement calcLocationIfRequested(String fqcn) {
        if (this.includeLocation) {
            void var1_1;
            return StackLocatorUtil.calcLocation((String)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void logWithVarargTranslator(String fqcn, Level level, Marker marker, Message message, Throwable thrown) {
        Disruptor<RingBufferLogEvent> disruptor = this.loggerDisruptor.getDisruptor();
        if (disruptor == null) {
            LOGGER.error("Ignoring log event after Log4j has been shut down.");
            return;
        }
        if (!this.isReused(message)) {
            InternalAsyncUtil.makeMessageImmutable(message);
        }
        Object[] objectArray = new Object[7];
        objectArray[0] = this;
        StackTraceElement location = this.calcLocationIfRequested(fqcn);
        objectArray[1] = location;
        objectArray[2] = fqcn;
        objectArray[3] = level;
        objectArray[4] = marker;
        objectArray[5] = message;
        objectArray[6] = thrown;
        if (!disruptor.getRingBuffer().tryPublishEvent((EventTranslatorVararg)this, objectArray)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.handleRingBufferFull(location, (String)var1_1, (Level)var2_2, (Marker)var3_3, message, thrown);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void logWithVarargTranslator(String fqcn, StackTraceElement location, Level level, Marker marker, Message message, Throwable thrown) {
        Disruptor<RingBufferLogEvent> disruptor = this.loggerDisruptor.getDisruptor();
        if (disruptor == null) {
            LOGGER.error("Ignoring log event after Log4j has been shut down.");
            return;
        }
        if (!this.isReused(message)) {
            InternalAsyncUtil.makeMessageImmutable(message);
        }
        if (!disruptor.getRingBuffer().tryPublishEvent((EventTranslatorVararg)this, new Object[]{this, location, fqcn, level, marker, message, thrown})) {
            void var3_3;
            void var1_1;
            void var2_2;
            this.handleRingBufferFull((StackTraceElement)var2_2, (String)var1_1, (Level)var3_3, marker, message, thrown);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void translateTo(RingBufferLogEvent event, long sequence, Object ... args) {
        void var3_5;
        void var1_1;
        void var2_3;
        AsyncLogger asyncLogger = (AsyncLogger)((Object)args[0]);
        StackTraceElement location = (StackTraceElement)args[1];
        String fqcn = (String)args[2];
        Level level = (Level)args[3];
        Marker marker = (Marker)args[4];
        Message message = (Message)args[5];
        Throwable thrown = (Throwable)args[6];
        ThreadContext.ContextStack contextStack = ThreadContext.getImmutableStack();
        Thread currentThread = Thread.currentThread();
        String threadName = THREAD_NAME_CACHING_STRATEGY.getThreadName();
        void v0 = var2_3;
        event.setValues((AsyncLogger)v0, v0.getName(), marker, fqcn, level, message, thrown, CONTEXT_DATA_INJECTOR.injectContextData(null, (StringMap)var1_1.getContextData()), contextStack, currentThread.getId(), threadName, currentThread.getPriority(), (StackTraceElement)var3_5, CLOCK, this.nanoClock);
    }

    /*
     * WARNING - void declaration
     */
    void logMessageInCurrentThread(String fqcn, Level level, Marker marker, Message message, Throwable thrown) {
        void var2_2;
        void var3_3;
        void var1_1;
        ReliabilityStrategy reliabilityStrategy = this.privateConfig.loggerConfig.getReliabilityStrategy();
        AsyncLogger asyncLogger = this;
        reliabilityStrategy.log(asyncLogger, asyncLogger.getName(), (String)var1_1, (Marker)var3_3, (Level)var2_2, message, thrown);
    }

    /*
     * WARNING - void declaration
     */
    private void handleRingBufferFull(StackTraceElement location, String fqcn, Level level, Marker marker, Message msg, Throwable thrown) {
        if (AbstractLogger.getRecursionDepth() > 1) {
            AsyncQueueFullMessageUtil.logWarningToStatusLogger();
            this.logMessageInCurrentThread(fqcn, level, marker, msg, thrown);
            return;
        }
        EventRoute eventRoute = this.loggerDisruptor.getEventRoute(level);
        switch (eventRoute) {
            case ENQUEUE: {
                void var1_1;
                AsyncLogger asyncLogger = this;
                this.loggerDisruptor.enqueueLogMessageWhenQueueFull(asyncLogger, asyncLogger, (StackTraceElement)var1_1, fqcn, level, marker, msg, thrown);
                return;
            }
            case SYNCHRONOUS: {
                void var3_3;
                void var2_2;
                this.logMessageInCurrentThread((String)var2_2, (Level)var3_3, marker, msg, thrown);
                return;
            }
            case DISCARD: {
                return;
            }
        }
        throw new IllegalStateException("Unknown EventRoute " + (Object)((Object)eventRoute));
    }

    /*
     * WARNING - void declaration
     */
    public void actualAsyncLog(RingBufferLogEvent event) {
        void var1_1;
        void var2_2;
        LoggerConfig privateConfigLoggerConfig = this.privateConfig.loggerConfig;
        List<Property> properties = privateConfigLoggerConfig.getPropertyList();
        if (properties != null) {
            void var3_3;
            this.onPropertiesPresent(event, (List<Property>)var3_3);
        }
        var2_2.getReliabilityStrategy().log(this, (LogEvent)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void onPropertiesPresent(RingBufferLogEvent event, List<Property> properties) {
        void var3_3;
        void var1_1;
        StringMap contextData = AsyncLogger.getContextData(event);
        int size = properties.size();
        for (int i = 0; i < size; ++i) {
            Property prop = properties.get(i);
            if (contextData.getValue(prop.getName()) != null) continue;
            String value = prop.evaluate(this.privateConfig.config.getStrSubstitutor());
            contextData.putValue(prop.getName(), (Object)value);
        }
        var1_1.setContextData((StringMap)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static StringMap getContextData(RingBufferLogEvent event) {
        RingBufferLogEvent ringBufferLogEvent;
        RingBufferLogEvent contextData = (StringMap)event.getContextData();
        if (contextData.isFrozen()) {
            void var1_1;
            StringMap temp = ContextDataFactory.createContextData();
            temp.putAll((ReadOnlyStringMap)contextData);
            return var1_1;
        }
        return ringBufferLogEvent;
    }

    AsyncLoggerDisruptor getAsyncLoggerDisruptor() {
        return this.loggerDisruptor;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(AsyncLogger x0, String x1, StackTraceElement x2, Level x3, Marker x4, Message x5, Throwable x6) {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.logWithThreadLocalTranslator((String)var1_1, (StackTraceElement)var2_2, (Level)var3_3, x4, x5, x6);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(AsyncLogger x0, String x1, Level x2, Marker x3, Message x4, Throwable x5) {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.logWithThreadLocalTranslator((String)var1_1, (Level)var2_2, (Marker)var3_3, x4, x5);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(AsyncLogger x0, String x1, StackTraceElement x2, Level x3, Marker x4, Message x5, Throwable x6) {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.logWithVarargTranslator((String)var1_1, (StackTraceElement)var2_2, (Level)var3_3, x4, x5, x6);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$300(AsyncLogger x0, String x1, Level x2, Marker x3, Message x4, Throwable x5) {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.logWithVarargTranslator((String)var1_1, (Level)var2_2, (Marker)var3_3, x4, x5);
    }

    abstract class TranslatorType {
        final /* synthetic */ AsyncLogger this$0;

        /*
         * WARNING - void declaration
         */
        TranslatorType(AsyncLogger this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        abstract void log(String var1, StackTraceElement var2, Level var3, Marker var4, Message var5, Throwable var6);

        abstract void log(String var1, Level var2, Marker var3, Message var4, Throwable var5);
    }
}

