/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.routing;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.script.Bindings;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LifeCycle2;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.rewrite.RewritePolicy;
import org.apache.logging.log4j.core.appender.routing.PurgePolicy;
import org.apache.logging.log4j.core.appender.routing.Route;
import org.apache.logging.log4j.core.appender.routing.Routes;
import org.apache.logging.log4j.core.config.AppenderControl;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Node;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.script.AbstractScript;
import org.apache.logging.log4j.core.script.ScriptManager;
import org.apache.logging.log4j.core.script.ScriptRef;
import org.apache.logging.log4j.core.util.Booleans;

@Plugin(name="Routing", category="Core", elementType="appender", printObject=true)
public final class RoutingAppender
extends AbstractAppender {
    public static final String STATIC_VARIABLES_KEY = "staticVariables";
    private static final String DEFAULT_KEY = "ROUTING_APPENDER_DEFAULT";
    private final Routes routes;
    private Route defaultRoute;
    private final Configuration configuration;
    private final ConcurrentMap<String, CreatedRouteAppenderControl> createdAppenders = new ConcurrentHashMap<String, CreatedRouteAppenderControl>();
    private final Map<String, AppenderControl> createdAppendersUnmodifiableView = Collections.unmodifiableMap(this.createdAppenders);
    private final ConcurrentMap<String, RouteAppenderControl> referencedAppenders = new ConcurrentHashMap<String, RouteAppenderControl>();
    private final RewritePolicy rewritePolicy;
    private final PurgePolicy purgePolicy;
    private final AbstractScript defaultRouteScript;
    private final ConcurrentMap<Object, Object> scriptStaticVariables = new ConcurrentHashMap<Object, Object>();

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Builder)new Builder().asBuilder());
    }

    /*
     * WARNING - void declaration
     */
    private RoutingAppender(String name, Filter filter, boolean ignoreExceptions, Routes routes, RewritePolicy rewritePolicy, Configuration configuration, PurgePolicy purgePolicy, AbstractScript defaultRouteScript, Property[] properties) {
        super(name, (Filter)routeArray, null, n != 0, properties);
        void var1_1;
        int n;
        Route[] routeArray;
        this.routes = routes;
        this.configuration = configuration;
        this.rewritePolicy = rewritePolicy;
        this.purgePolicy = purgePolicy;
        if (this.purgePolicy != null) {
            this.purgePolicy.initialize(this);
        }
        this.defaultRouteScript = defaultRouteScript;
        Route defRoute = null;
        for (Route route : routes.getRoutes()) {
            if (route.getKey() != null) continue;
            if (defRoute == null) {
                defRoute = route;
                continue;
            }
            this.error("Multiple default routes. Route " + route.toString() + " will be ignored");
        }
        this.defaultRoute = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void start() {
        if (this.defaultRouteScript != null) {
            if (this.configuration == null) {
                this.error("No Configuration defined for RoutingAppender; required for Script element.");
            } else {
                void var3_4;
                void var2_2;
                Route[] routeArray;
                ScriptManager scriptManager = this.configuration.getScriptManager();
                Bindings bindings = scriptManager.createBindings(this.defaultRouteScript);
                bindings.put(STATIC_VARIABLES_KEY, (Object)this.scriptStaticVariables);
                Object object = routeArray.execute(this.defaultRouteScript.getName(), (Bindings)var2_2);
                Route route = this.routes.getRoute(Objects.toString(var3_4, null));
                if (route != null) {
                    this.defaultRoute = route;
                }
            }
        }
        for (Route route : this.routes.getRoutes()) {
            void var4_6;
            if (route.getAppenderRef() == null) continue;
            Object appender = this.configuration.getAppender(route.getAppenderRef());
            if (appender != null) {
                String key = route == this.defaultRoute ? DEFAULT_KEY : route.getKey();
                this.referencedAppenders.put(key, new ReferencedRouteAppenderControl((Appender)appender));
                continue;
            }
            this.error("Appender " + var4_6.getAppenderRef() + " cannot be located. Route ignored");
        }
        super.start();
    }

    @Override
    public final boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        super.stop(timeout, timeUnit, false);
        for (Map.Entry entry : this.createdAppenders.entrySet()) {
            Appender appender = ((CreatedRouteAppenderControl)entry.getValue()).getAppender();
            if (appender instanceof LifeCycle2) {
                ((LifeCycle2)((Object)appender)).stop(timeout, timeUnit);
                continue;
            }
            appender.stop();
        }
        this.setStopped();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void append(LogEvent event2) {
        void var1_1;
        void var2_3;
        String pattern;
        String key;
        RouteAppenderControl control;
        if (this.rewritePolicy != null) {
            event2 = this.rewritePolicy.rewrite(event2);
        }
        if ((control = this.getControl(key = (pattern = this.routes.getPattern(event2, this.scriptStaticVariables)) != null ? this.configuration.getStrSubstitutor().replace(event2, pattern) : (this.defaultRoute.getKey() != null ? this.defaultRoute.getKey() : DEFAULT_KEY), event2)) != null) {
            try {
                control.callAppender(event2);
                control.release();
            }
            catch (Throwable event2) {
                void var3_4;
                var3_4.release();
                throw event2;
            }
        }
        this.updatePurgePolicy((String)var2_3, (LogEvent)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void updatePurgePolicy(String key, LogEvent event) {
        if (this.purgePolicy != null && !this.referencedAppenders.containsKey(key)) {
            void var2_2;
            void var1_1;
            this.purgePolicy.update((String)var1_1, (LogEvent)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized RouteAppenderControl getControl(String key, LogEvent event) {
        void var3_3;
        RouteAppenderControl control = this.getAppender(key);
        if (control != null) {
            control.checkout();
            return control;
        }
        Route route = null;
        for (Route r : this.routes.getRoutes()) {
            if (r.getAppenderRef() != null || !key.equals(r.getKey())) continue;
            route = r;
            break;
        }
        if (route == null) {
            route = this.defaultRoute;
            control = this.getAppender(DEFAULT_KEY);
            if (control != null) {
                control.checkout();
                return control;
            }
        }
        if (route != null) {
            void var1_1;
            void var2_2;
            Appender app = this.createAppender(route, (LogEvent)var2_2);
            if (app == null) {
                return null;
            }
            CreatedRouteAppenderControl created = new CreatedRouteAppenderControl(app);
            control = created;
            this.createdAppenders.put((String)var1_1, created);
        }
        if (control != null) {
            control.checkout();
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private RouteAppenderControl getAppender(String key) {
        void var2_2;
        RouteAppenderControl result = (RouteAppenderControl)this.referencedAppenders.get(key);
        if (result == null) {
            void var1_1;
            return (RouteAppenderControl)this.createdAppenders.get(var1_1);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private Appender createAppender(Route route, LogEvent event) {
        void var1_1;
        Node node = route.getNode();
        for (Node node2 : node.getChildren()) {
            if (!node2.getType().getElementName().equals("appender")) continue;
            Node appNode = new Node(node2);
            this.configuration.createConfiguration(appNode, event);
            if (appNode.getObject() instanceof Appender) {
                Appender app = (Appender)appNode.getObject();
                app.start();
                return var1_1;
            }
            this.error("Unable to create Appender of type " + node2.getName());
            return null;
        }
        this.error("No Appender was configured for route " + var1_1.getKey());
        return null;
    }

    public final Map<String, AppenderControl> getAppenders() {
        return this.createdAppendersUnmodifiableView;
    }

    /*
     * WARNING - void declaration
     */
    public final void deleteAppender(String key) {
        void var1_1;
        LOGGER.debug("Deleting route with {} key ", key);
        CreatedRouteAppenderControl control = (CreatedRouteAppenderControl)this.createdAppenders.remove(key);
        if (control != null) {
            void var2_2;
            LOGGER.debug("Stopping route with {} key", key);
            key = this;
            synchronized (key) {
                CreatedRouteAppenderControl.access$402(control, true);
            }
            var2_2.tryStopAppender();
            return;
        }
        if (this.referencedAppenders.containsKey(key)) {
            LOGGER.debug("Route {} using an appender reference may not be removed because the appender may be used outside of the RoutingAppender", key);
            return;
        }
        LOGGER.debug("Route with {} key already deleted", (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static RoutingAppender createAppender(String name, String ignore, Routes routes, Configuration config, RewritePolicy rewritePolicy, PurgePolicy purgePolicy, Filter filter) {
        void var3_4;
        void var2_3;
        void var1_2;
        String string;
        boolean ignoreExceptions = Booleans.parseBoolean(ignore, true);
        if (name == null) {
            LOGGER.error("No name provided for RoutingAppender");
            return null;
        }
        if (routes == null) {
            LOGGER.error("No routes defined for RoutingAppender");
            return null;
        }
        return new RoutingAppender(string, filter, (boolean)var1_2, (Routes)var2_3, rewritePolicy, (Configuration)var3_4, purgePolicy, null, null);
    }

    public final Route getDefaultRoute() {
        return this.defaultRoute;
    }

    public final AbstractScript getDefaultRouteScript() {
        return this.defaultRouteScript;
    }

    public final PurgePolicy getPurgePolicy() {
        return this.purgePolicy;
    }

    public final RewritePolicy getRewritePolicy() {
        return this.rewritePolicy;
    }

    public final Routes getRoutes() {
        return this.routes;
    }

    public final Configuration getConfiguration() {
        return this.configuration;
    }

    public final ConcurrentMap<Object, Object> getScriptStaticVariables() {
        return this.scriptStaticVariables;
    }

    private static final class ReferencedRouteAppenderControl
    extends RouteAppenderControl {
        /*
         * WARNING - void declaration
         */
        ReferencedRouteAppenderControl(Appender appender) {
            super((Appender)var1_1);
            void var1_1;
        }

        @Override
        final void checkout() {
        }

        @Override
        final void release() {
        }
    }

    private static final class CreatedRouteAppenderControl
    extends RouteAppenderControl {
        private volatile boolean pendingDeletion;
        private final AtomicInteger depth = new AtomicInteger();

        /*
         * WARNING - void declaration
         */
        CreatedRouteAppenderControl(Appender appender) {
            super((Appender)var1_1);
            void var1_1;
        }

        @Override
        final void checkout() {
            if (this.pendingDeletion) {
                LOGGER.warn("CreatedRouteAppenderControl.checkout invoked on a RouteAppenderControl that is pending deletion");
            }
            this.depth.incrementAndGet();
        }

        @Override
        final void release() {
            this.depth.decrementAndGet();
            this.tryStopAppender();
        }

        /*
         * WARNING - void declaration
         */
        final void tryStopAppender() {
            if (this.pendingDeletion && this.depth.compareAndSet(0, -100000)) {
                void var1_1;
                Appender appender = this.getAppender();
                LOGGER.debug("Stopping appender {}", (Object)appender);
                var1_1.stop();
            }
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ boolean access$402(CreatedRouteAppenderControl x0, boolean x1) {
            void var1_1;
            x0.pendingDeletion = var1_1;
            return x0.pendingDeletion;
        }
    }

    private static abstract class RouteAppenderControl
    extends AppenderControl {
        /*
         * WARNING - void declaration
         */
        RouteAppenderControl(Appender appender) {
            super((Appender)var1_1, null, null);
            void var1_1;
        }

        abstract void checkout();

        abstract void release();
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<RoutingAppender> {
        @PluginElement(value="Script")
        private AbstractScript defaultRouteScript;
        @PluginElement(value="Routes")
        private Routes routes;
        @PluginElement(value="RewritePolicy")
        private RewritePolicy rewritePolicy;
        @PluginElement(value="PurgePolicy")
        private PurgePolicy purgePolicy;

        /*
         * WARNING - void declaration
         */
        @Override
        public RoutingAppender build() {
            void var1_1;
            String name = this.getName();
            if (name == null) {
                LOGGER.error("No name defined for this RoutingAppender");
                return null;
            }
            if (this.routes == null) {
                LOGGER.error("No routes defined for RoutingAppender {}", (Object)name);
                return null;
            }
            if (this.defaultRouteScript != null) {
                if (this.getConfiguration().getScriptManager() == null) {
                    LOGGER.error("Script support is not enabled");
                    return null;
                }
                if (!(this.defaultRouteScript instanceof ScriptRef) && !this.getConfiguration().getScriptManager().addScript(this.defaultRouteScript)) {
                    return null;
                }
            }
            return new RoutingAppender((String)var1_1, this.getFilter(), this.isIgnoreExceptions(), this.routes, this.rewritePolicy, this.getConfiguration(), this.purgePolicy, this.defaultRouteScript, this.getPropertyArray());
        }

        public Routes getRoutes() {
            return this.routes;
        }

        public AbstractScript getDefaultRouteScript() {
            return this.defaultRouteScript;
        }

        public RewritePolicy getRewritePolicy() {
            return this.rewritePolicy;
        }

        public PurgePolicy getPurgePolicy() {
            return this.purgePolicy;
        }

        /*
         * WARNING - void declaration
         */
        public B withRoutes(Routes routes) {
            void var1_1;
            this.routes = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B withDefaultRouteScript(AbstractScript defaultRouteScript) {
            void var1_1;
            this.defaultRouteScript = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B withRewritePolicy(RewritePolicy rewritePolicy) {
            void var1_1;
            this.rewritePolicy = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public void withPurgePolicy(PurgePolicy purgePolicy) {
            void var1_1;
            this.purgePolicy = var1_1;
        }
    }
}

