/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.routing;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import javax.script.Bindings;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.routing.Route;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.script.AbstractScript;
import org.apache.logging.log4j.core.script.ScriptManager;
import org.apache.logging.log4j.core.script.ScriptRef;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="Routes", category="Core", printObject=true)
public final class Routes {
    private static final String LOG_EVENT_KEY = "logEvent";
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final Configuration configuration;
    private final String pattern;
    private final AbstractScript patternScript;
    private final Route[] routes;

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static Routes createRoutes(String pattern, Route ... routes) {
        void var1_1;
        String string;
        if (routes == null || routes.length == 0) {
            LOGGER.error("No routes configured");
            return null;
        }
        return new Routes(null, null, string, (Route[])var1_1);
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    /*
     * WARNING - void declaration
     */
    private Routes(Configuration configuration, AbstractScript patternScript, String pattern, Route ... routes) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.configuration = var1_1;
        this.patternScript = var2_2;
        this.pattern = var3_3;
        this.routes = routes;
    }

    /*
     * WARNING - void declaration
     */
    public final String getPattern(LogEvent event, ConcurrentMap<Object, Object> scriptStaticVariables) {
        if (this.patternScript != null) {
            void var1_1;
            void var3_3;
            void var2_2;
            ScriptManager scriptManager = this.configuration.getScriptManager();
            Bindings bindings = scriptManager.createBindings(this.patternScript);
            bindings.put("staticVariables", (Object)var2_2);
            bindings.put(LOG_EVENT_KEY, (Object)event);
            Object object = var3_3.execute(this.patternScript.getName(), bindings);
            bindings.remove(LOG_EVENT_KEY);
            return Objects.toString(var1_1, null);
        }
        return this.pattern;
    }

    public final AbstractScript getPatternScript() {
        return this.patternScript;
    }

    public final Route getRoute(String key) {
        Route[] routeArray = this.routes;
        int n = this.routes.length;
        for (int i = 0; i < n; ++i) {
            Route route = routeArray[i];
            if (!Objects.equals(route.getKey(), key)) continue;
            return route;
        }
        return null;
    }

    public final Route[] getRoutes() {
        return this.routes;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder("{");
        boolean first = true;
        Route[] routeArray = this.routes;
        int n = this.routes.length;
        for (int i = 0; i < n; ++i) {
            Route route = routeArray[i];
            if (!first) {
                sb.append(',');
            }
            first = false;
            sb.append(route.toString());
        }
        sb.append('}');
        return var1_1.toString();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<Routes> {
        @PluginConfiguration
        private Configuration configuration;
        @PluginAttribute(value="pattern")
        private String pattern;
        @PluginElement(value="Script")
        private AbstractScript patternScript;
        @PluginElement(value="Routes")
        @Required
        private Route[] routes;

        @Override
        public Routes build() {
            if (this.routes == null || this.routes.length == 0) {
                LOGGER.error("No Routes configured.");
                return null;
            }
            if (this.patternScript != null && this.pattern != null || this.patternScript == null && this.pattern == null) {
                LOGGER.warn("In a Routes element, you must configure either a Script element or a pattern attribute.");
            }
            if (this.patternScript != null) {
                if (this.configuration == null) {
                    LOGGER.error("No Configuration defined for Routes; required for Script");
                } else {
                    if (this.configuration.getScriptManager() == null) {
                        LOGGER.error("Script support is not enabled");
                        return null;
                    }
                    if (!(this.configuration.getScriptManager().addScript(this.patternScript) || this.patternScript instanceof ScriptRef || this.getConfiguration().getScriptManager().addScript(this.patternScript))) {
                        return null;
                    }
                }
            }
            return new Routes(this.configuration, this.patternScript, this.pattern, this.routes);
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public String getPattern() {
            return this.pattern;
        }

        public AbstractScript getPatternScript() {
            return this.patternScript;
        }

        public Route[] getRoutes() {
            return this.routes;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withConfiguration(Configuration configuration) {
            void var1_1;
            this.configuration = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withPattern(String pattern) {
            void var1_1;
            this.pattern = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withPatternScript(AbstractScript patternScript) {
            void var1_1;
            this.patternScript = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withRoutes(Route[] routes) {
            void var1_1;
            this.routes = var1_1;
            return this;
        }
    }
}

