/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.routing;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Node;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.config.plugins.PluginNode;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="Route", category="Core", printObject=true, deferChildren=true)
public final class Route {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final Node node;
    private final String appenderRef;
    private final String key;

    /*
     * WARNING - void declaration
     */
    private Route(Node node, String appenderRef, String key) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.node = var1_1;
        this.appenderRef = var2_2;
        this.key = var3_3;
    }

    public final Node getNode() {
        return this.node;
    }

    public final String getAppenderRef() {
        return this.appenderRef;
    }

    public final String getKey() {
        return this.key;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder("Route(");
        sb.append("type=");
        if (this.appenderRef != null) {
            sb.append("static Reference=").append(this.appenderRef);
        } else if (this.node != null) {
            sb.append("dynamic - type=").append(this.node.getName());
        } else {
            sb.append("invalid Route");
        }
        if (this.key != null) {
            sb.append(" key='").append(this.key).append('\'');
        } else {
            sb.append(" default");
        }
        sb.append(')');
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    @PluginFactory
    public static Route createRoute(@PluginAttribute(value="ref") String appenderRef, @PluginAttribute(value="key") String key, @PluginNode Node node) {
        void var1_1;
        String string;
        void var2_2;
        if (node != null && node.hasChildren()) {
            if (appenderRef != null) {
                LOGGER.error("A route cannot be configured with an appender reference and an appender definition");
                return null;
            }
        } else if (appenderRef == null) {
            LOGGER.error("A route must specify an appender reference or an appender definition");
            return null;
        }
        return new Route((Node)var2_2, string, (String)var1_1);
    }
}

