/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.routing;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.routing.PurgePolicy;
import org.apache.logging.log4j.core.appender.routing.RoutingAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationScheduler;
import org.apache.logging.log4j.core.config.Scheduled;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="IdlePurgePolicy", category="Core", printObject=true)
@Scheduled
public class IdlePurgePolicy
extends AbstractLifeCycle
implements Runnable,
PurgePolicy {
    private final long timeToLive;
    private final long checkInterval;
    private final ConcurrentMap<String, Long> appendersUsage = new ConcurrentHashMap<String, Long>();
    private RoutingAppender routingAppender;
    private final ConfigurationScheduler scheduler;
    private volatile ScheduledFuture<?> future;

    /*
     * WARNING - void declaration
     */
    public IdlePurgePolicy(long timeToLive, long checkInterval, ConfigurationScheduler scheduler) {
        void var3_2;
        void var1_1;
        this.timeToLive = var1_1;
        this.checkInterval = var3_2;
        this.scheduler = scheduler;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initialize(RoutingAppender routingAppender) {
        void var1_1;
        this.routingAppender = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean stop(long timeout, TimeUnit timeUnit) {
        void var1_2;
        this.setStopping();
        IdlePurgePolicy idlePurgePolicy = this;
        boolean stopped = idlePurgePolicy.stop(idlePurgePolicy.future);
        this.setStopped();
        return (boolean)var1_2;
    }

    @Override
    public void purge() {
        long createTime = System.currentTimeMillis() - this.timeToLive;
        for (Map.Entry entry : this.appendersUsage.entrySet()) {
            long entryValue = (Long)entry.getValue();
            if (entryValue >= createTime || !this.appendersUsage.remove(entry.getKey(), entryValue)) continue;
            LOGGER.debug("Removing appender {}", entry.getKey());
            this.routingAppender.deleteAppender((String)entry.getKey());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void update(String key, LogEvent event) {
        void var3_4;
        IdlePurgePolicy idlePurgePolicy;
        long now = System.currentTimeMillis();
        this.appendersUsage.put((String)((Object)idlePurgePolicy), (long)var3_4);
        if (this.future == null) {
            idlePurgePolicy = this;
            synchronized (idlePurgePolicy) {
                if (this.future == null) {
                    this.scheduleNext();
                }
                return;
            }
        }
    }

    @Override
    public void run() {
        this.purge();
        this.scheduleNext();
    }

    /*
     * WARNING - void declaration
     */
    private void scheduleNext() {
        long updateTime = Long.MAX_VALUE;
        for (Map.Entry entry : this.appendersUsage.entrySet()) {
            if ((Long)entry.getValue() >= updateTime) continue;
            updateTime = (Long)entry.getValue();
        }
        if (updateTime < Long.MAX_VALUE) {
            void var3_3;
            void var1_1;
            long interval = this.timeToLive - (System.currentTimeMillis() - var1_1);
            this.future = this.scheduler.schedule(this, (long)var3_3, TimeUnit.MILLISECONDS);
            return;
        }
        IdlePurgePolicy idlePurgePolicy = this;
        this.future = this.scheduler.schedule(idlePurgePolicy, idlePurgePolicy.checkInterval, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - void declaration
     */
    @PluginFactory
    public static PurgePolicy createPurgePolicy(@PluginAttribute(value="timeToLive") String timeToLive, @PluginAttribute(value="checkInterval") String checkInterval, @PluginAttribute(value="timeUnit") String timeUnit, @PluginConfiguration Configuration configuration) {
        void var3_3;
        long ci;
        String string;
        TimeUnit units;
        if (timeToLive == null) {
            LOGGER.error("A timeToLive value is required");
            return null;
        }
        if (timeUnit == null) {
            units = TimeUnit.MINUTES;
        } else {
            try {
                units = TimeUnit.valueOf(timeUnit.toUpperCase());
            }
            catch (Exception ex) {
                void var2_2;
                LOGGER.error("Invalid timeUnit value {}. timeUnit set to MINUTES", (Object)var2_2, (Object)ex);
                units = TimeUnit.MINUTES;
            }
        }
        long ttl = units.toMillis(Long.parseLong(string));
        if (ttl < 0L) {
            LOGGER.error("timeToLive must be positive. timeToLive set to 0");
            ttl = 0L;
        }
        if (checkInterval == null) {
            ci = ttl;
        } else {
            void var1_1;
            ci = units.toMillis(Long.parseLong((String)var1_1));
            if (ci < 0L) {
                LOGGER.error("checkInterval must be positive. checkInterval set equal to timeToLive = {}", (Object)ttl);
                ci = ttl;
            }
        }
        return new IdlePurgePolicy(ttl, ci, var3_3.getScheduler());
    }

    public String toString() {
        return "timeToLive=" + this.timeToLive;
    }
}

