/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.logging.log4j.core.appender.rolling.action.AbstractAction;

public final class ZipCompressAction
extends AbstractAction {
    private static final int BUF_SIZE = 8192;
    private final File source;
    private final File destination;
    private final boolean deleteSource;
    private final int level;

    /*
     * WARNING - void declaration
     */
    public ZipCompressAction(File source, File destination, boolean deleteSource, int level) {
        void var3_3;
        void var2_2;
        void var1_1;
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(destination, "destination");
        this.source = var1_1;
        this.destination = var2_2;
        this.deleteSource = var3_3;
        this.level = level;
    }

    @Override
    public final boolean execute() throws IOException {
        return ZipCompressAction.execute(this.source, this.destination, this.deleteSource, this.level);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean execute(File source22, File destination, boolean deleteSource, int level) throws IOException {
        if (source22.exists()) {
            File source22;
            void var2_6;
            Throwable throwable;
            FileInputStream fis = new FileInputStream(source22);
            Throwable throwable2 = null;
            try {
                ZipOutputStream zos2 = new ZipOutputStream(new FileOutputStream(destination));
                Throwable throwable3 = null;
                try {
                    int n;
                    zos2.setLevel(level);
                    ZipEntry zipEntry = new ZipEntry(source22.getName());
                    zos2.putNextEntry(zipEntry);
                    byte[] inbuf = new byte[8192];
                    while ((n = fis.read(inbuf)) != -1) {
                        zos2.write(inbuf, 0, n);
                    }
                }
                catch (Throwable throwable4) {
                    try {
                        Throwable throwable5 = throwable4;
                        throwable3 = throwable4;
                        throw throwable5;
                    }
                    catch (Throwable source22) {
                        if (throwable3 != null) {
                            try {
                                zos2.close();
                            }
                            catch (Throwable zos2) {
                                throwable3.addSuppressed(zos2);
                            }
                        } else {
                            ((ZipOutputStream)((Object)throwable)).close();
                        }
                        throw source22;
                    }
                }
                zos2.close();
            }
            catch (Throwable throwable6) {
                try {
                    throwable = throwable6;
                    throwable2 = throwable6;
                    throw throwable;
                }
                catch (Throwable source22) {
                    if (throwable2 != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable7) {
                            throwable2.addSuppressed(throwable7);
                        }
                    } else {
                        fis.close();
                    }
                    throw source22;
                }
            }
            fis.close();
            if (var2_6 != false && !source22.delete()) {
                File file;
                LOGGER.warn("Unable to delete " + file.toString() + '.');
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void reportException(Exception ex) {
        void var1_1;
        LOGGER.warn("Exception during compression of '" + this.source.toString() + "'.", (Throwable)var1_1);
    }

    public final String toString() {
        return ZipCompressAction.class.getSimpleName() + '[' + this.source + " to " + this.destination + ", level=" + this.level + ", deleteSource=" + this.deleteSource + ']';
    }

    public final File getSource() {
        return this.source;
    }

    public final File getDestination() {
        return this.destination;
    }

    public final boolean isDeleteSource() {
        return this.deleteSource;
    }

    public final int getLevel() {
        return this.level;
    }
}

