/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.rolling.action.PathSorter;
import org.apache.logging.log4j.core.appender.rolling.action.PathWithAttributes;
import org.apache.logging.log4j.status.StatusLogger;

public class SortingVisitor
extends SimpleFileVisitor<Path> {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final PathSorter sorter;
    private final List<PathWithAttributes> collected = new ArrayList<PathWithAttributes>();

    /*
     * WARNING - void declaration
     */
    public SortingVisitor(PathSorter sorter) {
        void var1_1;
        this.sorter = (PathSorter)Objects.requireNonNull(var1_1, "sorter");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
        void var2_2;
        void var1_1;
        this.collected.add(new PathWithAttributes((Path)var1_1, (BasicFileAttributes)var2_2));
        return FileVisitResult.CONTINUE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FileVisitResult visitFileFailed(Path file, IOException ioException) throws IOException {
        void var2_2;
        void var1_1;
        if (ioException instanceof NoSuchFileException) {
            LOGGER.info("File {} could not be accessed, it has likely already been deleted", (Object)file, (Object)ioException);
            return FileVisitResult.CONTINUE;
        }
        return super.visitFileFailed(var1_1, (IOException)var2_2);
    }

    public List<PathWithAttributes> getSortedPaths() {
        Collections.sort(this.collected, this.sorter);
        return this.collected;
    }
}

