/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.rolling.action.PathWithAttributes;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.script.AbstractScript;
import org.apache.logging.log4j.core.script.ScriptRef;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="ScriptCondition", category="Core", printObject=true)
public class ScriptCondition {
    private static Logger LOGGER = StatusLogger.getLogger();
    private final AbstractScript script;
    private final Configuration configuration;

    /*
     * WARNING - void declaration
     */
    public ScriptCondition(AbstractScript script, Configuration configuration) {
        void var2_2;
        void var1_1;
        this.script = (AbstractScript)Objects.requireNonNull(var1_1, "script");
        this.configuration = (Configuration)Objects.requireNonNull(var2_2, "configuration");
    }

    /*
     * WARNING - void declaration
     */
    public List<PathWithAttributes> selectFilesToDelete(Path basePath, List<PathWithAttributes> candidates) {
        void var3_3;
        void var2_2;
        Object object;
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("basePath", object);
        bindings.put("pathList", (Object)var2_2);
        bindings.putAll((Map<? extends String, ? extends Object>)this.configuration.getProperties());
        bindings.put("configuration", (Object)this.configuration);
        bindings.put("substitutor", (Object)this.configuration.getStrSubstitutor());
        bindings.put("statusLogger", (Object)LOGGER);
        object = this.configuration.getScriptManager().execute(this.script.getName(), (Bindings)var3_3);
        return (List)object;
    }

    /*
     * WARNING - void declaration
     */
    @PluginFactory
    public static ScriptCondition createCondition(@PluginElement(value="Script") AbstractScript script, @PluginConfiguration Configuration configuration) {
        void var1_1;
        AbstractScript abstractScript;
        if (script == null) {
            LOGGER.error("A Script, ScriptFile or ScriptRef element must be provided for this ScriptCondition");
            return null;
        }
        if (configuration.getScriptManager() == null) {
            LOGGER.error("Script support is not enabled");
            return null;
        }
        if (script instanceof ScriptRef) {
            if (configuration.getScriptManager().getScript(script.getName()) == null) {
                LOGGER.error("ScriptCondition: No script with name {} has been declared.", (Object)script.getName());
                return null;
            }
        } else if (!configuration.getScriptManager().addScript(script)) {
            return null;
        }
        return new ScriptCondition(abstractScript, (Configuration)var1_1);
    }
}

