/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.core.appender.rolling.action.AbstractAction;
import org.apache.logging.log4j.core.appender.rolling.action.AbstractPathAction;
import org.apache.logging.log4j.core.appender.rolling.action.PathCondition;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.core.util.FileUtils;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="PosixViewAttribute", category="Core", printObject=true)
public class PosixViewAttributeAction
extends AbstractPathAction {
    private final Set<PosixFilePermission> filePermissions;
    private final String fileOwner;
    private final String fileGroup;

    /*
     * WARNING - void declaration
     */
    private PosixViewAttributeAction(String basePath, boolean followSymbolicLinks, int maxDepth, PathCondition[] pathConditions, StrSubstitutor subst, Set<PosixFilePermission> filePermissions, String fileOwner, String fileGroup) {
        super((String)var1_1, (boolean)var2_2, (int)var3_3, pathConditions, subst);
        void var3_3;
        void var2_2;
        void var1_1;
        this.filePermissions = filePermissions;
        this.fileOwner = fileOwner;
        this.fileGroup = fileGroup;
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected FileVisitor<Path> createFileVisitor(Path basePath, List<PathCondition> conditions) {
        void var1_1;
        void var2_2;
        return new SimpleFileVisitor<Path>(this, (List)var2_2, (Path)var1_1){
            final /* synthetic */ List val$conditions;
            final /* synthetic */ Path val$basePath;
            final /* synthetic */ PosixViewAttributeAction this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$conditions = list;
                this.val$basePath = path;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                void var1_1;
                for (PathCondition pathFilter : this.val$conditions) {
                    Path relative;
                    if (pathFilter.accept(this.val$basePath, relative = this.val$basePath.relativize(file), attrs)) continue;
                    AbstractAction.LOGGER.trace("Not defining POSIX attribute base={}, relative={}", (Object)this.val$basePath, (Object)relative);
                    return FileVisitResult.CONTINUE;
                }
                FileUtils.defineFilePosixAttributeView((Path)var1_1, this.this$0.filePermissions, this.this$0.fileOwner, this.this$0.fileGroup);
                return FileVisitResult.CONTINUE;
            }
        };
    }

    public Set<PosixFilePermission> getFilePermissions() {
        return this.filePermissions;
    }

    public String getFileOwner() {
        return this.fileOwner;
    }

    public String getFileGroup() {
        return this.fileGroup;
    }

    @Override
    public String toString() {
        return "PosixViewAttributeAction [filePermissions=" + this.filePermissions + ", fileOwner=" + this.fileOwner + ", fileGroup=" + this.fileGroup + ", getBasePath()=" + this.getBasePath() + ", getMaxDepth()=" + this.getMaxDepth() + ", getPathConditions()=" + this.getPathConditions() + "]";
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<PosixViewAttributeAction> {
        @PluginConfiguration
        private Configuration configuration;
        private StrSubstitutor subst;
        @PluginBuilderAttribute
        @Required(message="No base path provided")
        private String basePath;
        @PluginBuilderAttribute
        private boolean followLinks = false;
        @PluginBuilderAttribute
        private int maxDepth = 1;
        @PluginElement(value="PathConditions")
        private PathCondition[] pathConditions;
        @PluginBuilderAttribute(value="filePermissions")
        private String filePermissionsString;
        private Set<PosixFilePermission> filePermissions;
        @PluginBuilderAttribute
        private String fileOwner;
        @PluginBuilderAttribute
        private String fileGroup;

        @Override
        public PosixViewAttributeAction build() {
            if (Strings.isEmpty((CharSequence)this.basePath)) {
                AbstractAction.LOGGER.error("Posix file attribute view action not valid because base path is empty.");
                return null;
            }
            if (this.filePermissions == null && Strings.isEmpty((CharSequence)this.filePermissionsString) && Strings.isEmpty((CharSequence)this.fileOwner) && Strings.isEmpty((CharSequence)this.fileGroup)) {
                AbstractAction.LOGGER.error("Posix file attribute view not valid because nor permissions, user or group defined.");
                return null;
            }
            if (!FileUtils.isFilePosixAttributeViewSupported()) {
                AbstractAction.LOGGER.warn("Posix file attribute view defined but it is not supported by this files system.");
                return null;
            }
            return new PosixViewAttributeAction(this.basePath, this.followLinks, this.maxDepth, this.pathConditions, this.subst != null ? this.subst : this.configuration.getStrSubstitutor(), this.filePermissions != null ? this.filePermissions : (this.filePermissionsString != null ? PosixFilePermissions.fromString(this.filePermissionsString) : null), this.fileOwner, this.fileGroup);
        }

        /*
         * WARNING - void declaration
         */
        public Builder withConfiguration(Configuration configuration) {
            void var1_1;
            this.configuration = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withSubst(StrSubstitutor subst) {
            void var1_1;
            this.subst = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withBasePath(String basePath) {
            void var1_1;
            this.basePath = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withFollowLinks(boolean followLinks) {
            void var1_1;
            this.followLinks = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withMaxDepth(int maxDepth) {
            void var1_1;
            this.maxDepth = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withPathConditions(PathCondition[] pathConditions) {
            void var1_1;
            this.pathConditions = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withFilePermissionsString(String filePermissionsString) {
            void var1_1;
            this.filePermissionsString = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withFilePermissions(Set<PosixFilePermission> filePermissions) {
            void var1_1;
            this.filePermissions = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withFileOwner(String fileOwner) {
            void var1_1;
            this.fileOwner = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withFileGroup(String fileGroup) {
            void var1_1;
            this.fileGroup = var1_1;
            return this;
        }
    }
}

