/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.io.Serializable;
import org.apache.logging.log4j.core.appender.rolling.action.PathSorter;
import org.apache.logging.log4j.core.appender.rolling.action.PathWithAttributes;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="SortByModificationTime", category="Core", printObject=true)
public class PathSortByModificationTime
implements Serializable,
PathSorter {
    private static final long serialVersionUID = 1L;
    private final boolean recentFirst;
    private final int multiplier;

    /*
     * WARNING - void declaration
     */
    public PathSortByModificationTime(boolean recentFirst) {
        void var1_1;
        this.recentFirst = recentFirst;
        this.multiplier = var1_1 != false ? 1 : -1;
    }

    @PluginFactory
    public static PathSorter createSorter(@PluginAttribute(value="recentFirst", defaultBoolean=true) boolean recentFirst) {
        boolean bl;
        return new PathSortByModificationTime(bl);
    }

    public boolean isRecentFirst() {
        return this.recentFirst;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compare(PathWithAttributes path1, PathWithAttributes path2) {
        void var3_4;
        long lastModified1 = path1.getAttributes().lastModifiedTime().toMillis();
        long l = path2.getAttributes().lastModifiedTime().toMillis();
        int result = Long.signum(l - lastModified1);
        if (result == 0) {
            try {
                result = path2.getPath().compareTo(path1.getPath());
            }
            catch (ClassCastException classCastException) {
                void var1_1;
                void var2_2;
                result = var2_2.getPath().toString().compareTo(var1_1.getPath().toString());
            }
        }
        return this.multiplier * var3_4;
    }
}

