/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.rolling.action.IfAll;
import org.apache.logging.log4j.core.appender.rolling.action.PathCondition;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="IfFileName", category="Core", printObject=true)
public final class IfFileName
implements PathCondition {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final PathMatcher pathMatcher;
    private final String syntaxAndPattern;
    private final PathCondition[] nestedConditions;

    /*
     * WARNING - void declaration
     */
    private IfFileName(String glob, String regex, PathCondition ... nestedConditions) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (regex == null && glob == null) {
            throw new IllegalArgumentException("Specify either a path glob or a regular expression. Both cannot be null.");
        }
        this.syntaxAndPattern = IfFileName.createSyntaxAndPatternString((String)var1_1, (String)var2_2);
        this.pathMatcher = FileSystems.getDefault().getPathMatcher(this.syntaxAndPattern);
        this.nestedConditions = PathCondition.copy((PathCondition[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static String createSyntaxAndPatternString(String glob, String regex) {
        void var1_1;
        if (glob != null) {
            String string;
            if (glob.startsWith("glob:")) {
                return glob;
            }
            return "glob:" + string;
        }
        if (regex.startsWith("regex:")) {
            return regex;
        }
        return "regex:" + (String)var1_1;
    }

    public final String getSyntaxAndPattern() {
        return this.syntaxAndPattern;
    }

    public final List<PathCondition> getNestedConditions() {
        return Collections.unmodifiableList(Arrays.asList(this.nestedConditions));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean accept(Path basePath, Path relativePath, BasicFileAttributes attrs) {
        boolean result = this.pathMatcher.matches(relativePath);
        String match = result ? "matches" : "does not match";
        String accept = result ? "ACCEPTED" : "REJECTED";
        LOGGER.trace("IfFileName {}: '{}' {} relative path '{}'", (Object)accept, (Object)this.syntaxAndPattern, (Object)match, (Object)relativePath);
        if (result) {
            void var3_3;
            void var2_2;
            void var1_1;
            return IfAll.accept(this.nestedConditions, (Path)var1_1, (Path)var2_2, (BasicFileAttributes)var3_3);
        }
        return result;
    }

    @Override
    public final void beforeFileTreeWalk() {
        IfAll.beforeFileTreeWalk(this.nestedConditions);
    }

    /*
     * WARNING - void declaration
     */
    @PluginFactory
    public static IfFileName createNameCondition(@PluginAttribute(value="glob") String glob, @PluginAttribute(value="regex") String regex, PathCondition ... nestedConditions) {
        void var2_2;
        void var1_1;
        String string;
        return new IfFileName(string, (String)var1_1, (PathCondition[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        String nested = this.nestedConditions.length == 0 ? "" : " AND " + Arrays.toString(this.nestedConditions);
        return "IfFileName(" + this.syntaxAndPattern + (String)var1_1 + ")";
    }
}

