/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Objects;
import org.apache.logging.log4j.core.appender.rolling.action.PathCondition;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="IfAny", category="Core", printObject=true)
public final class IfAny
implements PathCondition {
    private final PathCondition[] components;

    /*
     * WARNING - void declaration
     */
    private IfAny(PathCondition ... filters) {
        void var1_1;
        this.components = (PathCondition[])Objects.requireNonNull(var1_1, "filters");
    }

    public final PathCondition[] getDeleteFilters() {
        return this.components;
    }

    @Override
    public final boolean accept(Path baseDir, Path relativePath, BasicFileAttributes attrs) {
        PathCondition[] pathConditionArray = this.components;
        int n = this.components.length;
        for (int i = 0; i < n; ++i) {
            PathCondition pathCondition = pathConditionArray[i];
            if (!pathCondition.accept(baseDir, relativePath, attrs)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final void beforeFileTreeWalk() {
        PathCondition[] pathConditionArray = this.components;
        int n = this.components.length;
        for (int i = 0; i < n; ++i) {
            PathCondition pathCondition = pathConditionArray[i];
            pathCondition.beforeFileTreeWalk();
        }
    }

    @PluginFactory
    public static IfAny createOrCondition(PathCondition ... components) {
        PathCondition[] pathConditionArray;
        return new IfAny(pathConditionArray);
    }

    public final String toString() {
        return "IfAny" + Arrays.toString(this.components);
    }
}

