/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Objects;
import org.apache.logging.log4j.core.appender.rolling.action.PathCondition;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="IfAll", category="Core", printObject=true)
public final class IfAll
implements PathCondition {
    private final PathCondition[] components;

    /*
     * WARNING - void declaration
     */
    private IfAll(PathCondition ... filters) {
        void var1_1;
        this.components = (PathCondition[])Objects.requireNonNull(var1_1, "filters");
    }

    public final PathCondition[] getDeleteFilters() {
        return this.components;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean accept(Path baseDir, Path relativePath, BasicFileAttributes attrs) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.components == null || this.components.length == 0) {
            return false;
        }
        return IfAll.accept(this.components, (Path)var1_1, (Path)var2_2, (BasicFileAttributes)var3_3);
    }

    public static boolean accept(PathCondition[] list, Path baseDir, Path relativePath, BasicFileAttributes attrs) {
        PathCondition[] pathConditionArray = list;
        int n = list.length;
        for (int i = 0; i < n; ++i) {
            PathCondition pathCondition = pathConditionArray[i];
            if (pathCondition.accept(baseDir, relativePath, attrs)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final void beforeFileTreeWalk() {
        IfAll.beforeFileTreeWalk(this.components);
    }

    public static void beforeFileTreeWalk(PathCondition[] nestedConditions) {
        PathCondition[] pathConditionArray = nestedConditions;
        int n = nestedConditions.length;
        for (int i = 0; i < n; ++i) {
            PathCondition pathCondition = pathConditionArray[i];
            pathCondition.beforeFileTreeWalk();
        }
    }

    @PluginFactory
    public static IfAll createAndCondition(PathCondition ... components) {
        PathCondition[] pathConditionArray;
        return new IfAll(pathConditionArray);
    }

    public final String toString() {
        return "IfAll" + Arrays.toString(this.components);
    }
}

