/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.rolling.FileSize;
import org.apache.logging.log4j.core.appender.rolling.action.IfAll;
import org.apache.logging.log4j.core.appender.rolling.action.PathCondition;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="IfAccumulatedFileSize", category="Core", printObject=true)
public final class IfAccumulatedFileSize
implements PathCondition {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final long thresholdBytes;
    private long accumulatedSize;
    private final PathCondition[] nestedConditions;

    /*
     * WARNING - void declaration
     */
    private IfAccumulatedFileSize(long thresholdSize, PathCondition ... nestedConditions) {
        void var3_2;
        void var1_1;
        if (thresholdSize <= 0L) {
            throw new IllegalArgumentException("Count must be a positive integer but was " + thresholdSize);
        }
        this.thresholdBytes = var1_1;
        this.nestedConditions = PathCondition.copy((PathCondition[])var3_2);
    }

    public final long getThresholdBytes() {
        return this.thresholdBytes;
    }

    public final List<PathCondition> getNestedConditions() {
        return Collections.unmodifiableList(Arrays.asList(this.nestedConditions));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean accept(Path basePath, Path relativePath, BasicFileAttributes attrs) {
        this.accumulatedSize += attrs.size();
        boolean result = this.accumulatedSize > this.thresholdBytes;
        String match = result ? ">" : "<=";
        String accept = result ? "ACCEPTED" : "REJECTED";
        LOGGER.trace("IfAccumulatedFileSize {}: {} accumulated size '{}' {} thresholdBytes '{}'", (Object)accept, (Object)relativePath, (Object)this.accumulatedSize, (Object)match, (Object)this.thresholdBytes);
        if (result) {
            void var3_3;
            void var2_2;
            void var1_1;
            return IfAll.accept(this.nestedConditions, (Path)var1_1, (Path)var2_2, (BasicFileAttributes)var3_3);
        }
        return false;
    }

    @Override
    public final void beforeFileTreeWalk() {
        this.accumulatedSize = 0L;
        IfAll.beforeFileTreeWalk(this.nestedConditions);
    }

    /*
     * WARNING - void declaration
     */
    @PluginFactory
    public static IfAccumulatedFileSize createFileSizeCondition(@PluginAttribute(value="exceeds") String size, PathCondition ... nestedConditions) {
        void var1_1;
        void var2_2;
        String string;
        if (size == null) {
            LOGGER.error("IfAccumulatedFileSize missing mandatory size threshold.");
        }
        long threshold = size == null ? Long.MAX_VALUE : FileSize.parse(string, Long.MAX_VALUE);
        return new IfAccumulatedFileSize((long)var2_2, (PathCondition[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        String nested = this.nestedConditions.length == 0 ? "" : " AND " + Arrays.toString(this.nestedConditions);
        return "IfAccumulatedFileSize(exceeds=" + this.thresholdBytes + (String)var1_1 + ")";
    }
}

