/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.rolling.action.IfAll;
import org.apache.logging.log4j.core.appender.rolling.action.PathCondition;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="IfAccumulatedFileCount", category="Core", printObject=true)
public final class IfAccumulatedFileCount
implements PathCondition {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final int threshold;
    private int count;
    private final PathCondition[] nestedConditions;

    /*
     * WARNING - void declaration
     */
    private IfAccumulatedFileCount(int thresholdParam, PathCondition ... nestedConditions) {
        void var2_2;
        void var1_1;
        if (thresholdParam <= 0) {
            throw new IllegalArgumentException("Count must be a positive integer but was " + thresholdParam);
        }
        this.threshold = var1_1;
        this.nestedConditions = PathCondition.copy((PathCondition[])var2_2);
    }

    public final int getThresholdCount() {
        return this.threshold;
    }

    public final List<PathCondition> getNestedConditions() {
        return Collections.unmodifiableList(Arrays.asList(this.nestedConditions));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean accept(Path basePath, Path relativePath, BasicFileAttributes attrs) {
        boolean result = ++this.count > this.threshold;
        String match = result ? ">" : "<=";
        String accept = result ? "ACCEPTED" : "REJECTED";
        LOGGER.trace("IfAccumulatedFileCount {}: {} count '{}' {} threshold '{}'", (Object)accept, (Object)relativePath, (Object)this.count, (Object)match, (Object)this.threshold);
        if (result) {
            void var3_3;
            void var2_2;
            void var1_1;
            return IfAll.accept(this.nestedConditions, (Path)var1_1, (Path)var2_2, (BasicFileAttributes)var3_3);
        }
        return false;
    }

    @Override
    public final void beforeFileTreeWalk() {
        this.count = 0;
        IfAll.beforeFileTreeWalk(this.nestedConditions);
    }

    /*
     * WARNING - void declaration
     */
    @PluginFactory
    public static IfAccumulatedFileCount createFileCountCondition(@PluginAttribute(value="exceeds", defaultInt=0x7FFFFFFF) int threshold, PathCondition ... nestedConditions) {
        void var1_1;
        int n;
        if (threshold == Integer.MAX_VALUE) {
            LOGGER.error("IfAccumulatedFileCount invalid or missing threshold value.");
        }
        return new IfAccumulatedFileCount(n, (PathCondition[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        String nested = this.nestedConditions.length == 0 ? "" : " AND " + Arrays.toString(this.nestedConditions);
        return "IfAccumulatedFileCount(exceeds=" + this.threshold + (String)var1_1 + ")";
    }
}

