/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.zip.GZIPOutputStream;
import org.apache.logging.log4j.core.appender.rolling.action.AbstractAction;

public final class GzCompressAction
extends AbstractAction {
    private static final int BUF_SIZE = 8192;
    private final File source;
    private final File destination;
    private final boolean deleteSource;
    private final int compressionLevel;

    /*
     * WARNING - void declaration
     */
    public GzCompressAction(File source, File destination, boolean deleteSource, int compressionLevel) {
        void var3_3;
        void var2_2;
        void var1_1;
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(destination, "destination");
        this.source = var1_1;
        this.destination = var2_2;
        this.deleteSource = var3_3;
        this.compressionLevel = compressionLevel;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public GzCompressAction(File source, File destination, boolean deleteSource) {
        this((File)var1_1, (File)var2_2, (boolean)var3_3, -1);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    @Override
    public final boolean execute() throws IOException {
        return GzCompressAction.execute(this.source, this.destination, this.deleteSource, this.compressionLevel);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static boolean execute(File source, File destination, boolean deleteSource) throws IOException {
        void var2_2;
        void var1_1;
        return GzCompressAction.execute(source, (File)var1_1, (boolean)var2_2, -1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean execute(File source22, File destination, boolean deleteSource2, int compressionLevel) throws IOException {
        if (source22.exists()) {
            File source22;
            void var2_8;
            Throwable throwable;
            FileInputStream fis = new FileInputStream(source22);
            Throwable throwable2 = null;
            try {
                FileOutputStream fos2 = new FileOutputStream(destination);
                Throwable throwable3 = null;
                try {
                    ConfigurableLevelGZIPOutputStream gzipOut = new ConfigurableLevelGZIPOutputStream((OutputStream)fos2, 8192, compressionLevel);
                    Throwable throwable4 = null;
                    try {
                        BufferedOutputStream os = new BufferedOutputStream(gzipOut, 8192);
                        Throwable throwable5 = null;
                        try {
                            int n;
                            byte[] inbuf = new byte[8192];
                            while ((n = fis.read(inbuf)) != -1) {
                                ((OutputStream)os).write(inbuf, 0, n);
                            }
                        }
                        catch (Throwable throwable6) {
                            try {
                                Throwable throwable7 = throwable6;
                                throwable5 = throwable6;
                                throw throwable7;
                            }
                            catch (Throwable source22) {
                                if (throwable5 != null) {
                                    try {
                                        ((OutputStream)os).close();
                                    }
                                    catch (Throwable deleteSource2) {
                                        throwable5.addSuppressed(deleteSource2);
                                    }
                                } else {
                                    ((OutputStream)os).close();
                                }
                                throw source22;
                            }
                        }
                        ((OutputStream)os).close();
                    }
                    catch (Throwable throwable8) {
                        try {
                            Throwable throwable9 = throwable8;
                            throwable4 = throwable8;
                            throw throwable9;
                        }
                        catch (Throwable source22) {
                            if (throwable4 != null) {
                                try {
                                    ((OutputStream)gzipOut).close();
                                }
                                catch (Throwable deleteSource2) {
                                    throwable4.addSuppressed(deleteSource2);
                                }
                            } else {
                                void var3_12;
                                var3_12.close();
                            }
                            throw source22;
                        }
                    }
                    ((OutputStream)gzipOut).close();
                }
                catch (Throwable throwable10) {
                    try {
                        Throwable throwable11 = throwable10;
                        throwable3 = throwable10;
                        throw throwable11;
                    }
                    catch (Throwable source22) {
                        if (throwable3 != null) {
                            try {
                                ((OutputStream)fos2).close();
                            }
                            catch (Throwable fos2) {
                                throwable3.addSuppressed(fos2);
                            }
                        } else {
                            ((OutputStream)((Object)throwable)).close();
                        }
                        throw source22;
                    }
                }
                ((OutputStream)fos2).close();
            }
            catch (Throwable throwable12) {
                try {
                    throwable = throwable12;
                    throwable2 = throwable12;
                    throw throwable;
                }
                catch (Throwable source22) {
                    if (throwable2 != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable13) {
                            throwable2.addSuppressed(throwable13);
                        }
                    } else {
                        fis.close();
                    }
                    throw source22;
                }
            }
            fis.close();
            if (var2_8 != false && !source22.delete()) {
                File file;
                LOGGER.warn("Unable to delete {}.", (Object)file);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void reportException(Exception ex) {
        void var1_1;
        LOGGER.warn("Exception during compression of '" + this.source.toString() + "'.", (Throwable)var1_1);
    }

    public final String toString() {
        return GzCompressAction.class.getSimpleName() + '[' + this.source + " to " + this.destination + ", deleteSource=" + this.deleteSource + ']';
    }

    public final File getSource() {
        return this.source;
    }

    public final File getDestination() {
        return this.destination;
    }

    public final boolean isDeleteSource() {
        return this.deleteSource;
    }

    private static final class ConfigurableLevelGZIPOutputStream
    extends GZIPOutputStream {
        /*
         * WARNING - void declaration
         */
        ConfigurableLevelGZIPOutputStream(OutputStream out, int bufSize, int level) throws IOException {
            super((OutputStream)var1_1, (int)var2_2);
            void var3_3;
            void var2_2;
            void var1_1;
            this.def.setLevel((int)var3_3);
        }
    }
}

