/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.apache.logging.log4j.core.appender.rolling.action.AbstractAction;

public class FileRenameAction
extends AbstractAction {
    private final File source;
    private final File destination;
    private final boolean renameEmptyFiles;

    /*
     * WARNING - void declaration
     */
    public FileRenameAction(File src, File dst, boolean renameEmptyFiles) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.source = var1_1;
        this.destination = var2_2;
        this.renameEmptyFiles = var3_3;
    }

    @Override
    public boolean execute() {
        return FileRenameAction.execute(this.source, this.destination, this.renameEmptyFiles);
    }

    public File getDestination() {
        return this.destination;
    }

    public File getSource() {
        return this.source;
    }

    public boolean isRenameEmptyFiles() {
        return this.renameEmptyFiles;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean execute(File source, File destination, boolean renameEmptyFiles) {
        if (renameEmptyFiles || source.length() > 0L) {
            File parent = destination.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
                if (!parent.exists()) {
                    LOGGER.error("Unable to create directory {}", (Object)parent.getAbsolutePath());
                    return false;
                }
            }
            try {
                try {
                    return FileRenameAction.moveFile(Paths.get(source.getAbsolutePath(), new String[0]), Paths.get(destination.getAbsolutePath(), new String[0]));
                }
                catch (IOException exMove) {
                    LOGGER.debug("Unable to move file {} to {}: {} {} - will try to copy and delete", (Object)source.getAbsolutePath(), (Object)destination.getAbsolutePath(), (Object)exMove.getClass().getName(), (Object)exMove.getMessage());
                    boolean result = source.renameTo(destination);
                    if (!result) {
                        try {
                            Files.copy(Paths.get(source.getAbsolutePath(), new String[0]), Paths.get(destination.getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
                            try {
                                Files.delete(Paths.get(source.getAbsolutePath(), new String[0]));
                                result = true;
                                LOGGER.trace("Renamed file {} to {} using copy and delete", (Object)source.getAbsolutePath(), (Object)destination.getAbsolutePath());
                            }
                            catch (IOException exDelete) {
                                LOGGER.error("Unable to delete file {}: {} {}", (Object)source.getAbsolutePath(), (Object)exDelete.getClass().getName(), (Object)exDelete.getMessage());
                                try {
                                    result = true;
                                    new PrintWriter(source.getAbsolutePath()).close();
                                    LOGGER.trace("Renamed file {} to {} with copy and truncation", (Object)source.getAbsolutePath(), (Object)destination.getAbsolutePath());
                                }
                                catch (IOException exOwerwrite) {
                                    LOGGER.error("Unable to overwrite file {}: {} {}", (Object)source.getAbsolutePath(), (Object)exOwerwrite.getClass().getName(), (Object)exOwerwrite.getMessage());
                                }
                            }
                        }
                        catch (IOException exCopy) {
                            void var3_10;
                            LOGGER.error("Unable to copy file {} to {}: {} {}", (Object)source.getAbsolutePath(), (Object)destination.getAbsolutePath(), (Object)exCopy.getClass().getName(), (Object)var3_10.getMessage());
                        }
                    } else {
                        LOGGER.trace("Renamed file {} to {} with source.renameTo", (Object)source.getAbsolutePath(), (Object)destination.getAbsolutePath());
                    }
                    return result;
                }
            }
            catch (RuntimeException ex) {
                void var1_1;
                LOGGER.error("Unable to rename file {} to {}: {} {}", (Object)source.getAbsolutePath(), (Object)var1_1.getAbsolutePath(), (Object)ex.getClass().getName(), (Object)ex.getMessage());
            }
        } else {
            try {
                source.delete();
            }
            catch (Exception exDelete) {
                void var2_7;
                File file;
                LOGGER.error("Unable to delete empty file {}: {} {}", (Object)file.getAbsolutePath(), (Object)exDelete.getClass().getName(), (Object)var2_7.getMessage());
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean moveFile(Path source, Path target) throws IOException {
        try {
            Files.move(source, target, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            LOGGER.trace("Renamed file {} to {} with Files.move", (Object)source.toFile().getAbsolutePath(), (Object)target.toFile().getAbsolutePath());
            return true;
        }
        catch (AtomicMoveNotSupportedException atomicMoveNotSupportedException) {
            void var1_1;
            Path path;
            Files.move(source, target, StandardCopyOption.REPLACE_EXISTING);
            LOGGER.trace("Renamed file {} to {} with Files.move", (Object)path.toFile().getAbsolutePath(), (Object)var1_1.toFile().getAbsolutePath());
            return true;
        }
    }

    public String toString() {
        return FileRenameAction.class.getSimpleName() + '[' + this.source + " to " + this.destination + ", renameEmptyFiles=" + this.renameEmptyFiles + ']';
    }
}

