/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.io.Serializable;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Duration
implements Serializable,
Comparable<Duration> {
    private static final long serialVersionUID = -3756810052716342061L;
    public static final Duration ZERO = new Duration(0L);
    private static final int HOURS_PER_DAY = 24;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int SECONDS_PER_DAY = 86400;
    private static final Pattern PATTERN = Pattern.compile("P?(?:([0-9]+)D)?(T?(?:([0-9]+)H)?(?:([0-9]+)M)?(?:([0-9]+)?S)?)?", 2);
    private final long seconds;

    /*
     * WARNING - void declaration
     */
    private Duration(long seconds) {
        void var1_1;
        this.seconds = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static Duration parse(CharSequence text) {
        CharSequence charSequence;
        Objects.requireNonNull(text, "text");
        Matcher matcher = PATTERN.matcher(text);
        if (matcher.matches() && !"T".equals(matcher.group(2))) {
            String dayMatch = matcher.group(1);
            String hourMatch = matcher.group(3);
            String minuteMatch = matcher.group(4);
            String secondMatch = matcher.group(5);
            if (dayMatch != null || hourMatch != null || minuteMatch != null || secondMatch != null) {
                void var3_4;
                void var2_3;
                long daysAsSecs = Duration.parseNumber(text, (String)var2_3, 86400, "days");
                long hoursAsSecs = Duration.parseNumber(text, (String)var3_4, 3600, "hours");
                long minsAsSecs = Duration.parseNumber(text, minuteMatch, 60, "minutes");
                long seconds = Duration.parseNumber(text, secondMatch, 1, "seconds");
                try {
                    return Duration.create(daysAsSecs, hoursAsSecs, minsAsSecs, seconds);
                }
                catch (ArithmeticException ex) {
                    void var1_2;
                    throw new IllegalArgumentException("Text cannot be parsed to a Duration (overflow) " + text, (Throwable)var1_2);
                }
            }
        }
        throw new IllegalArgumentException("Text cannot be parsed to a Duration: " + charSequence);
    }

    /*
     * WARNING - void declaration
     */
    private static long parseNumber(CharSequence text, String parsed, int multiplier, String errorText) {
        if (parsed == null) {
            return 0L;
        }
        try {
            void var2_2;
            void var1_1;
            long l = Long.parseLong((String)var1_1);
            return l * (long)var2_2;
        }
        catch (Exception ex) {
            CharSequence charSequence;
            void var3_3;
            throw new IllegalArgumentException("Text cannot be parsed to a Duration: " + (String)var3_3 + " (in " + charSequence + ")", ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Duration create(long daysAsSecs, long hoursAsSecs, long minsAsSecs, long secs) {
        void var2_1;
        return Duration.create(daysAsSecs + var2_1 + minsAsSecs + secs);
    }

    private static Duration create(long seconds) {
        long l;
        if (seconds == 0L) {
            return ZERO;
        }
        return new Duration(l);
    }

    public long toMillis() {
        return this.seconds * 1000L;
    }

    public boolean equals(Object obj) {
        Duration duration;
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Duration)) {
            return false;
        }
        duration = duration;
        return duration.seconds == this.seconds;
    }

    public int hashCode() {
        return (int)(this.seconds ^ this.seconds >>> 32);
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        if (this == ZERO) {
            return "PT0S";
        }
        long days = this.seconds / 86400L;
        long hours = this.seconds % 86400L / 3600L;
        int minutes = (int)(this.seconds % 3600L / 60L);
        int secs = (int)(this.seconds % 60L);
        StringBuilder buf = new StringBuilder(24);
        buf.append("P");
        if (days != 0L) {
            void var1_1;
            buf.append((long)var1_1).append('D');
        }
        if ((hours | (long)minutes | (long)secs) != 0L) {
            buf.append('T');
        }
        if (hours != 0L) {
            void var3_2;
            buf.append((long)var3_2).append('H');
        }
        if (minutes != 0) {
            buf.append(minutes).append('M');
        }
        if (secs == 0 && buf.length() > 0) {
            return buf.toString();
        }
        buf.append(secs).append('S');
        return buf.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(Duration other) {
        void var1_1;
        return Long.signum(this.toMillis() - var1_1.toMillis());
    }
}

