/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.rolling.action.PathCondition;
import org.apache.logging.log4j.status.StatusLogger;

public class DeletingVisitor
extends SimpleFileVisitor<Path> {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final Path basePath;
    private final boolean testMode;
    private final List<? extends PathCondition> pathConditions;

    /*
     * WARNING - void declaration
     */
    public DeletingVisitor(Path basePath, List<? extends PathCondition> pathConditions, boolean testMode) {
        PathCondition pathCondition;
        Iterator iterator;
        void var3_3;
        this.testMode = var3_3;
        this.basePath = (Path)Objects.requireNonNull(iterator, "basePath");
        this.pathConditions = Objects.requireNonNull(pathConditions, "pathConditions");
        iterator = pathCondition.iterator();
        while (iterator.hasNext()) {
            pathCondition = (PathCondition)iterator.next();
            pathCondition.beforeFileTreeWalk();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        for (PathCondition pathCondition : this.pathConditions) {
            Path relative;
            if (pathCondition.accept(this.basePath, relative = this.basePath.relativize(file), attrs)) continue;
            LOGGER.trace("Not deleting base={}, relative={}", (Object)this.basePath, (Object)relative);
            return FileVisitResult.CONTINUE;
        }
        if (this.isTestMode()) {
            LOGGER.info("Deleting {} (TEST MODE: file not actually deleted)", (Object)file);
        } else {
            void var1_1;
            this.delete((Path)var1_1);
        }
        return FileVisitResult.CONTINUE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FileVisitResult visitFileFailed(Path file, IOException ioException) throws IOException {
        void var2_2;
        void var1_1;
        if (ioException instanceof NoSuchFileException) {
            LOGGER.info("File {} could not be accessed, it has likely already been deleted", (Object)file, (Object)ioException);
            return FileVisitResult.CONTINUE;
        }
        return super.visitFileFailed(var1_1, (IOException)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void delete(Path file) throws IOException {
        void var1_1;
        LOGGER.trace("Deleting {}", (Object)file);
        Files.deleteIfExists((Path)var1_1);
    }

    public boolean isTestMode() {
        return this.testMode;
    }
}

