/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.io.IOException;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.core.appender.rolling.action.AbstractPathAction;
import org.apache.logging.log4j.core.appender.rolling.action.DeletingVisitor;
import org.apache.logging.log4j.core.appender.rolling.action.PathCondition;
import org.apache.logging.log4j.core.appender.rolling.action.PathSortByModificationTime;
import org.apache.logging.log4j.core.appender.rolling.action.PathSorter;
import org.apache.logging.log4j.core.appender.rolling.action.PathWithAttributes;
import org.apache.logging.log4j.core.appender.rolling.action.ScriptCondition;
import org.apache.logging.log4j.core.appender.rolling.action.SortingVisitor;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;

@Plugin(name="Delete", category="Core", printObject=true)
public class DeleteAction
extends AbstractPathAction {
    private final PathSorter pathSorter;
    private final boolean testMode;
    private final ScriptCondition scriptCondition;

    /*
     * WARNING - void declaration
     */
    DeleteAction(String basePath, boolean followSymbolicLinks, int maxDepth, boolean testMode, PathSorter sorter, PathCondition[] pathConditions, ScriptCondition scriptCondition, StrSubstitutor subst) {
        super((String)var1_1, (boolean)var2_2, (int)var3_3, pathConditions, subst);
        void var3_3;
        void var2_2;
        void var1_1;
        this.testMode = testMode;
        this.pathSorter = Objects.requireNonNull(sorter, "sorter");
        this.scriptCondition = scriptCondition;
        if (scriptCondition == null && (pathConditions == null || pathConditions.length == 0)) {
            LOGGER.error("Missing Delete conditions: unconditional Delete not supported");
            throw new IllegalArgumentException("Unconditional Delete not supported");
        }
    }

    @Override
    public boolean execute() throws IOException {
        if (this.scriptCondition != null) {
            return this.executeScript();
        }
        return super.execute();
    }

    /*
     * WARNING - void declaration
     */
    private boolean executeScript() throws IOException {
        void var1_1;
        List<PathWithAttributes> selectedForDeletion = this.callScript();
        if (selectedForDeletion == null) {
            LOGGER.trace("Script returned null list (no files to delete)");
            return true;
        }
        this.deleteSelectedFiles((List<PathWithAttributes>)var1_1);
        return true;
    }

    private List<PathWithAttributes> callScript() throws IOException {
        List<PathWithAttributes> list;
        List<PathWithAttributes> sortedPaths = this.getSortedPaths();
        this.trace("Sorted paths:", sortedPaths);
        list = this.scriptCondition.selectFilesToDelete(this.getBasePath(), list);
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private void deleteSelectedFiles(List<PathWithAttributes> selectedForDeletion) throws IOException {
        Iterator iterator;
        this.trace("Paths the script selected for deletion:", selectedForDeletion);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            Path path;
            PathWithAttributes pathWithAttributes = (PathWithAttributes)iterator.next();
            Path path2 = path = pathWithAttributes == null ? null : pathWithAttributes.getPath();
            if (this.isTestMode()) {
                LOGGER.info("Deleting {} (TEST MODE: file not actually deleted)", (Object)path);
                continue;
            }
            this.delete((Path)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void delete(Path path) throws IOException {
        void var1_1;
        LOGGER.trace("Deleting {}", (Object)path);
        Files.deleteIfExists((Path)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean execute(FileVisitor<Path> visitor) throws IOException {
        Iterator iterator;
        List<PathWithAttributes> sortedPaths = this.getSortedPaths();
        this.trace("Sorted paths:", sortedPaths);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            PathWithAttributes element = (PathWithAttributes)iterator.next();
            try {
                visitor.visitFile(element.getPath(), element.getAttributes());
            }
            catch (IOException ioex) {
                void var3_3;
                LOGGER.error("Error in post-rollover Delete when visiting {}", (Object)element.getPath(), (Object)ioex);
                visitor.visitFileFailed(var3_3.getPath(), ioex);
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void trace(String label, List<PathWithAttributes> sortedPaths) {
        Iterator<PathWithAttributes> iterator;
        LOGGER.trace((String)((Object)iterator));
        for (PathWithAttributes pathWithAttributes : sortedPaths) {
            void var2_2;
            LOGGER.trace((Object)var2_2);
        }
    }

    List<PathWithAttributes> getSortedPaths() throws IOException {
        List<PathWithAttributes> list;
        SortingVisitor sort = new SortingVisitor(this.pathSorter);
        super.execute(sort);
        list = ((SortingVisitor)((Object)list)).getSortedPaths();
        return list;
    }

    public boolean isTestMode() {
        return this.testMode;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected FileVisitor<Path> createFileVisitor(Path visitorBaseDir, List<PathCondition> conditions) {
        void var2_2;
        void var1_1;
        return new DeletingVisitor((Path)var1_1, (List<? extends PathCondition>)var2_2, this.testMode);
    }

    /*
     * WARNING - void declaration
     */
    @PluginFactory
    public static DeleteAction createDeleteAction(@PluginAttribute(value="basePath") String basePath, @PluginAttribute(value="followLinks") boolean followLinks, @PluginAttribute(value="maxDepth", defaultInt=1) int maxDepth, @PluginAttribute(value="testMode") boolean testMode, @PluginElement(value="PathSorter") PathSorter sorterParameter, @PluginElement(value="PathConditions") PathCondition[] pathConditions, @PluginElement(value="ScriptCondition") ScriptCondition scriptCondition, @PluginConfiguration Configuration config) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        PathSorter sorter = sorterParameter == null ? new PathSortByModificationTime(true) : sorterParameter;
        return new DeleteAction(string, (boolean)var1_1, (int)var2_2, (boolean)var3_3, sorter, pathConditions, scriptCondition, config.getStrSubstitutor());
    }
}

