/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.Objects;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.logging.log4j.core.appender.rolling.action.AbstractAction;

public final class CommonsCompressAction
extends AbstractAction {
    private static final int BUF_SIZE = 8192;
    private final String name;
    private final File source;
    private final File destination;
    private final boolean deleteSource;

    /*
     * WARNING - void declaration
     */
    public CommonsCompressAction(String name, File source, File destination, boolean deleteSource) {
        void var3_3;
        void var2_2;
        void var1_1;
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(destination, "destination");
        this.name = var1_1;
        this.source = var2_2;
        this.destination = var3_3;
        this.deleteSource = deleteSource;
    }

    @Override
    public final boolean execute() throws IOException {
        return CommonsCompressAction.execute(this.name, this.source, this.destination, this.deleteSource);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean execute(String name2, File source2, File destination, boolean deleteSource) throws IOException {
        void var3_7;
        if (!source2.exists()) {
            return false;
        }
        LOGGER.debug("Starting {} compression of {}", name2, (Object)source2.getPath());
        try {
            Throwable throwable;
            FileInputStream input = new FileInputStream(source2);
            Throwable throwable2 = null;
            try {
                BufferedOutputStream output = new BufferedOutputStream((OutputStream)new CompressorStreamFactory().createCompressorOutputStream((String)name2, (OutputStream)new FileOutputStream(destination)));
                Throwable throwable3 = null;
                try {
                    IOUtils.copy((InputStream)input, (OutputStream)output, (int)8192);
                    LOGGER.debug("Finished {} compression of {}", name2, (Object)source2.getPath());
                }
                catch (Throwable throwable4) {
                    try {
                        name2 = throwable4;
                        throwable3 = throwable4;
                        throw name2;
                    }
                    catch (Throwable name2) {
                        if (throwable3 != null) {
                            try {
                                output.close();
                            }
                            catch (Throwable source2) {
                                throwable3.addSuppressed(source2);
                            }
                        } else {
                            ((FilterOutputStream)((Object)throwable)).close();
                        }
                        throw name2;
                    }
                }
                output.close();
            }
            catch (Throwable throwable5) {
                try {
                    throwable = throwable5;
                    throwable2 = throwable5;
                    throw throwable;
                }
                catch (Throwable name2) {
                    if (throwable2 != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable source2) {
                            throwable2.addSuppressed(source2);
                        }
                    } else {
                        input.close();
                    }
                    throw name2;
                }
            }
            input.close();
        }
        catch (CompressorException e) {
            throw new IOException(e);
        }
        if (var3_7 != false) {
            try {
                File source2;
                if (Files.deleteIfExists(source2.toPath())) {
                    LOGGER.debug("Deleted {}", (Object)source2.toString());
                } else {
                    Object name2;
                    LOGGER.warn("Unable to delete {} after {} compression. File did not exist", (Object)source2.toString(), name2);
                }
            }
            catch (Exception ex) {
                String string;
                void var1_3;
                LOGGER.warn("Unable to delete {} after {} compression, {}", (Object)var1_3.toString(), (Object)string, (Object)ex.getMessage());
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void reportException(Exception ex) {
        void var1_1;
        LOGGER.warn("Exception during " + this.name + " compression of '" + this.source.toString() + "'.", (Throwable)var1_1);
    }

    public final String toString() {
        return CommonsCompressAction.class.getSimpleName() + '[' + this.source + " to " + this.destination + ", deleteSource=" + this.deleteSource + ']';
    }

    public final String getName() {
        return this.name;
    }

    public final File getSource() {
        return this.source;
    }

    public final File getDestination() {
        return this.destination;
    }

    public final boolean isDeleteSource() {
        return this.deleteSource;
    }
}

