/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.rolling.AbstractTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.util.Integers;

@Plugin(name="TimeBasedTriggeringPolicy", category="Core", printObject=true)
public final class TimeBasedTriggeringPolicy
extends AbstractTriggeringPolicy {
    private long nextRolloverMillis;
    private final int interval;
    private final boolean modulate;
    private final long maxRandomDelayMillis;
    private RollingFileManager manager;

    /*
     * WARNING - void declaration
     */
    private TimeBasedTriggeringPolicy(int interval, boolean modulate, long maxRandomDelayMillis) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.interval = var1_1;
        this.modulate = var2_2;
        this.maxRandomDelayMillis = var3_3;
    }

    public final int getInterval() {
        return this.interval;
    }

    public final long getNextRolloverMillis() {
        return this.nextRolloverMillis;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void initialize(RollingFileManager aManager) {
        void var2_2;
        void var1_1;
        this.manager = aManager;
        long current = aManager.getFileTime();
        if (current == 0L) {
            current = System.currentTimeMillis();
        }
        aManager.getPatternProcessor().getNextTime(current, this.interval, this.modulate);
        aManager.getPatternProcessor().setTimeBased(true);
        this.nextRolloverMillis = ThreadLocalRandom.current().nextLong(0L, 1L + this.maxRandomDelayMillis) + var1_1.getPatternProcessor().getNextTime((long)var2_2, this.interval, this.modulate);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean isTriggeringEvent(LogEvent event) {
        long nowMillis = event.getTimeMillis();
        if (nowMillis >= this.nextRolloverMillis) {
            void var2_2;
            this.nextRolloverMillis = ThreadLocalRandom.current().nextLong(0L, 1L + this.maxRandomDelayMillis) + this.manager.getPatternProcessor().getNextTime((long)var2_2, this.interval, this.modulate);
            this.manager.getPatternProcessor().setCurrentFileTime(System.currentTimeMillis());
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static TimeBasedTriggeringPolicy createPolicy(@PluginAttribute(value="interval") String interval, @PluginAttribute(value="modulate") String modulate) {
        void var1_1;
        String string;
        return TimeBasedTriggeringPolicy.newBuilder().withInterval(Integers.parseInt(string, 1)).withModulate(Boolean.parseBoolean((String)var1_1)).build();
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public final String toString() {
        return "TimeBasedTriggeringPolicy(nextRolloverMillis=" + this.nextRolloverMillis + ", interval=" + this.interval + ", modulate=" + this.modulate + ")";
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<TimeBasedTriggeringPolicy> {
        @PluginBuilderAttribute
        private int interval = 1;
        @PluginBuilderAttribute
        private boolean modulate = false;
        @PluginBuilderAttribute
        private int maxRandomDelay = 0;

        /*
         * WARNING - void declaration
         */
        @Override
        public TimeBasedTriggeringPolicy build() {
            void var1_1;
            long maxRandomDelayMillis = TimeUnit.SECONDS.toMillis(this.maxRandomDelay);
            return new TimeBasedTriggeringPolicy(this.interval, this.modulate, (long)var1_1);
        }

        public int getInterval() {
            return this.interval;
        }

        public boolean isModulate() {
            return this.modulate;
        }

        public int getMaxRandomDelay() {
            return this.maxRandomDelay;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withInterval(int interval) {
            void var1_1;
            this.interval = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withModulate(boolean modulate) {
            void var1_1;
            this.modulate = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withMaxRandomDelay(int maxRandomDelay) {
            void var1_1;
            this.maxRandomDelay = var1_1;
            return this;
        }
    }
}

