/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.rolling.AbstractTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.FileSize;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="SizeBasedTriggeringPolicy", category="Core", printObject=true)
public class SizeBasedTriggeringPolicy
extends AbstractTriggeringPolicy {
    private static final long MAX_FILE_SIZE = 0xA00000L;
    private final long maxFileSize;
    private RollingFileManager manager;

    protected SizeBasedTriggeringPolicy() {
        this.maxFileSize = 0xA00000L;
    }

    /*
     * WARNING - void declaration
     */
    protected SizeBasedTriggeringPolicy(long maxFileSize) {
        void var1_1;
        this.maxFileSize = var1_1;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initialize(RollingFileManager aManager) {
        void var1_1;
        this.manager = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isTriggeringEvent(LogEvent event) {
        void var1_2;
        boolean triggered = this.manager.getFileSize() > this.maxFileSize;
        if (triggered) {
            this.manager.getPatternProcessor().updateTime();
        }
        return (boolean)var1_2;
    }

    public String toString() {
        return "SizeBasedTriggeringPolicy(size=" + this.maxFileSize + ')';
    }

    /*
     * WARNING - void declaration
     */
    @PluginFactory
    public static SizeBasedTriggeringPolicy createPolicy(@PluginAttribute(value="size") String size) {
        void var1_1;
        String string;
        long maxSize = size == null ? 0xA00000L : FileSize.parse(string, 0xA00000L);
        return new SizeBasedTriggeringPolicy((long)var1_1);
    }
}

