/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.ConfigurationFactoryData;
import org.apache.logging.log4j.core.appender.FileManager;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.appender.rolling.DirectWriteRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.PatternProcessor;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.util.FileUtils;
import org.apache.logging.log4j.core.util.NullOutputStream;

public class RollingRandomAccessFileManager
extends RollingFileManager {
    public static final int DEFAULT_BUFFER_SIZE = 262144;
    private static final RollingRandomAccessFileManagerFactory FACTORY = new RollingRandomAccessFileManagerFactory();
    private RandomAccessFile randomAccessFile;

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public RollingRandomAccessFileManager(LoggerContext loggerContext, RandomAccessFile raf, String fileName, String pattern, OutputStream os, boolean append, boolean immediateFlush, int bufferSize, long size, long time, TriggeringPolicy policy, RolloverStrategy strategy, String advertiseURI, Layout<? extends Serializable> layout, boolean writeHeader) {
        this((LoggerContext)var1_1, (RandomAccessFile)var2_2, (String)var3_3, pattern, os, append, immediateFlush, bufferSize, size, time, policy, strategy, advertiseURI, layout, null, null, null, writeHeader);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public RollingRandomAccessFileManager(LoggerContext loggerContext, RandomAccessFile raf, String fileName, String pattern, OutputStream os, boolean append, boolean immediateFlush, int bufferSize, long size, long initialTime, TriggeringPolicy policy, RolloverStrategy strategy, String advertiseURI, Layout<? extends Serializable> layout, String filePermissions, String fileOwner, String fileGroup, boolean writeHeader) {
        super((LoggerContext)var1_1, (String)var3_3, pattern, os, append, false, size, initialTime, policy, strategy, advertiseURI, layout, filePermissions, fileOwner, fileGroup, writeHeader, ByteBuffer.wrap(new byte[bufferSize]));
        void var2_2;
        void var3_3;
        void var1_1;
        this.randomAccessFile = var2_2;
        this.writeHeader();
    }

    /*
     * WARNING - void declaration
     */
    private void writeHeader() {
        if (this.layout == null) {
            return;
        }
        byte[] header = this.layout.getHeader();
        if (header == null) {
            return;
        }
        try {
            if (this.randomAccessFile != null && this.randomAccessFile.length() == 0L) {
                this.randomAccessFile.write(header, 0, header.length);
            }
            return;
        }
        catch (IOException e) {
            void var1_2;
            this.logError("Unable to write header", (Throwable)var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static RollingRandomAccessFileManager getRollingRandomAccessFileManager(String fileName, String filePattern, boolean isAppend, boolean immediateFlush, int bufferSize, TriggeringPolicy policy, RolloverStrategy strategy, String advertiseURI, Layout<? extends Serializable> layout, String filePermissions, String fileOwner, String fileGroup, Configuration configuration) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        if (strategy instanceof DirectWriteRolloverStrategy && fileName != null) {
            LOGGER.error("The fileName attribute must not be specified with the DirectWriteRolloverStrategy");
            return null;
        }
        String name = fileName == null ? filePattern : fileName;
        return RollingRandomAccessFileManager.narrow(RollingRandomAccessFileManager.class, RollingRandomAccessFileManager.getManager(name, new FactoryData(string, (String)var1_1, (boolean)var2_2, (boolean)var3_3, bufferSize, policy, strategy, advertiseURI, layout, filePermissions, fileOwner, fileGroup, configuration), FACTORY));
    }

    @Deprecated
    public Boolean isEndOfBatch() {
        return Boolean.FALSE;
    }

    @Deprecated
    public void setEndOfBatch(boolean endOfBatch) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected synchronized void write(byte[] bytes, int offset, int length, boolean immediateFlush) {
        void var3_3;
        void var2_2;
        void var1_1;
        super.write((byte[])var1_1, (int)var2_2, (int)var3_3, immediateFlush);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected synchronized void writeToDestination(byte[] bytes, int offset, int length) {
        try {
            void var3_5;
            if (this.randomAccessFile == null) {
                this.createFileAfterRollover();
            }
            this.randomAccessFile.write(bytes, offset, length);
            this.size += (long)var3_5;
            return;
        }
        catch (IOException ex) {
            void var1_2;
            void var2_4;
            String msg = "Error writing to RandomAccessFile " + this.getName();
            throw new AppenderLoggingException((String)var2_4, (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void createFileAfterRollover() throws IOException {
        void var1_1;
        String fileName = ((FileManager)this).getFileName();
        File file = new File(fileName);
        FileUtils.makeParentDirs(file);
        this.createFileAfterRollover((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void createFileAfterRollover(String fileName) throws IOException {
        this.randomAccessFile = new RandomAccessFile(fileName, "rw");
        if (this.isAttributeViewEnabled()) {
            void var1_1;
            this.defineAttributeView(Paths.get((String)var1_1, new String[0]));
        }
        if (this.isAppend()) {
            this.randomAccessFile.seek(this.randomAccessFile.length());
        }
        this.writeHeader();
    }

    @Override
    public synchronized void flush() {
        RollingRandomAccessFileManager rollingRandomAccessFileManager = this;
        rollingRandomAccessFileManager.flushBuffer(rollingRandomAccessFileManager.byteBuffer);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized boolean closeOutputStream() {
        ((OutputStreamManager)this).flush();
        if (this.randomAccessFile != null) {
            try {
                this.randomAccessFile.close();
                return true;
            }
            catch (IOException e) {
                void var1_1;
                this.logError("Unable to close RandomAccessFile", (Throwable)var1_1);
                return false;
            }
        }
        return true;
    }

    @Override
    public int getBufferSize() {
        return this.byteBuffer.capacity();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateData(Object data) {
        void var1_1;
        FactoryData factoryData = (FactoryData)data;
        this.setRolloverStrategy(factoryData.getRolloverStrategy());
        this.setPatternProcessor(new PatternProcessor(factoryData.getPattern(), this.getPatternProcessor()));
        this.setTriggeringPolicy(var1_1.getTriggeringPolicy());
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1700(RollingRandomAccessFileManager x0, Path x1) {
        void var1_1;
        x0.defineAttributeView((Path)var1_1);
    }

    private static class FactoryData
    extends ConfigurationFactoryData {
        private final String fileName;
        private final String pattern;
        private final boolean append;
        private final boolean immediateFlush;
        private final int bufferSize;
        private final TriggeringPolicy policy;
        private final RolloverStrategy strategy;
        private final String advertiseURI;
        private final Layout<? extends Serializable> layout;
        private final String filePermissions;
        private final String fileOwner;
        private final String fileGroup;

        /*
         * WARNING - void declaration
         */
        public FactoryData(String fileName, String pattern, boolean append, boolean immediateFlush, int bufferSize, TriggeringPolicy policy, RolloverStrategy strategy, String advertiseURI, Layout<? extends Serializable> layout, String filePermissions, String fileOwner, String fileGroup, Configuration configuration) {
            super(configuration);
            void var3_3;
            void var2_2;
            void var1_1;
            this.fileName = var1_1;
            this.pattern = var2_2;
            this.append = var3_3;
            this.immediateFlush = immediateFlush;
            this.bufferSize = bufferSize;
            this.policy = policy;
            this.strategy = strategy;
            this.advertiseURI = advertiseURI;
            this.layout = layout;
            this.filePermissions = filePermissions;
            this.fileOwner = fileOwner;
            this.fileGroup = fileGroup;
        }

        public String getPattern() {
            return this.pattern;
        }

        public TriggeringPolicy getTriggeringPolicy() {
            return this.policy;
        }

        public RolloverStrategy getRolloverStrategy() {
            return this.strategy;
        }
    }

    private static class RollingRandomAccessFileManagerFactory
    implements ManagerFactory<RollingRandomAccessFileManager, FactoryData> {
        private RollingRandomAccessFileManagerFactory() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public RollingRandomAccessFileManager createManager(String name, FactoryData data) {
            void var2_2;
            void var1_1;
            File file = null;
            long size = 0L;
            long time = System.currentTimeMillis();
            RandomAccessFile raf = null;
            if (data.fileName != null) {
                file = new File(name);
                if (!data.append) {
                    file.delete();
                }
                long l = size = data.append ? file.length() : 0L;
                if (file.exists()) {
                    time = file.lastModified();
                }
                try {
                    FileUtils.makeParentDirs(file);
                    raf = new RandomAccessFile(name, "rw");
                    if (data.append) {
                        long length = raf.length();
                        LOGGER.trace("RandomAccessFile {} seek to {}", (Object)name, (Object)length);
                        raf.seek(length);
                    } else {
                        LOGGER.trace("RandomAccessFile {} set length to 0", (Object)name);
                        raf.setLength(0L);
                    }
                }
                catch (IOException ex) {
                    LOGGER.error("Cannot access RandomAccessFile " + ex, (Throwable)ex);
                    if (raf != null) {
                        try {
                            raf.close();
                        }
                        catch (IOException e) {
                            LOGGER.error("Cannot close RandomAccessFile {}", (Object)name, (Object)e);
                        }
                    }
                    return null;
                }
            }
            boolean writeHeader = !data.append || file == null || !file.exists();
            RollingRandomAccessFileManager rrm = new RollingRandomAccessFileManager(data.getLoggerContext(), raf, (String)var1_1, data.pattern, NullOutputStream.getInstance(), data.append, data.immediateFlush, data.bufferSize, size, time, data.policy, data.strategy, data.advertiseURI, data.layout, data.filePermissions, data.fileOwner, ((FactoryData)var2_2).fileGroup, writeHeader);
            if (rrm.isAttributeViewEnabled()) {
                void var3_3;
                RollingRandomAccessFileManager.access$1700(rrm, var3_3.toPath());
            }
            return rrm;
        }
    }
}

