/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.rolling.FileExtension;
import org.apache.logging.log4j.core.appender.rolling.RolloverFrequency;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.core.pattern.ArrayPatternConverter;
import org.apache.logging.log4j.core.pattern.DatePatternConverter;
import org.apache.logging.log4j.core.pattern.FormattingInfo;
import org.apache.logging.log4j.core.pattern.PatternConverter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.status.StatusLogger;

public class PatternProcessor {
    protected static final Logger LOGGER = StatusLogger.getLogger();
    private static final String KEY = "FileConverter";
    private static final char YEAR_CHAR = 'y';
    private static final char MONTH_CHAR = 'M';
    private static final char[] WEEK_CHARS = new char[]{'w', 'W'};
    private static final char[] DAY_CHARS = new char[]{'D', 'd', 'F', 'E'};
    private static final char[] HOUR_CHARS = new char[]{'H', 'K', 'h', 'k'};
    private static final char MINUTE_CHAR = 'm';
    private static final char SECOND_CHAR = 's';
    private static final char MILLIS_CHAR = 'S';
    private final ArrayPatternConverter[] patternConverters;
    private final FormattingInfo[] patternFields;
    private final FileExtension fileExtension;
    private long prevFileTime = 0L;
    private long nextFileTime = 0L;
    private long currentFileTime = 0L;
    private boolean isTimeBased = false;
    private RolloverFrequency frequency = null;
    private TimeZone timeZone;
    private final String pattern;

    public String getPattern() {
        return this.pattern;
    }

    public String toString() {
        return this.pattern;
    }

    /*
     * WARNING - void declaration
     */
    public PatternProcessor(String pattern) {
        ArrayPatternConverter[] arrayPatternConverterArray;
        void var2_2;
        void var3_4;
        this.pattern = pattern;
        PatternParser parser = this.createPatternParser();
        ArrayList<PatternConverter> converters = new ArrayList<PatternConverter>();
        ArrayList<FormattingInfo> fields = new ArrayList<FormattingInfo>();
        parser.parse(pattern, converters, fields, false, false, false);
        this.patternFields = fields.toArray(FormattingInfo.EMPTY_ARRAY);
        ArrayPatternConverter[] converterArray = new ArrayPatternConverter[converters.size()];
        this.patternConverters = (ArrayPatternConverter[])var3_4.toArray((T[])var2_2);
        this.fileExtension = FileExtension.lookupForFile((String)arrayPatternConverterArray);
        arrayPatternConverterArray = this.patternConverters;
        int n = this.patternConverters.length;
        for (int i = 0; i < n; ++i) {
            ArrayPatternConverter converter = arrayPatternConverterArray[i];
            if (!(converter instanceof DatePatternConverter)) continue;
            DatePatternConverter dateConverter = (DatePatternConverter)converter;
            this.frequency = this.calculateFrequency(dateConverter.getPattern());
            this.timeZone = dateConverter.getTimeZone();
        }
    }

    /*
     * WARNING - void declaration
     */
    public PatternProcessor(String pattern, PatternProcessor copy) {
        this((String)var1_1);
        void var2_2;
        void var1_1;
        this.prevFileTime = copy.prevFileTime;
        this.nextFileTime = copy.nextFileTime;
        this.currentFileTime = var2_2.currentFileTime;
    }

    public FormattingInfo[] getPatternFields() {
        return this.patternFields;
    }

    public ArrayPatternConverter[] getPatternConverters() {
        return this.patternConverters;
    }

    /*
     * WARNING - void declaration
     */
    public void setTimeBased(boolean isTimeBased) {
        void var1_1;
        this.isTimeBased = var1_1;
    }

    public long getCurrentFileTime() {
        return this.currentFileTime;
    }

    /*
     * WARNING - void declaration
     */
    public void setCurrentFileTime(long currentFileTime) {
        void var1_1;
        this.currentFileTime = var1_1;
    }

    public long getPrevFileTime() {
        return this.prevFileTime;
    }

    /*
     * WARNING - void declaration
     */
    public void setPrevFileTime(long prevFileTime) {
        void var1_1;
        LOGGER.debug("Setting prev file time to {}", (Object)new Date(prevFileTime));
        this.prevFileTime = var1_1;
    }

    public FileExtension getFileExtension() {
        return this.fileExtension;
    }

    /*
     * WARNING - void declaration
     */
    public long getNextTime(long currentMillis, int increment, boolean modulus) {
        void var1_2;
        void var3_3;
        void nextTime2;
        this.prevFileTime = this.nextFileTime;
        if (this.frequency == null) {
            throw new IllegalStateException("Pattern does not contain a date");
        }
        Calendar currentCal = Calendar.getInstance(this.timeZone);
        currentCal.setTimeInMillis(currentMillis);
        Calendar cal = Calendar.getInstance(this.timeZone);
        currentCal.setMinimalDaysInFirstWeek(7);
        cal.setMinimalDaysInFirstWeek(7);
        cal.set(currentCal.get(1), 0, 1, 0, 0, 0);
        cal.set(14, 0);
        if (this.frequency == RolloverFrequency.ANNUALLY) {
            this.increment(cal, 1, increment, modulus);
            long nextTime2 = cal.getTimeInMillis();
            cal.add(1, -1);
            this.nextFileTime = cal.getTimeInMillis();
            return this.debugGetNextTime(nextTime2);
        }
        cal.set(2, nextTime2.get(2));
        if (this.frequency == RolloverFrequency.MONTHLY) {
            this.increment(cal, 2, increment, modulus);
            long nextTime3 = cal.getTimeInMillis();
            cal.add(2, -1);
            this.nextFileTime = cal.getTimeInMillis();
            return this.debugGetNextTime(nextTime3);
        }
        if (this.frequency == RolloverFrequency.WEEKLY) {
            cal.set(3, nextTime2.get(3));
            this.increment(cal, 3, increment, modulus);
            cal.set(7, nextTime2.getFirstDayOfWeek());
            long nextTime2 = cal.getTimeInMillis();
            cal.add(3, -1);
            this.nextFileTime = cal.getTimeInMillis();
            return this.debugGetNextTime(nextTime2);
        }
        cal.set(6, nextTime2.get(6));
        if (this.frequency == RolloverFrequency.DAILY) {
            this.increment(cal, 6, increment, modulus);
            long nextTime3 = cal.getTimeInMillis();
            cal.add(6, -1);
            this.nextFileTime = cal.getTimeInMillis();
            return this.debugGetNextTime(nextTime3);
        }
        cal.set(11, nextTime2.get(11));
        if (this.frequency == RolloverFrequency.HOURLY) {
            this.increment(cal, 11, increment, modulus);
            long nextTime4 = cal.getTimeInMillis();
            cal.add(11, -1);
            this.nextFileTime = cal.getTimeInMillis();
            return this.debugGetNextTime(nextTime4);
        }
        cal.set(12, nextTime2.get(12));
        if (this.frequency == RolloverFrequency.EVERY_MINUTE) {
            this.increment(cal, 12, increment, modulus);
            long nextTime5 = cal.getTimeInMillis();
            cal.add(12, -1);
            this.nextFileTime = cal.getTimeInMillis();
            return this.debugGetNextTime(nextTime5);
        }
        cal.set(13, nextTime2.get(13));
        if (this.frequency == RolloverFrequency.EVERY_SECOND) {
            this.increment(cal, 13, increment, modulus);
            long nextTime6 = cal.getTimeInMillis();
            cal.add(13, -1);
            this.nextFileTime = cal.getTimeInMillis();
            return this.debugGetNextTime(nextTime6);
        }
        cal.set(14, nextTime2.get(14));
        this.increment(cal, 14, (int)var3_3, modulus);
        long nextTime4 = cal.getTimeInMillis();
        cal.add(14, -1);
        this.nextFileTime = var1_2.getTimeInMillis();
        return this.debugGetNextTime(nextTime4);
    }

    public void updateTime() {
        if (this.nextFileTime != 0L || !this.isTimeBased) {
            this.prevFileTime = this.nextFileTime;
            this.currentFileTime = 0L;
        }
    }

    /*
     * WARNING - void declaration
     */
    private long debugGetNextTime(long nextTime) {
        void var1_1;
        if (LOGGER.isTraceEnabled()) {
            PatternProcessor patternProcessor = this;
            PatternProcessor patternProcessor2 = this;
            LOGGER.trace("PatternProcessor.getNextTime returning {}, nextFileTime={}, prevFileTime={}, current={}, freq={}", (Object)this.format(nextTime), (Object)patternProcessor.format(patternProcessor.nextFileTime), (Object)patternProcessor2.format(patternProcessor2.prevFileTime), (Object)this.format(System.currentTimeMillis()), (Object)this.frequency);
        }
        return (long)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private String format(long time) {
        void var1_1;
        return new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss.SSS").format(new Date((long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private void increment(Calendar cal, int type, int increment, boolean modulate) {
        void var3_3;
        void var2_2;
        void var1_1;
        void interval;
        interval = modulate ? increment - cal.get(type) % increment : interval;
        var1_1.add((int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final void formatFileName(StringBuilder buf, boolean useCurrentTime, Object obj) {
        void var3_3;
        void var1_1;
        long time = useCurrentTime ? this.currentFileTime : this.prevFileTime;
        if (time == 0L) {
            time = System.currentTimeMillis();
        }
        this.formatFileName((StringBuilder)var1_1, new Date(time), var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final void formatFileName(StrSubstitutor subst, StringBuilder buf, Object obj) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.formatFileName((StrSubstitutor)var1_1, (StringBuilder)var2_2, false, (Object)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final void formatFileName(StrSubstitutor subst, StringBuilder buf, boolean useCurrentTime, Object obj) {
        void var1_1;
        void var2_2;
        void var3_3;
        LOGGER.debug("Formatting file name. useCurrentTime={}. currentFileTime={}, prevFileTime={}", (Object)useCurrentTime, (Object)this.currentFileTime, (Object)this.prevFileTime);
        long time = var3_3 != false ? (this.currentFileTime != 0L ? this.currentFileTime : System.currentTimeMillis()) : (this.prevFileTime != 0L ? this.prevFileTime : System.currentTimeMillis());
        this.formatFileName(buf, new Date(time), obj);
        String fileName = subst.replace(null, buf);
        buf.setLength(0);
        var2_2.append((String)var1_1);
    }

    protected final void formatFileName(StringBuilder buf, Object ... objects) {
        for (int i = 0; i < this.patternConverters.length; ++i) {
            int fieldStart = buf.length();
            this.patternConverters[i].format(buf, objects);
            if (this.patternFields[i] == null) continue;
            this.patternFields[i].format(fieldStart, buf);
        }
    }

    /*
     * WARNING - void declaration
     */
    private RolloverFrequency calculateFrequency(String pattern) {
        void var1_1;
        if (this.patternContains(pattern, 'S')) {
            return RolloverFrequency.EVERY_MILLISECOND;
        }
        if (this.patternContains(pattern, 's')) {
            return RolloverFrequency.EVERY_SECOND;
        }
        if (this.patternContains(pattern, 'm')) {
            return RolloverFrequency.EVERY_MINUTE;
        }
        if (this.patternContains(pattern, HOUR_CHARS)) {
            return RolloverFrequency.HOURLY;
        }
        if (this.patternContains(pattern, DAY_CHARS)) {
            return RolloverFrequency.DAILY;
        }
        if (this.patternContains(pattern, WEEK_CHARS)) {
            return RolloverFrequency.WEEKLY;
        }
        if (this.patternContains(pattern, 'M')) {
            return RolloverFrequency.MONTHLY;
        }
        if (this.patternContains((String)var1_1, 'y')) {
            return RolloverFrequency.ANNUALLY;
        }
        return null;
    }

    private PatternParser createPatternParser() {
        return new PatternParser(null, KEY, null);
    }

    private boolean patternContains(String pattern, char ... chars) {
        char[] cArray = chars;
        int n = chars.length;
        for (int i = 0; i < n; ++i) {
            char character = cArray[i];
            if (!this.patternContains(pattern, character)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean patternContains(String pattern, char character) {
        void var2_2;
        return pattern.indexOf((int)var2_2) >= 0;
    }

    public RolloverFrequency getFrequency() {
        return this.frequency;
    }

    public long getNextFileTime() {
        return this.nextFileTime;
    }
}

