/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.rolling.AbstractTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="OnStartupTriggeringPolicy", category="Core", printObject=true)
public class OnStartupTriggeringPolicy
extends AbstractTriggeringPolicy {
    private static final long JVM_START_TIME = OnStartupTriggeringPolicy.initStartTime();
    private final long minSize;

    /*
     * WARNING - void declaration
     */
    private OnStartupTriggeringPolicy(long minSize) {
        void var1_1;
        this.minSize = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static long initStartTime() {
        try {
            GenericDeclaration genericDeclaration = Loader.loadSystemClass("java.lang.management.ManagementFactory");
            genericDeclaration = genericDeclaration.getMethod("getRuntimeMXBean", new Class[0]);
            Object runtimeMXBean = ((Method)genericDeclaration).invoke(null, new Object[0]);
            GenericDeclaration genericDeclaration2 = Loader.loadSystemClass("java.lang.management.RuntimeMXBean");
            genericDeclaration2 = genericDeclaration2.getMethod("getStartTime", new Class[0]);
            runtimeMXBean = (Long)((Method)genericDeclaration2).invoke(runtimeMXBean, new Object[0]);
            return (Long)runtimeMXBean;
        }
        catch (Throwable t) {
            void var0_1;
            StatusLogger.getLogger().error("Unable to call ManagementFactory.getRuntimeMXBean().getStartTime(), using system time for OnStartupTriggeringPolicy", (Throwable)var0_1);
            return System.currentTimeMillis();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initialize(RollingFileManager manager) {
        if (manager.getFileTime() < JVM_START_TIME && manager.getFileSize() >= this.minSize) {
            void var1_1;
            StatusLogger.getLogger().debug("Initiating rollover at startup");
            if (this.minSize == 0L) {
                manager.setRenameEmptyFiles(true);
            }
            manager.skipFooter(true);
            manager.rollover();
            var1_1.skipFooter(false);
        }
    }

    @Override
    public boolean isTriggeringEvent(LogEvent event) {
        return false;
    }

    public String toString() {
        return "OnStartupTriggeringPolicy";
    }

    @PluginFactory
    public static OnStartupTriggeringPolicy createPolicy(@PluginAttribute(value="minSize", defaultLong=1L) long minSize) {
        long l;
        return new OnStartupTriggeringPolicy(l);
    }
}

