/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import java.util.Objects;
import org.apache.logging.log4j.core.appender.rolling.action.Action;
import org.apache.logging.log4j.core.appender.rolling.action.CommonsCompressAction;
import org.apache.logging.log4j.core.appender.rolling.action.GzCompressAction;
import org.apache.logging.log4j.core.appender.rolling.action.ZipCompressAction;

public enum FileExtension {
    ZIP(".zip"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final Action createCompressAction(String renameTo, String compressedName, boolean deleteSource, int compressionLevel) {
            void var3_3;
            void var2_2;
            void var1_1;
            return new ZipCompressAction(this.source((String)var1_1), this.target((String)var2_2), (boolean)var3_3, compressionLevel);
        }
    }
    ,
    GZ(".gz"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final Action createCompressAction(String renameTo, String compressedName, boolean deleteSource, int compressionLevel) {
            void var3_3;
            void var2_2;
            void var1_1;
            return new GzCompressAction(this.source((String)var1_1), this.target((String)var2_2), (boolean)var3_3, compressionLevel);
        }
    }
    ,
    BZIP2(".bz2"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final Action createCompressAction(String renameTo, String compressedName, boolean deleteSource, int compressionLevel) {
            void var3_3;
            void var2_2;
            void var1_1;
            return new CommonsCompressAction("bzip2", this.source((String)var1_1), this.target((String)var2_2), (boolean)var3_3);
        }
    }
    ,
    DEFLATE(".deflate"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final Action createCompressAction(String renameTo, String compressedName, boolean deleteSource, int compressionLevel) {
            void var3_3;
            void var2_2;
            void var1_1;
            return new CommonsCompressAction("deflate", this.source((String)var1_1), this.target((String)var2_2), (boolean)var3_3);
        }
    }
    ,
    PACK200(".pack200"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final Action createCompressAction(String renameTo, String compressedName, boolean deleteSource, int compressionLevel) {
            void var3_3;
            void var2_2;
            void var1_1;
            return new CommonsCompressAction("pack200", this.source((String)var1_1), this.target((String)var2_2), (boolean)var3_3);
        }
    }
    ,
    XZ(".xz"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final Action createCompressAction(String renameTo, String compressedName, boolean deleteSource, int compressionLevel) {
            void var3_3;
            void var2_2;
            void var1_1;
            return new CommonsCompressAction("xz", this.source((String)var1_1), this.target((String)var2_2), (boolean)var3_3);
        }
    };

    private final String extension;

    public static FileExtension lookup(String fileExtension) {
        for (FileExtension ext : FileExtension.values()) {
            if (!ext.isExtensionFor(fileExtension)) continue;
            return ext;
        }
        return null;
    }

    public static FileExtension lookupForFile(String fileName) {
        for (FileExtension ext : FileExtension.values()) {
            if (!fileName.endsWith(ext.extension)) continue;
            return ext;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private FileExtension(String extension) {
        void var3_3;
        Objects.requireNonNull(extension, "extension");
        this.extension = var3_3;
    }

    abstract Action createCompressAction(String var1, String var2, boolean var3, int var4);

    String getExtension() {
        return this.extension;
    }

    boolean isExtensionFor(String s) {
        return s.endsWith(this.extension);
    }

    int length() {
        return this.extension.length();
    }

    /*
     * WARNING - void declaration
     */
    File source(String fileName) {
        void var1_1;
        return new File((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    File target(String fileName) {
        void var1_1;
        return new File((String)var1_1);
    }
}

