/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.text.ParseException;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.rolling.AbstractTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationScheduler;
import org.apache.logging.log4j.core.config.CronScheduledFuture;
import org.apache.logging.log4j.core.config.Scheduled;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.util.CronExpression;

@Plugin(name="CronTriggeringPolicy", category="Core", printObject=true)
@Scheduled
public final class CronTriggeringPolicy
extends AbstractTriggeringPolicy {
    private static final String defaultSchedule = "0 0 0 * * ?";
    private RollingFileManager manager;
    private final CronExpression cronExpression;
    private final Configuration configuration;
    private final boolean checkOnStartup;
    private volatile Date lastRollDate;
    private CronScheduledFuture<?> future;

    /*
     * WARNING - void declaration
     */
    private CronTriggeringPolicy(CronExpression schedule, boolean checkOnStartup, Configuration configuration) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.cronExpression = (CronExpression)Objects.requireNonNull(var1_1, "schedule");
        this.configuration = (Configuration)Objects.requireNonNull(var3_3, "configuration");
        this.checkOnStartup = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void initialize(RollingFileManager aManager) {
        void var1_1;
        void var2_2;
        ConfigurationScheduler scheduler;
        this.manager = aManager;
        Date now = new Date();
        Date lastRollForFile = this.cronExpression.getPrevFireTime(new Date(this.manager.getFileTime()));
        Date lastRegularRoll = this.cronExpression.getPrevFireTime(new Date());
        aManager.getPatternProcessor().setCurrentFileTime(lastRegularRoll.getTime());
        LOGGER.debug("LastRollForFile {}, LastRegularRole {}", (Object)lastRollForFile, (Object)lastRegularRoll);
        aManager.getPatternProcessor().setPrevFileTime(lastRegularRoll.getTime());
        aManager.getPatternProcessor().setTimeBased(true);
        if (this.checkOnStartup && lastRollForFile != null && lastRegularRoll != null && lastRollForFile.before(lastRegularRoll)) {
            void var3_3;
            this.lastRollDate = var3_3;
            this.rollover();
        }
        if (!(scheduler = this.configuration.getScheduler()).isExecutorServiceSet()) {
            scheduler.incrementScheduledItems();
        }
        if (!scheduler.isStarted()) {
            ((AbstractLifeCycle)scheduler).start();
        }
        this.lastRollDate = lastRegularRoll;
        this.future = scheduler.scheduleWithCron(this.cronExpression, (Date)var2_2, new CronTrigger());
        LOGGER.debug(var1_1.toString());
    }

    @Override
    public final boolean isTriggeringEvent(LogEvent event) {
        return false;
    }

    public final CronExpression getCronExpression() {
        return this.cronExpression;
    }

    /*
     * WARNING - void declaration
     */
    @PluginFactory
    public static CronTriggeringPolicy createPolicy(@PluginConfiguration Configuration configuration, @PluginAttribute(value="evaluateOnStartup") String evaluateOnStartup, @PluginAttribute(value="schedule") String schedule) {
        Configuration configuration2;
        void var3_3;
        void var1_1;
        CronExpression cronExpression;
        boolean checkOnStartup = Boolean.parseBoolean(evaluateOnStartup);
        if (schedule == null) {
            LOGGER.info("No schedule specified, defaulting to Daily");
            cronExpression = CronTriggeringPolicy.getSchedule(defaultSchedule);
        } else {
            void var2_2;
            cronExpression = CronTriggeringPolicy.getSchedule((String)var2_2);
            if (cronExpression == null) {
                LOGGER.error("Invalid expression specified. Defaulting to Daily");
                cronExpression = CronTriggeringPolicy.getSchedule(defaultSchedule);
            }
        }
        return new CronTriggeringPolicy((CronExpression)var1_1, (boolean)var3_3, configuration2);
    }

    /*
     * WARNING - void declaration
     */
    private static CronExpression getSchedule(String expression) {
        try {
            return new CronExpression(expression);
        }
        catch (ParseException pe) {
            void var1_1;
            String string;
            LOGGER.error("Invalid cron expression - " + string, (Throwable)var1_1);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void rollover() {
        void var1_1;
        Date rollTime = this.future != null ? this.future.getFireTime() : new Date();
        this.manager.rollover(this.cronExpression.getPrevFireTime((Date)var1_1), this.lastRollDate);
        if (this.future != null) {
            this.lastRollDate = this.future.getFireTime();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean stop(long timeout, TimeUnit timeUnit) {
        void var1_2;
        this.setStopping();
        CronTriggeringPolicy cronTriggeringPolicy = this;
        boolean stopped = cronTriggeringPolicy.stop(cronTriggeringPolicy.future);
        this.setStopped();
        return (boolean)var1_2;
    }

    public final String toString() {
        return "CronTriggeringPolicy(schedule=" + this.cronExpression.getCronExpression() + ")";
    }

    private class CronTrigger
    implements Runnable {
        private CronTrigger() {
        }

        @Override
        public void run() {
            CronTriggeringPolicy.this.rollover();
        }
    }
}

