/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LifeCycle2;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.rolling.AbstractTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="Policies", category="Core", printObject=true)
public final class CompositeTriggeringPolicy
extends AbstractTriggeringPolicy {
    private final TriggeringPolicy[] triggeringPolicies;

    /*
     * WARNING - void declaration
     */
    private CompositeTriggeringPolicy(TriggeringPolicy ... triggeringPolicies) {
        void var1_1;
        this.triggeringPolicies = var1_1;
    }

    public final TriggeringPolicy[] getTriggeringPolicies() {
        return this.triggeringPolicies;
    }

    @Override
    public final void initialize(RollingFileManager manager) {
        TriggeringPolicy[] triggeringPolicyArray = this.triggeringPolicies;
        int n = this.triggeringPolicies.length;
        for (int i = 0; i < n; ++i) {
            TriggeringPolicy triggeringPolicy = triggeringPolicyArray[i];
            LOGGER.debug("Initializing triggering policy {}", (Object)triggeringPolicy.toString());
            triggeringPolicy.initialize(manager);
        }
    }

    @Override
    public final boolean isTriggeringEvent(LogEvent event) {
        TriggeringPolicy[] triggeringPolicyArray = this.triggeringPolicies;
        int n = this.triggeringPolicies.length;
        for (int i = 0; i < n; ++i) {
            TriggeringPolicy triggeringPolicy = triggeringPolicyArray[i];
            if (!triggeringPolicy.isTriggeringEvent(event)) continue;
            return true;
        }
        return false;
    }

    @PluginFactory
    public static CompositeTriggeringPolicy createPolicy(TriggeringPolicy ... triggeringPolicy) {
        TriggeringPolicy[] triggeringPolicyArray;
        return new CompositeTriggeringPolicy(triggeringPolicyArray);
    }

    @Override
    public final boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        boolean stopped = true;
        TriggeringPolicy[] triggeringPolicyArray = this.triggeringPolicies;
        int n = this.triggeringPolicies.length;
        for (int i = 0; i < n; ++i) {
            TriggeringPolicy triggeringPolicy = triggeringPolicyArray[i];
            if (triggeringPolicy instanceof LifeCycle2) {
                stopped &= ((LifeCycle2)((Object)triggeringPolicy)).stop(timeout, timeUnit);
                continue;
            }
            if (!(triggeringPolicy instanceof LifeCycle)) continue;
            ((LifeCycle)((Object)triggeringPolicy)).stop();
            stopped &= true;
        }
        this.setStopped();
        return stopped;
    }

    public final String toString() {
        return "CompositeTriggeringPolicy(policies=" + Arrays.toString(this.triggeringPolicies) + ")";
    }
}

