/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LoggingException;
import org.apache.logging.log4j.core.appender.FileManager;
import org.apache.logging.log4j.core.appender.rolling.FileExtension;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.action.Action;
import org.apache.logging.log4j.core.appender.rolling.action.CompositeAction;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.core.pattern.NotANumber;
import org.apache.logging.log4j.core.util.Integers;
import org.apache.logging.log4j.status.StatusLogger;

public abstract class AbstractRolloverStrategy
implements RolloverStrategy {
    protected static final Logger LOGGER = StatusLogger.getLogger();
    public static final Pattern PATTERN_COUNTER = Pattern.compile(".*%((?<ZEROPAD>0)?(?<PADDING>\\d+))?i.*");
    protected final StrSubstitutor strSubstitutor;

    /*
     * WARNING - void declaration
     */
    protected AbstractRolloverStrategy(StrSubstitutor strSubstitutor) {
        void var1_1;
        this.strSubstitutor = var1_1;
    }

    public StrSubstitutor getStrSubstitutor() {
        return this.strSubstitutor;
    }

    /*
     * WARNING - void declaration
     */
    protected Action merge(Action compressAction, List<Action> custom, boolean stopOnError) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (custom.isEmpty()) {
            return compressAction;
        }
        if (compressAction == null) {
            return new CompositeAction(custom, stopOnError);
        }
        ArrayList<Action> all = new ArrayList<Action>();
        all.add((Action)var1_1);
        all.addAll((Collection<Action>)var2_2);
        return new CompositeAction(all, (boolean)var3_3);
    }

    protected int suffixLength(String lowFilename) {
        for (FileExtension extension : FileExtension.values()) {
            if (!extension.isExtensionFor(lowFilename)) continue;
            return extension.length();
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    protected SortedMap<Integer, Path> getEligibleFiles(RollingFileManager manager) {
        void var1_1;
        return this.getEligibleFiles((RollingFileManager)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    protected SortedMap<Integer, Path> getEligibleFiles(RollingFileManager manager, boolean isAscending) {
        void var2_2;
        void var3_3;
        void var1_1;
        StringBuilder buf = new StringBuilder();
        String pattern = manager.getPatternProcessor().getPattern();
        manager.getPatternProcessor().formatFileName(this.strSubstitutor, buf, (Object)NotANumber.NAN);
        String fileName = manager.isDirectWrite() ? "" : ((FileManager)manager).getFileName();
        return this.getEligibleFiles((String)var1_1, var3_3.toString(), pattern, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected SortedMap<Integer, Path> getEligibleFiles(String path, String pattern) {
        void var2_2;
        void var1_1;
        return this.getEligibleFiles("", (String)var1_1, (String)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected SortedMap<Integer, Path> getEligibleFiles(String path, String logfilePattern, boolean isAscending) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getEligibleFiles("", (String)var1_1, (String)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SortedMap<Integer, Path> getEligibleFiles(String currentFile, String path, String logfilePattern, boolean isAscending) {
        TreeMap<Integer, Path> eligibleFiles;
        block15: {
            eligibleFiles = new TreeMap<Integer, Path>();
            File file = new File(path);
            File parent = file.getParentFile();
            if (parent == null) {
                parent = new File(".");
            } else {
                parent.mkdirs();
            }
            if (!PATTERN_COUNTER.matcher(logfilePattern).matches()) {
                return eligibleFiles;
            }
            Path dir = parent.toPath();
            String fileName = file.getName();
            int suffixLength = this.suffixLength(fileName);
            fileName = suffixLength > 0 ? Pattern.quote(fileName.substring(0, fileName.length() - suffixLength)) + ".*" : Pattern.quote(fileName);
            fileName = fileName.replaceFirst("0*\\u0000", "\\\\E(0?\\\\d+)\\\\Q");
            Pattern pattern = Pattern.compile(fileName);
            Path current = currentFile.length() > 0 ? new File(currentFile).toPath() : null;
            LOGGER.debug("Current file: {}", (Object)currentFile);
            try {
                DirectoryStream<Path> stream2 = Files.newDirectoryStream(dir);
                Throwable throwable = null;
                try {
                    for (Path entry : stream2) {
                        Matcher matcher = pattern.matcher(entry.toFile().getName());
                        if (!matcher.matches() || entry.equals(current)) continue;
                        try {
                            Integer index = Integers.parseInt(matcher.group(1));
                            eligibleFiles.put(index, entry);
                        }
                        catch (NumberFormatException numberFormatException) {
                            LOGGER.debug("Ignoring file {} which matches pattern but the index is invalid.", (Object)entry.toFile().getName());
                        }
                    }
                    if (stream2 == null) break block15;
                }
                catch (Throwable throwable2) {
                    try {
                        Throwable throwable3 = throwable2;
                        throwable = throwable2;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (stream2 == null) throw throwable4;
                        if (throwable == null) {
                            stream2.close();
                            throw throwable4;
                        }
                        try {
                            stream2.close();
                            throw throwable4;
                        }
                        catch (Throwable stream2) {
                            throwable.addSuppressed(stream2);
                            throw throwable4;
                        }
                    }
                }
                stream2.close();
            }
            catch (IOException ioe) {
                void var1_3;
                void var3_6;
                throw new LoggingException("Error reading folder " + var3_6 + " " + ioe.getMessage(), (Throwable)var1_3);
            }
        }
        if (!isAscending) return eligibleFiles.descendingMap();
        return eligibleFiles;
    }
}

