/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rewrite;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.rewrite.RewritePolicy;
import org.apache.logging.log4j.core.config.AppenderControl;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.impl.LocationAware;
import org.apache.logging.log4j.core.util.Booleans;

@Plugin(name="Rewrite", category="Core", elementType="appender", printObject=true)
public final class RewriteAppender
extends AbstractAppender {
    private final Configuration config;
    private final ConcurrentMap<String, AppenderControl> appenders = new ConcurrentHashMap<String, AppenderControl>();
    private final RewritePolicy rewritePolicy;
    private final AppenderRef[] appenderRefs;

    /*
     * WARNING - void declaration
     */
    private RewriteAppender(String name, Filter filter, boolean ignoreExceptions, AppenderRef[] appenderRefs, RewritePolicy rewritePolicy, Configuration config, Property[] properties) {
        super((String)var1_1, (Filter)var2_2, null, (boolean)var3_3, properties);
        void var3_3;
        void var2_2;
        void var1_1;
        this.config = config;
        this.rewritePolicy = rewritePolicy;
        this.appenderRefs = appenderRefs;
    }

    @Override
    public final void start() {
        AppenderRef[] appenderRefArray = this.appenderRefs;
        int n = this.appenderRefs.length;
        for (int i = 0; i < n; ++i) {
            AppenderRef ref = appenderRefArray[i];
            String name = ref.getRef();
            Object appender = this.config.getAppender(name);
            if (appender != null) {
                Filter filter = appender instanceof AbstractAppender ? ((AbstractAppender)appender).getFilter() : null;
                this.appenders.put(name, new AppenderControl((Appender)appender, ref.getLevel(), filter));
                continue;
            }
            LOGGER.error("Appender " + ref + " cannot be located. Reference ignored");
        }
        super.start();
    }

    @Override
    public final void append(LogEvent event) {
        if (this.rewritePolicy != null) {
            event = this.rewritePolicy.rewrite(event);
        }
        for (AppenderControl appenderControl : this.appenders.values()) {
            appenderControl.callAppender(event);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PluginFactory
    public static RewriteAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="ignoreExceptions") String ignore, @PluginElement(value="AppenderRef") AppenderRef[] appenderRefs, @PluginConfiguration Configuration config, @PluginElement(value="RewritePolicy") RewritePolicy rewritePolicy, @PluginElement(value="Filter") Filter filter) {
        void var3_4;
        void var2_3;
        void var1_2;
        String string;
        boolean ignoreExceptions = Booleans.parseBoolean(ignore, true);
        if (name == null) {
            LOGGER.error("No name provided for RewriteAppender");
            return null;
        }
        if (appenderRefs == null) {
            LOGGER.error("No appender references defined for RewriteAppender");
            return null;
        }
        return new RewriteAppender(string, filter, (boolean)var1_2, (AppenderRef[])var2_3, rewritePolicy, (Configuration)var3_4, null);
    }

    @Override
    public final boolean requiresLocation() {
        for (AppenderControl appenderControl : this.appenders.values()) {
            Appender appender = appenderControl.getAppender();
            if (!(appender instanceof LocationAware) || !((LocationAware)((Object)appenderControl)).requiresLocation()) continue;
            return true;
        }
        return false;
    }
}

