/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rewrite;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.rewrite.RewritePolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.impl.ContextDataFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.StringMap;

@Plugin(name="PropertiesRewritePolicy", category="Core", elementType="rewritePolicy", printObject=true)
public final class PropertiesRewritePolicy
implements RewritePolicy {
    protected static final Logger LOGGER = StatusLogger.getLogger();
    private final Map<Property, Boolean> properties;
    private final Configuration config;

    /*
     * WARNING - void declaration
     */
    private PropertiesRewritePolicy(Configuration config, List<Property> props) {
        Iterator<Property> iterator;
        this.config = iterator;
        this.properties = new HashMap<Property, Boolean>(props.size());
        for (Property property : props) {
            void var3_3;
            void var2_2;
            Boolean interpolate = property.getValue().contains("${");
            this.properties.put((Property)var2_2, (Boolean)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final LogEvent rewrite(LogEvent source) {
        void var2_2;
        void var1_1;
        StringMap newContextData = ContextDataFactory.createContextData(source.getContextData());
        for (Map.Entry<Property, Boolean> entry : this.properties.entrySet()) {
            Property prop = entry.getKey();
            newContextData.putValue(prop.getName(), (Object)(entry.getValue() != false ? this.config.getStrSubstitutor().replace(prop.getValue()) : prop.getValue()));
        }
        return new Log4jLogEvent.Builder((LogEvent)var1_1).setContextData((StringMap)var2_2).build();
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder();
        sb.append(" {");
        boolean first = true;
        for (Map.Entry<Property, Boolean> entry : this.properties.entrySet()) {
            void var2_3;
            if (!first) {
                sb.append(", ");
            }
            Property prop = entry.getKey();
            sb.append(prop.getName()).append('=').append(var2_3.getValue());
            boolean bl = false;
        }
        sb.append('}');
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    @PluginFactory
    public static PropertiesRewritePolicy createPolicy(@PluginConfiguration Configuration config, @PluginElement(value="Properties") Property[] props) {
        void var1_1;
        Configuration configuration;
        if (props == null || props.length == 0) {
            LOGGER.error("Properties must be specified for the PropertiesRewritePolicy");
            return null;
        }
        List<Property> properties = Arrays.asList(props);
        return new PropertiesRewritePolicy(configuration, (List<Property>)var1_1);
    }
}

