/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rewrite;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.rewrite.RewritePolicy;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.util.KeyValuePair;

@Plugin(name="LoggerNameLevelRewritePolicy", category="Core", elementType="rewritePolicy", printObject=true)
public class LoggerNameLevelRewritePolicy
implements RewritePolicy {
    private final String loggerName;
    private final Map<Level, Level> map;

    /*
     * WARNING - void declaration
     */
    @PluginFactory
    public static LoggerNameLevelRewritePolicy createPolicy(@PluginAttribute(value="logger") String loggerNamePrefix, @PluginElement(value="KeyValuePair") KeyValuePair[] levelPairs) {
        void var2_2;
        String string;
        void var1_1;
        HashMap<Level, Level> newMap = new HashMap<Level, Level>(levelPairs.length);
        for (void keyValuePair : var1_1) {
            newMap.put(LoggerNameLevelRewritePolicy.getLevel(keyValuePair.getKey()), LoggerNameLevelRewritePolicy.getLevel(keyValuePair.getValue()));
        }
        return new LoggerNameLevelRewritePolicy(string, (Map<Level, Level>)var2_2);
    }

    private static Level getLevel(String name) {
        return Level.getLevel((String)name.toUpperCase(Locale.ROOT));
    }

    /*
     * WARNING - void declaration
     */
    private LoggerNameLevelRewritePolicy(String loggerName, Map<Level, Level> map) {
        void var2_2;
        void var1_1;
        this.loggerName = var1_1;
        this.map = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LogEvent rewrite(LogEvent event) {
        void var3_3;
        Log4jLogEvent log4jLogEvent;
        void var2_2;
        if (event.getLoggerName() == null || !event.getLoggerName().startsWith(this.loggerName)) {
            return event;
        }
        Level sourceLevel = event.getLevel();
        Level newLevel = this.map.get(sourceLevel);
        if (newLevel == null || newLevel == var2_2) {
            return event;
        }
        log4jLogEvent = new Log4jLogEvent.Builder(log4jLogEvent).setLevel((Level)var3_3).build();
        return log4jLogEvent;
    }
}

