/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.nosql;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.appender.db.AbstractDatabaseManager;
import org.apache.logging.log4j.core.appender.nosql.NoSqlConnection;
import org.apache.logging.log4j.core.appender.nosql.NoSqlObject;
import org.apache.logging.log4j.core.appender.nosql.NoSqlProvider;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.core.util.Closer;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.apache.logging.log4j.message.MapMessage;
import org.apache.logging.log4j.util.ReadOnlyStringMap;

public final class NoSqlDatabaseManager<W>
extends AbstractDatabaseManager {
    private static final NoSQLDatabaseManagerFactory FACTORY = new NoSQLDatabaseManagerFactory();
    private final NoSqlProvider<NoSqlConnection<W, ? extends NoSqlObject<W>>> provider;
    private NoSqlConnection<W, ? extends NoSqlObject<W>> connection;
    private final KeyValuePair[] additionalFields;

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static NoSqlDatabaseManager<?> getNoSqlDatabaseManager(String name, int bufferSize, NoSqlProvider<?> provider) {
        void var2_2;
        void var1_1;
        return (NoSqlDatabaseManager)AbstractDatabaseManager.getManager(name, new FactoryData(null, (int)var1_1, (NoSqlProvider<?>)var2_2, null), FACTORY);
    }

    /*
     * WARNING - void declaration
     */
    public static NoSqlDatabaseManager<?> getNoSqlDatabaseManager(String name, int bufferSize, NoSqlProvider<?> provider, KeyValuePair[] additionalFields, Configuration configuration) {
        void var3_3;
        void var2_2;
        void var1_1;
        return (NoSqlDatabaseManager)AbstractDatabaseManager.getManager(name, new FactoryData(configuration, (int)var1_1, (NoSqlProvider<?>)var2_2, (KeyValuePair[])var3_3), FACTORY);
    }

    /*
     * WARNING - void declaration
     */
    private NoSqlDatabaseManager(String name, int bufferSize, NoSqlProvider<NoSqlConnection<W, ? extends NoSqlObject<W>>> provider, KeyValuePair[] additionalFields, Configuration configuration) {
        super((String)var1_1, (int)var2_2, null, configuration);
        void var3_3;
        void var2_2;
        void var1_1;
        this.provider = var3_3;
        this.additionalFields = additionalFields;
    }

    /*
     * WARNING - void declaration
     */
    private NoSqlObject<W> buildMarkerEntity(Marker marker) {
        void var2_2;
        NoSqlObject<W> entity = this.connection.createObject();
        entity.set("name", marker.getName());
        Marker[] parents = marker.getParents();
        if (parents != null) {
            void var3_3;
            NoSqlObject[] parentEntities = new NoSqlObject[parents.length];
            for (int i = 0; i < parents.length; ++i) {
                parentEntities[i] = this.buildMarkerEntity(parents[i]);
            }
            entity.set("parents", (NoSqlObject<W>[])var3_3);
        }
        return var2_2;
    }

    @Override
    protected final boolean commitAndClose() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void connectAndStart() {
        try {
            this.connection = this.provider.getConnection();
            return;
        }
        catch (Exception e) {
            void var1_1;
            throw new AppenderLoggingException("Failed to get connection from NoSQL connection provider.", (Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private NoSqlObject<W>[] convertStackTrace(StackTraceElement[] stackTrace) {
        void var2_2;
        NoSqlObject[] stackTraceEntities = this.connection.createList(stackTrace.length);
        for (int i = 0; i < stackTrace.length; ++i) {
            stackTraceEntities[i] = this.convertStackTraceElement(stackTrace[i]);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private NoSqlObject<W> convertStackTraceElement(StackTraceElement element) {
        void var2_2;
        void var1_1;
        NoSqlObject<W> elementEntity = this.connection.createObject();
        elementEntity.set("className", element.getClassName());
        elementEntity.set("methodName", element.getMethodName());
        elementEntity.set("fileName", element.getFileName());
        elementEntity.set("lineNumber", var1_1.getLineNumber());
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private void setAdditionalFields(NoSqlObject<W> entity) {
        if (this.additionalFields != null) {
            void var2_2;
            void var1_1;
            void var3_3;
            NoSqlObject<W> object = this.connection.createObject();
            StrSubstitutor strSubstitutor = this.getStrSubstitutor();
            Stream.of(this.additionalFields).forEach(arg_0 -> NoSqlDatabaseManager.lambda$setAdditionalFields$0(object, (StrSubstitutor)var3_3, arg_0));
            var1_1.set("additionalFields", var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setFields(LogEvent event, NoSqlObject<W> entity) {
        void var2_2;
        void var1_1;
        entity.set("level", event.getLevel());
        entity.set("loggerName", event.getLoggerName());
        entity.set("message", event.getMessage() == null ? null : event.getMessage().getFormattedMessage());
        StackTraceElement source = event.getSource();
        if (source == null) {
            entity.set("source", (Object)null);
        } else {
            entity.set("source", this.convertStackTraceElement(source));
        }
        Marker marker = event.getMarker();
        if (marker == null) {
            entity.set("marker", (Object)null);
        } else {
            entity.set("marker", this.buildMarkerEntity(marker));
        }
        entity.set("threadId", event.getThreadId());
        entity.set("threadName", event.getThreadName());
        entity.set("threadPriority", event.getThreadPriority());
        entity.set("millis", event.getTimeMillis());
        entity.set("date", new Date(event.getTimeMillis()));
        Throwable thrown = event.getThrown();
        if (thrown == null) {
            entity.set("thrown", (Object)null);
        } else {
            NoSqlObject<W> originalExceptionEntity;
            NoSqlObject<W> exceptionEntity = originalExceptionEntity = this.connection.createObject();
            originalExceptionEntity.set("type", thrown.getClass().getName());
            exceptionEntity.set("message", thrown.getMessage());
            exceptionEntity.set("stackTrace", this.convertStackTrace(thrown.getStackTrace()));
            while (thrown.getCause() != null) {
                thrown = thrown.getCause();
                NoSqlObject<W> causingExceptionEntity = this.connection.createObject();
                causingExceptionEntity.set("type", thrown.getClass().getName());
                causingExceptionEntity.set("message", thrown.getMessage());
                causingExceptionEntity.set("stackTrace", this.convertStackTrace(thrown.getStackTrace()));
                exceptionEntity.set("cause", causingExceptionEntity);
                exceptionEntity = causingExceptionEntity;
            }
            entity.set("thrown", originalExceptionEntity);
        }
        ReadOnlyStringMap contextMap = event.getContextData();
        if (contextMap == null) {
            entity.set("contextMap", (Object)null);
        } else {
            NoSqlObject contextMapEntity = this.connection.createObject();
            contextMap.forEach((key, val) -> {
                void var2_2;
                void var1_1;
                contextMapEntity.set((String)var1_1, var2_2);
            });
            entity.set("contextMap", contextMapEntity);
        }
        ThreadContext.ContextStack contextStack = var1_1.getContextStack();
        if (contextStack == null) {
            entity.set("contextStack", (Object)null);
            return;
        }
        var2_2.set("contextStack", contextStack.asList().toArray());
    }

    /*
     * WARNING - void declaration
     */
    private void setFields(MapMessage<?, ?> mapMessage, NoSqlObject<W> noSqlObject) {
        void var2_2;
        mapMessage.forEach((arg_0, arg_1) -> NoSqlDatabaseManager.lambda$setFields$2((NoSqlObject)var2_2, arg_0, arg_1));
    }

    @Override
    protected final boolean shutdownInternal() {
        return Closer.closeSilently(this.connection);
    }

    @Override
    protected final void startupInternal() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void writeInternal(LogEvent event, Serializable serializable) {
        void var3_3;
        if (!this.isRunning() || this.connection == null || this.connection.isClosed()) {
            throw new AppenderLoggingException("Cannot write logging event; NoSQL manager not connected to the database.");
        }
        NoSqlObject<W> entity = this.connection.createObject();
        if (serializable instanceof MapMessage) {
            void var2_2;
            this.setFields((MapMessage)var2_2, entity);
        } else {
            void var1_1;
            this.setFields((LogEvent)var1_1, entity);
        }
        this.setAdditionalFields(entity);
        this.connection.insertObject((NoSqlObject<W>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$setFields$2(NoSqlObject noSqlObject, String key, Object value) {
        void var2_2;
        void var1_1;
        noSqlObject.set((String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$setAdditionalFields$0(NoSqlObject object, StrSubstitutor strSubstitutor, KeyValuePair f) {
        void var2_2;
        void var1_1;
        object.set(f.getKey(), strSubstitutor != null ? var1_1.replace(f.getValue()) : var2_2.getValue());
    }

    private static final class NoSQLDatabaseManagerFactory
    implements ManagerFactory<NoSqlDatabaseManager<?>, FactoryData> {
        private NoSQLDatabaseManagerFactory() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final NoSqlDatabaseManager<?> createManager(String name, FactoryData data) {
            void var2_2;
            void var1_1;
            Objects.requireNonNull(data, "data");
            return new NoSqlDatabaseManager((String)var1_1, data.getBufferSize(), data.provider, data.additionalFields, var2_2.getConfiguration());
        }
    }

    private static final class FactoryData
    extends AbstractDatabaseManager.AbstractFactoryData {
        private final NoSqlProvider<?> provider;
        private final KeyValuePair[] additionalFields;

        /*
         * WARNING - void declaration
         */
        protected FactoryData(Configuration configuration, int bufferSize, NoSqlProvider<?> provider, KeyValuePair[] additionalFields) {
            super((Configuration)var1_1, (int)var2_2, null);
            void var3_3;
            void var2_2;
            void var1_1;
            this.provider = (NoSqlProvider)Objects.requireNonNull(var3_3, "provider");
            this.additionalFields = additionalFields;
        }
    }
}

