/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.mom.kafka;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.appender.mom.kafka.DefaultKafkaProducerFactory;
import org.apache.logging.log4j.core.appender.mom.kafka.KafkaProducerFactory;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.util.Integers;
import org.apache.logging.log4j.core.util.Log4jThread;

public class KafkaManager
extends AbstractManager {
    public static final String DEFAULT_TIMEOUT_MILLIS = "30000";
    static KafkaProducerFactory producerFactory = new DefaultKafkaProducerFactory();
    private final Properties config = new Properties();
    private Producer<byte[], byte[]> producer;
    private final int timeoutMillis;
    private final String topic;
    private final String key;
    private final boolean syncSend;
    private final boolean sendTimestamp;
    private static final KafkaManagerFactory factory = new KafkaManagerFactory();

    /*
     * WARNING - void declaration
     */
    public KafkaManager(LoggerContext loggerContext, String name, String topic, boolean syncSend, Property[] properties, String key) {
        this((LoggerContext)var1_1, (String)var2_2, (String)var3_3, syncSend, false, properties, key);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private KafkaManager(LoggerContext loggerContext, String name, String topic, boolean syncSend, boolean sendTimestamp, Property[] properties, String key) {
        super((LoggerContext)loggerContext, (String)var2_2);
        void var1_1;
        void var3_4;
        void var2_2;
        this.topic = (String)Objects.requireNonNull(var3_4, "topic");
        this.syncSend = syncSend;
        this.sendTimestamp = sendTimestamp;
        this.config.put("key.serializer", ByteArraySerializer.class);
        this.config.put("value.serializer", ByteArraySerializer.class);
        this.config.put("batch.size", (Object)0);
        loggerContext = properties;
        int n = properties.length;
        for (int i = 0; i < n; ++i) {
            Property property = loggerContext[i];
            this.config.setProperty(property.getName(), property.getValue());
        }
        this.key = key;
        String timeoutMillis = this.config.getProperty("timeout.ms");
        if (timeoutMillis == null) {
            timeoutMillis = this.config.getProperty("request.timeout.ms", DEFAULT_TIMEOUT_MILLIS);
        }
        this.timeoutMillis = Integers.parseInt((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean releaseSub(long timeout, TimeUnit timeUnit) {
        if (timeout > 0L) {
            void var3_2;
            void var1_1;
            this.closeProducer((long)var1_1, (TimeUnit)var3_2);
        } else {
            KafkaManager kafkaManager = this;
            kafkaManager.closeProducer(kafkaManager.timeoutMillis, TimeUnit.MILLISECONDS);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void closeProducer(long timeout, TimeUnit timeUnit) {
        if (this.producer != null) {
            Log4jThread closeThread = new Log4jThread(() -> {
                if (this.producer != null) {
                    this.producer.close();
                }
            }, "KafkaManager-CloseThread");
            closeThread.setDaemon(true);
            closeThread.start();
            try {
                void var1_1;
                void var3_2;
                closeThread.join(var3_2.toMillis((long)var1_1));
                return;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void send(byte[] msg) throws ExecutionException, InterruptedException, TimeoutException {
        void var1_1;
        this.send((byte[])var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void send(byte[] msg, Long eventTimestamp) throws ExecutionException, InterruptedException, TimeoutException {
        if (this.producer != null) {
            void var1_1;
            void var3_3;
            void var2_2;
            byte[] newKey = null;
            if (this.key != null && this.key.contains("${")) {
                newKey = this.getLoggerContext().getConfiguration().getStrSubstitutor().replace(this.key).getBytes(StandardCharsets.UTF_8);
            } else if (this.key != null) {
                newKey = this.key.getBytes(StandardCharsets.UTF_8);
            }
            Long timestamp = this.sendTimestamp ? eventTimestamp : null;
            Object newRecord = new ProducerRecord(this.topic, null, (Long)var2_2, (Object)var3_3, (Object)msg);
            if (this.syncSend) {
                newRecord = this.producer.send(newRecord);
                newRecord.get(this.timeoutMillis, TimeUnit.MILLISECONDS);
                return;
            }
            this.producer.send((ProducerRecord)var1_1, (metadata, e) -> {
                if (e != null) {
                    void var2_2;
                    LOGGER.error("Unable to write to Kafka in appender [" + this.getName() + "]", (Throwable)var2_2);
                }
            });
        }
    }

    public void startup() {
        if (this.producer == null) {
            this.producer = producerFactory.newKafkaProducer(this.config);
        }
    }

    public String getTopic() {
        return this.topic;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static KafkaManager getManager(LoggerContext loggerContext, String name, String topic, boolean syncSend, Property[] properties, String key) {
        void var3_3;
        void var2_2;
        void var1_1;
        return KafkaManager.getManager(loggerContext, (String)var1_1, (String)var2_2, (boolean)var3_3, false, properties, key);
    }

    /*
     * WARNING - void declaration
     */
    static KafkaManager getManager(LoggerContext loggerContext, String name, String topic, boolean syncSend, boolean sendTimestamp, Property[] properties, String key) {
        void var3_3;
        void var2_2;
        LoggerContext loggerContext2;
        void var1_1;
        StringBuilder sb = new StringBuilder(name);
        sb.append(" ").append(topic).append(" ").append(syncSend).append(" ").append(sendTimestamp);
        Property[] propertyArray = properties;
        int n = properties.length;
        for (int i = 0; i < n; ++i) {
            Property prop = propertyArray[i];
            sb.append(" ").append(prop.getName()).append("=").append(prop.getValue());
        }
        return KafkaManager.getManager(var1_1.toString(), factory, new FactoryData(loggerContext2, (String)var2_2, (boolean)var3_3, sendTimestamp, properties, key));
    }

    private static class KafkaManagerFactory
    implements ManagerFactory<KafkaManager, FactoryData> {
        private KafkaManagerFactory() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public KafkaManager createManager(String name, FactoryData data) {
            void var2_2;
            void var1_1;
            return new KafkaManager(data.loggerContext, (String)var1_1, data.topic, data.syncSend, data.sendTimestamp, data.properties, ((FactoryData)var2_2).key);
        }
    }

    private static class FactoryData {
        private final LoggerContext loggerContext;
        private final String topic;
        private final boolean syncSend;
        private final boolean sendTimestamp;
        private final Property[] properties;
        private final String key;

        /*
         * WARNING - void declaration
         */
        public FactoryData(LoggerContext loggerContext, String topic, boolean syncSend, boolean sendTimestamp, Property[] properties, String key) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.loggerContext = var1_1;
            this.topic = var2_2;
            this.syncSend = var3_3;
            this.sendTimestamp = sendTimestamp;
            this.properties = properties;
            this.key = key;
        }
    }
}

