/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.mom.kafka;

import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.mom.kafka.KafkaManager;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.layout.SerializedLayout;
import org.apache.logging.log4j.core.util.Integers;

@Plugin(name="Kafka", category="Core", elementType="appender", printObject=true)
public final class KafkaAppender
extends AbstractAppender {
    private static final String[] KAFKA_CLIENT_PACKAGES = new String[]{"org.apache.kafka.common", "org.apache.kafka.clients"};
    private final Integer retryCount;
    private final KafkaManager manager;

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static KafkaAppender createAppender(Layout<? extends Serializable> layout, Filter filter, String name, boolean ignoreExceptions, String topic, Property[] properties, Configuration configuration, String key) {
        void var3_3;
        void var1_1;
        Layout<? extends Serializable> layout2;
        void var2_2;
        if (layout == null) {
            AbstractLifeCycle.LOGGER.error("No layout provided for KafkaAppender");
            return null;
        }
        KafkaManager kafkaManager = KafkaManager.getManager(configuration.getLoggerContext(), name, topic, true, properties, key);
        return new KafkaAppender((String)var2_2, layout2, (Filter)var1_1, (boolean)var3_3, kafkaManager, null, 0);
    }

    private static boolean isRecursive(LogEvent event) {
        LogEvent logEvent;
        return Stream.of(KAFKA_CLIENT_PACKAGES).anyMatch(prefix -> {
            void var1_1;
            return logEvent.getLoggerName().startsWith((String)var1_1);
        });
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Builder)new Builder().asBuilder());
    }

    /*
     * WARNING - void declaration
     */
    private KafkaAppender(String name, Layout<? extends Serializable> layout, Filter filter, boolean ignoreExceptions, KafkaManager manager, Property[] properties, int retryCount) {
        super((String)var1_1, (Filter)var3_3, (Layout<? extends Serializable>)var2_2, ignoreExceptions, properties);
        void var2_2;
        void var3_3;
        void var1_1;
        this.manager = Objects.requireNonNull(manager, "manager");
        this.retryCount = retryCount;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void append(LogEvent event) {
        if (event.getLoggerName() != null && KafkaAppender.isRecursive(event)) {
            LOGGER.warn("Recursive logging from [{}] for appender [{}].", (Object)event.getLoggerName(), (Object)this.getName());
            return;
        }
        try {
            this.tryAppend(event);
            return;
        }
        catch (Exception e) {
            void var2_2;
            void var1_1;
            if (this.retryCount != null) {
                for (int currentRetryAttempt = 0; currentRetryAttempt < this.retryCount; ++currentRetryAttempt) {
                    try {
                        this.tryAppend(event);
                        break;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
            }
            this.error("Unable to write to Kafka in appender [" + this.getName() + "]", (LogEvent)var1_1, (Throwable)var2_2);
            return;
        }
    }

    @Override
    public final void start() {
        super.start();
        this.manager.startup();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean stop(long timeout, TimeUnit timeUnit) {
        void var3_2;
        void var1_1;
        this.setStopping();
        boolean bl = super.stop(timeout, timeUnit, false);
        boolean stopped = bl & this.manager.stop((long)var1_1, (TimeUnit)var3_2);
        this.setStopped();
        return stopped;
    }

    @Override
    public final String toString() {
        return "KafkaAppender{name=" + this.getName() + ", state=" + (Object)((Object)this.getState()) + ", topic=" + this.manager.getTopic() + '}';
    }

    /*
     * WARNING - void declaration
     */
    private void tryAppend(LogEvent event) throws ExecutionException, InterruptedException, TimeoutException {
        void var1_1;
        void var2_2;
        byte[] data;
        Layout<? extends Serializable> layout = this.getLayout();
        if (layout instanceof SerializedLayout) {
            void var3_3;
            byte[] header = layout.getHeader();
            byte[] body = layout.toByteArray(event);
            data = new byte[header.length + body.length];
            System.arraycopy(header, 0, data, 0, header.length);
            System.arraycopy(body, 0, data, ((void)var3_3).length, body.length);
        } else {
            data = data.toByteArray(event);
        }
        this.manager.send((byte[])var2_2, var1_1.getTimeMillis());
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<KafkaAppender> {
        @PluginAttribute(value="retryCount")
        private int retryCount;
        @PluginAttribute(value="topic")
        private String topic;
        @PluginAttribute(value="key")
        private String key;
        @PluginAttribute(value="syncSend", defaultBoolean=true)
        private boolean syncSend;
        @PluginAttribute(value="sendEventTimestamp", defaultBoolean=false)
        private boolean sendEventTimestamp;

        /*
         * WARNING - void declaration
         */
        @Override
        public KafkaAppender build() {
            void var2_2;
            void var1_1;
            Layout<Serializable> layout = this.getLayout();
            if (layout == null) {
                LOGGER.error("No layout provided for KafkaAppender");
                return null;
            }
            KafkaManager kafkaManager = KafkaManager.getManager(this.getConfiguration().getLoggerContext(), this.getName(), this.topic, this.syncSend, this.sendEventTimestamp, this.getPropertyArray(), this.key);
            return new KafkaAppender(this.getName(), (Layout)var1_1, this.getFilter(), this.isIgnoreExceptions(), (KafkaManager)var2_2, this.getPropertyArray(), this.getRetryCount());
        }

        /*
         * WARNING - void declaration
         */
        public Integer getRetryCount() {
            void var1_1;
            Integer intRetryCount = null;
            try {
                intRetryCount = this.retryCount;
            }
            catch (NumberFormatException numberFormatException) {}
            return var1_1;
        }

        public String getTopic() {
            return this.topic;
        }

        public boolean isSendEventTimestamp() {
            return this.sendEventTimestamp;
        }

        public boolean isSyncSend() {
            return this.syncSend;
        }

        /*
         * WARNING - void declaration
         */
        public B setKey(String key) {
            void var1_1;
            this.key = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public B setRetryCount(String retryCount) {
            void var1_1;
            this.retryCount = Integers.parseInt((String)var1_1, 0);
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setRetryCount(int retryCount) {
            void var1_1;
            this.retryCount = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setSendEventTimestamp(boolean sendEventTimestamp) {
            void var1_1;
            this.sendEventTimestamp = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setSyncSend(boolean syncSend) {
            void var1_1;
            this.syncSend = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setTopic(String topic) {
            void var1_1;
            this.topic = var1_1;
            return (B)((Builder)this.asBuilder());
        }
    }
}

