/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.mom;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.NamingException;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.net.JndiManager;
import org.apache.logging.log4j.core.util.Log4jThread;
import org.apache.logging.log4j.status.StatusLogger;

public class JmsManager
extends AbstractManager {
    static final JmsManagerFactory FACTORY = new JmsManagerFactory();
    private final JmsManagerConfiguration configuration;
    private volatile Reconnector reconnector;
    private volatile JndiManager jndiManager;
    private volatile Connection connection;
    private volatile Session session;
    private volatile Destination destination;
    private volatile MessageProducer messageProducer;

    /*
     * WARNING - void declaration
     */
    public static JmsManager getJmsManager(String name, Properties jndiProperties, String connectionFactoryName, String destinationName, String userName, char[] password, boolean immediateFail, long reconnectIntervalMillis) {
        void var1_1;
        String string;
        void var3_3;
        void var2_2;
        JmsManagerConfiguration configuration = new JmsManagerConfiguration(jndiProperties, (String)var2_2, (String)var3_3, userName, password, immediateFail, reconnectIntervalMillis);
        return JmsManager.getManager(string, FACTORY, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private JmsManager(String name, JmsManagerConfiguration configuration) {
        super(null, (String)var1_1);
        void var2_2;
        void var1_1;
        this.configuration = configuration;
        this.jndiManager = var2_2.getJndiManager();
        try {
            this.connection = this.createConnection(this.jndiManager);
            this.session = this.createSession(this.connection);
            this.destination = this.createDestination(this.jndiManager);
            this.messageProducer = this.createMessageProducer(this.session, this.destination);
            this.connection.start();
            return;
        }
        catch (JMSException | NamingException throwable) {
            this.reconnector = this.createReconnector();
            this.reconnector.start();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean closeConnection() {
        if (this.connection == null) {
            return true;
        }
        Connection temp = this.connection;
        this.connection = null;
        try {
            temp.close();
            return true;
        }
        catch (JMSException e) {
            void var2_2;
            void var1_1;
            StatusLogger.getLogger().debug("Caught exception closing JMS Connection: {} ({}); continuing JMS manager shutdown", (Object)e.getLocalizedMessage(), (Object)var1_1, (Object)var2_2);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean closeJndiManager() {
        void var1_1;
        if (this.jndiManager == null) {
            return true;
        }
        JndiManager tmp = this.jndiManager;
        this.jndiManager = null;
        var1_1.close();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean closeMessageProducer() {
        if (this.messageProducer == null) {
            return true;
        }
        MessageProducer temp = this.messageProducer;
        this.messageProducer = null;
        try {
            temp.close();
            return true;
        }
        catch (JMSException e) {
            void var2_2;
            void var1_1;
            StatusLogger.getLogger().debug("Caught exception closing JMS MessageProducer: {} ({}); continuing JMS manager shutdown", (Object)e.getLocalizedMessage(), (Object)var1_1, (Object)var2_2);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean closeSession() {
        if (this.session == null) {
            return true;
        }
        Session temp = this.session;
        this.session = null;
        try {
            temp.close();
            return true;
        }
        catch (JMSException e) {
            void var2_2;
            void var1_1;
            StatusLogger.getLogger().debug("Caught exception closing JMS Session: {} ({}); continuing JMS manager shutdown", (Object)e.getLocalizedMessage(), (Object)var1_1, (Object)var2_2);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Connection createConnection(JndiManager jndiManager) throws NamingException, JMSException {
        void var1_1;
        ConnectionFactory connectionFactory = (ConnectionFactory)jndiManager.lookup(this.configuration.getConnectionFactoryName());
        if (this.configuration.getUserName() != null && this.configuration.getPassword() != null) {
            return connectionFactory.createConnection(this.configuration.getUserName(), this.configuration.getPassword() == null ? null : String.valueOf(this.configuration.getPassword()));
        }
        return var1_1.createConnection();
    }

    private Destination createDestination(JndiManager jndiManager) throws NamingException {
        return (Destination)jndiManager.lookup(this.configuration.getDestinationName());
    }

    /*
     * WARNING - void declaration
     */
    public Message createMessage(Serializable object) throws JMSException {
        void var1_1;
        if (object instanceof String) {
            return this.session.createTextMessage((String)((Object)object));
        }
        if (object instanceof org.apache.logging.log4j.message.MapMessage) {
            return this.map((org.apache.logging.log4j.message.MapMessage)object, this.session.createMapMessage());
        }
        return this.session.createObjectMessage((Serializable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void createMessageAndSend(LogEvent event, Serializable serializable) throws JMSException {
        void var2_2;
        void var1_1;
        Message message = this.createMessage(serializable);
        message.setJMSTimestamp(var1_1.getTimeMillis());
        this.messageProducer.send((Message)var2_2);
    }

    public MessageConsumer createMessageConsumer() throws JMSException {
        return this.session.createConsumer(this.destination);
    }

    /*
     * WARNING - void declaration
     */
    public MessageProducer createMessageProducer(Session session, Destination destination) throws JMSException {
        void var2_2;
        return session.createProducer((Destination)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private Reconnector createReconnector() {
        void var1_1;
        JmsManager jmsManager = this;
        Reconnector recon = jmsManager.new Reconnector(jmsManager);
        recon.setDaemon(true);
        recon.setPriority(1);
        return var1_1;
    }

    private Session createSession(Connection connection) throws JMSException {
        return connection.createSession(false, 1);
    }

    public JmsManagerConfiguration getJmsManagerConfiguration() {
        return this.configuration;
    }

    JndiManager getJndiManager() {
        return this.configuration.getJndiManager();
    }

    /*
     * WARNING - void declaration
     */
    <T> T lookup(String destinationName) throws NamingException {
        void var1_1;
        return this.jndiManager.lookup((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private MapMessage map(org.apache.logging.log4j.message.MapMessage<?, ?> log4jMapMessage, MapMessage jmsMapMessage) {
        void var2_2;
        log4jMapMessage.forEach((key, value) -> {
            try {
                jmsMapMessage.setObject(key, value);
                return;
            }
            catch (JMSException e) {
                void var0_1;
                void var2_3;
                void var1_2;
                throw new IllegalArgumentException(String.format("%s mapping key '%s' to value '%s': %s", ((Object)((Object)e)).getClass(), var1_2, var2_3, e.getLocalizedMessage()), (Throwable)var0_1);
            }
        });
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean releaseSub(long timeout, TimeUnit timeUnit) {
        void var3_2;
        void var1_1;
        if (this.reconnector != null) {
            this.reconnector.shutdown();
            this.reconnector.interrupt();
            this.reconnector = null;
        }
        boolean bl = false & this.closeJndiManager();
        bl &= this.closeMessageProducer();
        bl &= this.closeSession();
        return (bl &= this.closeConnection()) && this.jndiManager.stop((long)var1_1, (TimeUnit)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    void send(LogEvent event, Serializable serializable) {
        if (this.messageProducer == null && this.reconnector != null && !this.configuration.isImmediateFail()) {
            this.reconnector.latch();
            if (this.messageProducer == null) {
                throw new AppenderLoggingException("Error sending to JMS Manager '" + this.getName() + "': JMS message producer not available");
            }
        }
        JmsManager jmsManager = this;
        synchronized (jmsManager) {
            block11: {
                try {
                    this.createMessageAndSend(event, serializable);
                }
                catch (JMSException causeEx) {
                    if (!this.configuration.isRetry() || this.reconnector != null) break block11;
                    this.reconnector = this.createReconnector();
                    try {
                        this.closeJndiManager();
                        this.reconnector.reconnect();
                    }
                    catch (JMSException | NamingException reconnEx) {
                        void var1_2;
                        JmsManager.logger().debug("Cannot reestablish JMS connection to {}: {}; starting reconnector thread {}", (Object)this.configuration, (Object)reconnEx.getLocalizedMessage(), (Object)this.reconnector.getName(), (Object)var1_2);
                        this.reconnector.start();
                        throw new AppenderLoggingException(String.format("JMS exception sending to %s for %s", this.getName(), this.configuration), causeEx);
                    }
                    try {
                        void var2_4;
                        void var1_1;
                        this.createMessageAndSend((LogEvent)var1_1, (Serializable)var2_4);
                    }
                    catch (JMSException jMSException) {
                        throw new AppenderLoggingException(String.format("Error sending to %s after reestablishing JMS connection for %s", this.getName(), this.configuration), causeEx);
                    }
                }
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Connection access$300(JmsManager x0, JndiManager x1) throws NamingException, JMSException {
        void var1_1;
        return x0.createConnection((JndiManager)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Session access$400(JmsManager x0, Connection x1) throws JMSException {
        void var1_1;
        return x0.createSession((Connection)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Destination access$500(JmsManager x0, JndiManager x1) throws NamingException {
        void var1_1;
        return x0.createDestination((JndiManager)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ JndiManager access$602(JmsManager x0, JndiManager x1) {
        void var1_1;
        x0.jndiManager = var1_1;
        return x0.jndiManager;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Connection access$702(JmsManager x0, Connection x1) {
        void var1_1;
        x0.connection = var1_1;
        return x0.connection;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Session access$802(JmsManager x0, Session x1) {
        void var1_1;
        x0.session = var1_1;
        return x0.session;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Destination access$902(JmsManager x0, Destination x1) {
        void var1_1;
        x0.destination = var1_1;
        return x0.destination;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ MessageProducer access$1002(JmsManager x0, MessageProducer x1) {
        void var1_1;
        x0.messageProducer = var1_1;
        return x0.messageProducer;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Reconnector access$1102(JmsManager x0, Reconnector x1) {
        void var1_1;
        x0.reconnector = var1_1;
        return x0.reconnector;
    }

    private class Reconnector
    extends Log4jThread {
        private final CountDownLatch latch;
        private volatile boolean shutdown;
        private final Object owner;

        /*
         * WARNING - void declaration
         */
        private Reconnector(Object owner) {
            void var2_2;
            super("JmsManager-Reconnector");
            this.latch = new CountDownLatch(1);
            this.owner = var2_2;
        }

        public void latch() {
            try {
                this.latch.await();
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        void reconnect() throws NamingException, JMSException {
            JndiManager jndiManager2 = JmsManager.this.getJndiManager();
            Connection connection2 = JmsManager.access$300(JmsManager.this, jndiManager2);
            Session session2 = JmsManager.access$400(JmsManager.this, connection2);
            Destination destination2 = JmsManager.access$500(JmsManager.this, jndiManager2);
            MessageProducer messageProducer2 = JmsManager.this.createMessageProducer(session2, destination2);
            connection2.start();
            Object object = this.owner;
            synchronized (object) {
                void var3_4;
                void var2_3;
                void var1_1;
                JmsManager.access$602(JmsManager.this, (JndiManager)var1_1);
                JmsManager.access$702(JmsManager.this, (Connection)var2_3);
                JmsManager.access$802(JmsManager.this, (Session)var3_4);
                JmsManager.access$902(JmsManager.this, destination2);
                JmsManager.access$1002(JmsManager.this, messageProducer2);
                JmsManager.access$1102(JmsManager.this, null);
                this.shutdown = true;
            }
            JmsManager.logger().debug("Connection reestablished to {}", (Object)JmsManager.this.configuration);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            while (!this.shutdown) {
                try {
                    Reconnector.sleep(JmsManager.this.configuration.getReconnectIntervalMillis());
                    this.reconnect();
                }
                catch (InterruptedException | JMSException | NamingException e) {
                    void var1_1;
                    JmsManager.logger().debug("Cannot reestablish JMS connection to {}: {}", (Object)JmsManager.this.configuration, (Object)e.getLocalizedMessage(), (Object)var1_1);
                }
                finally {
                    this.latch.countDown();
                }
            }
        }

        public void shutdown() {
            this.shutdown = true;
        }
    }

    private static class JmsManagerFactory
    implements ManagerFactory<JmsManager, JmsManagerConfiguration> {
        private JmsManagerFactory() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public JmsManager createManager(String name, JmsManagerConfiguration data) {
            if (JndiManager.isJndiJmsEnabled()) {
                try {
                    return new JmsManager(name, data);
                }
                catch (Exception e) {
                    void var1_2;
                    void var2_3;
                    JmsManager.logger().error("Error creating JmsManager using JmsManagerConfiguration [{}]", (Object)var2_3, (Object)var1_2);
                    return null;
                }
            }
            JmsManager.logger().error("JNDI must be enabled by setting log4j2.enableJndiJms=true");
            return null;
        }
    }

    public static class JmsManagerConfiguration {
        private final Properties jndiProperties;
        private final String connectionFactoryName;
        private final String destinationName;
        private final String userName;
        private final char[] password;
        private final boolean immediateFail;
        private final boolean retry;
        private final long reconnectIntervalMillis;

        /*
         * WARNING - void declaration
         */
        JmsManagerConfiguration(Properties jndiProperties, String connectionFactoryName, String destinationName, String userName, char[] password, boolean immediateFail, long reconnectIntervalMillis) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.jndiProperties = var1_1;
            this.connectionFactoryName = var2_2;
            this.destinationName = var3_3;
            this.userName = userName;
            this.password = password;
            this.immediateFail = immediateFail;
            this.reconnectIntervalMillis = reconnectIntervalMillis;
            this.retry = reconnectIntervalMillis > 0L;
        }

        public String getConnectionFactoryName() {
            return this.connectionFactoryName;
        }

        public String getDestinationName() {
            return this.destinationName;
        }

        public JndiManager getJndiManager() {
            return JndiManager.getJndiManager(this.getJndiProperties());
        }

        public Properties getJndiProperties() {
            return this.jndiProperties;
        }

        public char[] getPassword() {
            return this.password;
        }

        public long getReconnectIntervalMillis() {
            return this.reconnectIntervalMillis;
        }

        public String getUserName() {
            return this.userName;
        }

        public boolean isImmediateFail() {
            return this.immediateFail;
        }

        public boolean isRetry() {
            return this.retry;
        }

        public String toString() {
            return "JmsManagerConfiguration [jndiProperties=" + this.jndiProperties + ", connectionFactoryName=" + this.connectionFactoryName + ", destinationName=" + this.destinationName + ", userName=" + this.userName + ", immediateFail=" + this.immediateFail + ", retry=" + this.retry + ", reconnectIntervalMillis=" + this.reconnectIntervalMillis + "]";
        }
    }
}

