/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.mom;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.jms.JMSException;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.mom.JmsManager;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAliases;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.net.JndiManager;

@Plugin(name="JMS", category="Core", elementType="appender", printObject=true)
@PluginAliases(value={"JMSQueue", "JMSTopic"})
public class JmsAppender
extends AbstractAppender {
    private volatile JmsManager manager;

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    /*
     * WARNING - void declaration
     */
    protected JmsAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, Property[] properties, JmsManager manager) throws JMSException {
        super((String)var1_1, (Filter)var2_2, (Layout<? extends Serializable>)var3_3, ignoreExceptions, properties);
        void var3_3;
        void var2_2;
        void var1_1;
        this.manager = manager;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected JmsAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, JmsManager manager) throws JMSException {
        super((String)var1_1, (Filter)var2_2, (Layout<? extends Serializable>)var3_3, ignoreExceptions, Property.EMPTY_ARRAY);
        void var3_3;
        void var2_2;
        void var1_1;
        this.manager = manager;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void append(LogEvent event) {
        void var1_1;
        this.manager.send(event, this.toSerializable((LogEvent)var1_1));
    }

    public JmsManager getManager() {
        return this.manager;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean stop(long timeout, TimeUnit timeUnit) {
        void var3_2;
        void var1_1;
        this.setStopping();
        boolean bl = super.stop(timeout, timeUnit, false);
        boolean stopped = bl & this.manager.stop((long)var1_1, (TimeUnit)var3_2);
        this.setStopped();
        return stopped;
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<JmsAppender> {
        public static final int DEFAULT_RECONNECT_INTERVAL_MILLIS = 5000;
        @PluginBuilderAttribute
        private String factoryName;
        @PluginBuilderAttribute
        private String providerUrl;
        @PluginBuilderAttribute
        private String urlPkgPrefixes;
        @PluginBuilderAttribute
        private String securityPrincipalName;
        @PluginBuilderAttribute(sensitive=true)
        private String securityCredentials;
        @PluginBuilderAttribute
        @Required(message="A javax.jms.ConnectionFactory JNDI name must be specified")
        private String factoryBindingName;
        @PluginBuilderAttribute
        @PluginAliases(value={"queueBindingName", "topicBindingName"})
        @Required(message="A javax.jms.Destination JNDI name must be specified")
        private String destinationBindingName;
        @PluginBuilderAttribute
        private String userName;
        @PluginBuilderAttribute(sensitive=true)
        private char[] password;
        @PluginBuilderAttribute
        private long reconnectIntervalMillis = 5000L;
        @PluginBuilderAttribute
        private boolean immediateFail;
        private JmsManager jmsManager;

        private Builder() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public JmsAppender build() {
            Object configuration;
            JmsManager actualJmsManager = this.jmsManager;
            if (actualJmsManager == null) {
                Properties jndiProperties = JndiManager.createProperties(this.factoryName, this.providerUrl, this.urlPkgPrefixes, this.securityPrincipalName, this.securityCredentials, null);
                configuration = new JmsManager.JmsManagerConfiguration(jndiProperties, this.factoryBindingName, this.destinationBindingName, this.userName, this.password, false, this.reconnectIntervalMillis);
                configuration = AbstractManager.getManager(this.getName(), JmsManager.FACTORY, configuration);
            }
            if (configuration == null) {
                return null;
            }
            Layout<Serializable> layout = this.getLayout();
            if (layout == null) {
                LOGGER.error("No layout provided for JmsAppender");
                return null;
            }
            try {
                void var2_3;
                return new JmsAppender(this.getName(), this.getFilter(), (Layout<? extends Serializable>)var2_3, this.isIgnoreExceptions(), this.getPropertyArray(), (JmsManager)configuration);
            }
            catch (JMSException e) {
                void var1_2;
                throw new IllegalStateException((Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        public Builder setDestinationBindingName(String destinationBindingName) {
            void var1_1;
            this.destinationBindingName = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setFactoryBindingName(String factoryBindingName) {
            void var1_1;
            this.factoryBindingName = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setFactoryName(String factoryName) {
            void var1_1;
            this.factoryName = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setImmediateFail(boolean immediateFail) {
            void var1_1;
            this.immediateFail = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setJmsManager(JmsManager jmsManager) {
            void var1_1;
            this.jmsManager = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setPassword(char[] password) {
            void var1_1;
            this.password = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public Builder setPassword(String password) {
            void var1_1;
            this.password = password == null ? null : var1_1.toCharArray();
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setProviderUrl(String providerUrl) {
            void var1_1;
            this.providerUrl = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setReconnectIntervalMillis(long reconnectIntervalMillis) {
            void var1_1;
            this.reconnectIntervalMillis = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setSecurityCredentials(String securityCredentials) {
            void var1_1;
            this.securityCredentials = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setSecurityPrincipalName(String securityPrincipalName) {
            void var1_1;
            this.securityPrincipalName = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setUrlPkgPrefixes(String urlPkgPrefixes) {
            void var1_1;
            this.urlPkgPrefixes = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public Builder setUsername(String username) {
            void var1_1;
            this.userName = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setUserName(String userName) {
            void var1_1;
            this.userName = var1_1;
            return this;
        }

        public String toString() {
            return "Builder [name=" + this.getName() + ", factoryName=" + this.factoryName + ", providerUrl=" + this.providerUrl + ", urlPkgPrefixes=" + this.urlPkgPrefixes + ", securityPrincipalName=" + this.securityPrincipalName + ", securityCredentials=" + this.securityCredentials + ", factoryBindingName=" + this.factoryBindingName + ", destinationBindingName=" + this.destinationBindingName + ", username=" + this.userName + ", layout=" + this.getLayout() + ", filter=" + this.getFilter() + ", ignoreExceptions=" + this.isIgnoreExceptions() + ", jmsManager=" + this.jmsManager + "]";
        }
    }
}

