/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.db.jdbc;

import java.io.Serializable;
import java.io.StringReader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLTransactionRollbackException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.StringLayout;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.appender.db.AbstractDatabaseManager;
import org.apache.logging.log4j.core.appender.db.ColumnMapping;
import org.apache.logging.log4j.core.appender.db.DbAppenderLoggingException;
import org.apache.logging.log4j.core.appender.db.jdbc.ColumnConfig;
import org.apache.logging.log4j.core.appender.db.jdbc.ConnectionSource;
import org.apache.logging.log4j.core.config.plugins.convert.DateTypeConverter;
import org.apache.logging.log4j.core.config.plugins.convert.TypeConverters;
import org.apache.logging.log4j.core.util.Closer;
import org.apache.logging.log4j.core.util.Log4jThread;
import org.apache.logging.log4j.message.MapMessage;
import org.apache.logging.log4j.spi.ThreadContextMap;
import org.apache.logging.log4j.spi.ThreadContextStack;
import org.apache.logging.log4j.util.IndexedReadOnlyStringMap;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.Strings;

public final class JdbcDatabaseManager
extends AbstractDatabaseManager {
    private static final JdbcDatabaseManagerFactory INSTANCE = new JdbcDatabaseManagerFactory();
    private final List<ColumnConfig> columnConfigs;
    private final String sqlStatement;
    private final FactoryData factoryData;
    private volatile Connection connection;
    private volatile PreparedStatement statement;
    private volatile Reconnector reconnector;
    private volatile boolean isBatchSupported;
    private volatile Map<String, ResultSetColumnMetaData> columnMetaData;

    /*
     * WARNING - void declaration
     */
    private static void appendColumnName(int i, String columnName, StringBuilder sb) {
        void var1_1;
        void var2_2;
        if (i > 1) {
            sb.append(',');
        }
        var2_2.append((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static void appendColumnNames(String sqlVerb, FactoryData data, StringBuilder sb) {
        String columnName;
        int i = 1;
        if (data.columnMappings != null) {
            for (ColumnMapping colMapping : data.columnMappings) {
                columnName = colMapping.getName();
                JdbcDatabaseManager.appendColumnName(i, columnName, sb);
                JdbcDatabaseManager.logger().trace("Appending {} {}[{}]: {}={} ", (Object)sqlVerb, (Object)colMapping.getClass().getSimpleName(), (Object)i, (Object)columnName, (Object)colMapping);
                ++i;
            }
        }
        if (data.columnConfigs != null) {
            void var1_1;
            for (ColumnConfig colConfig : ((FactoryData)var1_1).columnConfigs) {
                columnName = colConfig.getColumnName();
                JdbcDatabaseManager.appendColumnName(i, columnName, sb);
                JdbcDatabaseManager.logger().trace("Appending {} {}[{}]: {}={} ", (Object)sqlVerb, (Object)colConfig.getClass().getSimpleName(), (Object)i, (Object)columnName, (Object)colConfig);
                ++i;
            }
        }
    }

    private static JdbcDatabaseManagerFactory getFactory() {
        return INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static JdbcDatabaseManager getJDBCDatabaseManager(String name, int bufferSize, ConnectionSource connectionSource, String tableName, ColumnConfig[] columnConfigs) {
        void var3_3;
        void var2_2;
        void var1_1;
        return JdbcDatabaseManager.getManager(name, new FactoryData((int)var1_1, null, (ConnectionSource)var2_2, (String)var3_3, columnConfigs, ColumnMapping.EMPTY_ARRAY, false, 5000L, true), JdbcDatabaseManager.getFactory());
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static JdbcDatabaseManager getManager(String name, int bufferSize, Layout<? extends Serializable> layout, ConnectionSource connectionSource, String tableName, ColumnConfig[] columnConfigs, ColumnMapping[] columnMappings) {
        void var3_3;
        void var2_2;
        void var1_1;
        return JdbcDatabaseManager.getManager(name, new FactoryData((int)var1_1, (Layout<? extends Serializable>)var2_2, (ConnectionSource)var3_3, tableName, columnConfigs, columnMappings, false, 5000L, true), JdbcDatabaseManager.getFactory());
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static JdbcDatabaseManager getManager(String name, int bufferSize, Layout<? extends Serializable> layout, ConnectionSource connectionSource, String tableName, ColumnConfig[] columnConfigs, ColumnMapping[] columnMappings, boolean immediateFail, long reconnectIntervalMillis) {
        void var3_3;
        void var1_1;
        return JdbcDatabaseManager.getManager(name, new FactoryData((int)var1_1, null, (ConnectionSource)var3_3, tableName, columnConfigs, columnMappings, false, 5000L, true), JdbcDatabaseManager.getFactory());
    }

    /*
     * WARNING - void declaration
     */
    public static JdbcDatabaseManager getManager(String name, int bufferSize, Layout<? extends Serializable> layout, ConnectionSource connectionSource, String tableName, ColumnConfig[] columnConfigs, ColumnMapping[] columnMappings, boolean immediateFail, long reconnectIntervalMillis, boolean truncateStrings) {
        void var3_3;
        void var2_2;
        void var1_1;
        return JdbcDatabaseManager.getManager(name, new FactoryData((int)var1_1, (Layout<? extends Serializable>)var2_2, (ConnectionSource)var3_3, tableName, columnConfigs, columnMappings, immediateFail, reconnectIntervalMillis, truncateStrings), JdbcDatabaseManager.getFactory());
    }

    /*
     * WARNING - void declaration
     */
    private JdbcDatabaseManager(String name, String sqlStatement, List<ColumnConfig> columnConfigs, FactoryData factoryData) {
        super((String)var1_1, factoryData.getBufferSize());
        void var3_3;
        void var2_2;
        void var1_1;
        this.sqlStatement = var2_2;
        this.columnConfigs = var3_3;
        this.factoryData = factoryData;
    }

    /*
     * WARNING - void declaration
     */
    private void checkConnection() {
        void var2_2;
        void var1_1;
        boolean connClosed = true;
        try {
            JdbcDatabaseManager jdbcDatabaseManager = this;
            connClosed = jdbcDatabaseManager.isClosed(jdbcDatabaseManager.connection);
        }
        catch (SQLException sQLException) {}
        boolean stmtClosed = true;
        try {
            JdbcDatabaseManager jdbcDatabaseManager = this;
            stmtClosed = jdbcDatabaseManager.isClosed(jdbcDatabaseManager.statement);
        }
        catch (SQLException sQLException) {}
        if (!this.isRunning() || var1_1 != false || var2_2 != false) {
            this.closeResources(false);
            if (this.reconnector != null && !this.factoryData.immediateFail) {
                this.reconnector.latch();
                if (this.connection == null) {
                    throw new AppenderLoggingException("Error writing to JDBC Manager '%s': JDBC connection not available [%s]", this.getName(), this.fieldsToString());
                }
                if (this.statement == null) {
                    throw new AppenderLoggingException("Error writing to JDBC Manager '%s': JDBC statement not available [%s].", this.getName(), this.connection, this.fieldsToString());
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void closeResources(boolean logExceptions) {
        block5: {
            PreparedStatement tempPreparedStatement = this.statement;
            this.statement = null;
            try {
                Closer.close(tempPreparedStatement);
            }
            catch (Exception e) {
                if (!logExceptions) break block5;
                this.logWarn("Failed to close SQL statement logging event or flushing buffer", e);
            }
        }
        Connection tempConnection = this.connection;
        this.connection = null;
        try {
            Closer.close(tempConnection);
            return;
        }
        catch (Exception e) {
            void var1_1;
            if (var1_1 != false) {
                void var2_4;
                this.logWarn("Failed to close database connection logging event or flushing buffer", (Throwable)var2_4);
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final boolean commitAndClose() {
        block8: {
            try {
                if (this.connection == null || this.connection.isClosed()) break block8;
                if (this.isBuffered() && this.isBatchSupported && this.statement != null) {
                    int[] result;
                    JdbcDatabaseManager.logger().debug("Executing batch PreparedStatement {}", (Object)this.statement);
                    try {
                        result = this.statement.executeBatch();
                    }
                    catch (SQLTransactionRollbackException e) {
                        JdbcDatabaseManager.logger().debug("{} executing batch PreparedStatement {}, retrying.", (Object)e, (Object)this.statement);
                        result = this.statement.executeBatch();
                    }
                    JdbcDatabaseManager.logger().debug("Batch result: {}", (Object)Arrays.toString(result));
                }
                JdbcDatabaseManager.logger().debug("Committing Connection {}", (Object)this.connection);
                this.connection.commit();
            }
            catch (SQLException e) {
                void var1_3;
                throw new DbAppenderLoggingException((Throwable)var1_3, "Failed to commit transaction logging event or flushing buffer [%s]", this.fieldsToString());
            }
            finally {
                this.closeResources(true);
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean commitAndCloseAll() {
        if (this.connection != null || this.statement != null) {
            try {
                this.commitAndClose();
                return true;
            }
            catch (AppenderLoggingException appenderLoggingException) {
                void var1_1;
                void var2_2;
                AppenderLoggingException actual;
                AppenderLoggingException e = appenderLoggingException;
                Throwable cause = appenderLoggingException.getCause();
                actual = cause == null ? e : actual;
                void v1 = var2_2;
                JdbcDatabaseManager.logger().debug("{} committing and closing connection: {}", (Object)v1, (Object)v1.getClass().getSimpleName(), (Object)e.toString(), (Object)var1_1);
            }
        }
        if (this.factoryData.connectionSource != null) {
            this.factoryData.connectionSource.stop();
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void connectAndPrepare() throws SQLException {
        void var1_1;
        JdbcDatabaseManager.logger().debug("Acquiring JDBC connection from {}", (Object)this.getConnectionSource());
        this.connection = this.getConnectionSource().getConnection();
        JdbcDatabaseManager.logger().debug("Acquired JDBC connection {}", (Object)this.connection);
        JdbcDatabaseManager.logger().debug("Getting connection metadata {}", (Object)this.connection);
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        JdbcDatabaseManager.logger().debug("Connection metadata {}", (Object)databaseMetaData);
        this.isBatchSupported = var1_1.supportsBatchUpdates();
        JdbcDatabaseManager.logger().debug("Connection supportsBatchUpdates: {}", (Object)this.isBatchSupported);
        this.connection.setAutoCommit(false);
        JdbcDatabaseManager.logger().debug("Preparing SQL {}", (Object)this.sqlStatement);
        this.statement = this.connection.prepareStatement(this.sqlStatement);
        JdbcDatabaseManager.logger().debug("Prepared SQL {}", (Object)this.statement);
        if (this.factoryData.truncateStrings) {
            this.initColumnMetaData();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void connectAndStart() {
        this.checkConnection();
        JdbcDatabaseManager jdbcDatabaseManager = this;
        synchronized (jdbcDatabaseManager) {
            try {
                this.connectAndPrepare();
            }
            catch (SQLException e) {
                void var2_2;
                this.reconnectOn((Exception)var2_2);
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Reconnector createReconnector() {
        void var1_1;
        Reconnector recon = new Reconnector();
        recon.setDaemon(true);
        recon.setPriority(1);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private String createSqlSelect() {
        void var1_1;
        StringBuilder sb = new StringBuilder("select ");
        JdbcDatabaseManager.appendColumnNames("SELECT", this.factoryData, sb);
        sb.append(" from ");
        sb.append(this.factoryData.tableName);
        sb.append(" where 1=0");
        return var1_1.toString();
    }

    private String fieldsToString() {
        return String.format("columnConfigs=%s, sqlStatement=%s, factoryData=%s, connection=%s, statement=%s, reconnector=%s, isBatchSupported=%s, columnMetaData=%s", this.columnConfigs, this.sqlStatement, this.factoryData, this.connection, this.statement, this.reconnector, this.isBatchSupported, this.columnMetaData);
    }

    public final ConnectionSource getConnectionSource() {
        return this.factoryData.connectionSource;
    }

    public final String getSqlStatement() {
        return this.sqlStatement;
    }

    public final String getTableName() {
        return this.factoryData.tableName;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initColumnMetaData() throws SQLException {
        String sqlSelect = this.createSqlSelect();
        JdbcDatabaseManager.logger().debug("Getting SQL metadata for table {}: {}", (Object)this.factoryData.tableName, (Object)sqlSelect);
        PreparedStatement mdStatement2 = this.connection.prepareStatement(sqlSelect);
        Throwable throwable = null;
        try {
            ResultSetMetaData rsMetaData = mdStatement2.getMetaData();
            JdbcDatabaseManager.logger().debug("SQL metadata: {}", (Object)rsMetaData);
            if (rsMetaData != null) {
                int columnCount = rsMetaData.getColumnCount();
                this.columnMetaData = new HashMap<String, ResultSetColumnMetaData>(columnCount);
                int i = 0;
                int j = 1;
                while (i < columnCount) {
                    ResultSetColumnMetaData value = new ResultSetColumnMetaData(rsMetaData, j);
                    this.columnMetaData.put(value.getNameKey(), value);
                    ++i;
                    ++j;
                }
            } else {
                JdbcDatabaseManager.logger().warn("{}: truncateStrings is true and ResultSetMetaData is null for statement: {}; manager will not perform truncation.", (Object)this.getClass().getSimpleName(), (Object)mdStatement2);
            }
            if (mdStatement2 == null) return;
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (mdStatement2 == null) throw throwable4;
                if (throwable != null) {
                    try {
                        mdStatement2.close();
                        throw throwable4;
                    }
                    catch (Throwable mdStatement2) {
                        throwable.addSuppressed(mdStatement2);
                    }
                    throw throwable4;
                } else {
                    void var1_1;
                    var1_1.close();
                }
                throw throwable4;
            }
        }
        mdStatement2.close();
        return;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isClosed(Statement statement) throws SQLException {
        void var1_1;
        return statement == null || var1_1.isClosed();
    }

    /*
     * WARNING - void declaration
     */
    private boolean isClosed(Connection connection) throws SQLException {
        void var1_1;
        return connection == null || var1_1.isClosed();
    }

    /*
     * WARNING - void declaration
     */
    private void reconnectOn(Exception exception) {
        block4: {
            if (!this.factoryData.retry) {
                throw new AppenderLoggingException("Cannot connect and prepare", exception);
            }
            if (this.reconnector == null) {
                this.reconnector = this.createReconnector();
                try {
                    this.reconnector.reconnect();
                    return;
                }
                catch (SQLException reconnectEx) {
                    void var1_1;
                    void var2_2;
                    JdbcDatabaseManager.logger().debug("Cannot reestablish JDBC connection to {}: {}; starting reconnector thread {}", (Object)this.factoryData, (Object)reconnectEx, (Object)this.reconnector.getName(), (Object)var2_2);
                    this.reconnector.start();
                    this.reconnector.latch();
                    if (this.connection != null && this.statement != null) break block4;
                    throw new AppenderLoggingException((Throwable)var1_1, "Error sending to %s for %s [%s]", this.getName(), this.factoryData, this.fieldsToString());
                }
            }
        }
    }

    private void setFields(MapMessage<?, ?> mapMessage) throws SQLException {
        IndexedReadOnlyStringMap map = mapMessage.getIndexedReadOnlyStringMap();
        String simpleName = this.statement.getClass().getName();
        int j = 1;
        if (this.factoryData.columnMappings != null) {
            for (ColumnMapping mapping : this.factoryData.columnMappings) {
                if (mapping.getLiteralValue() != null) continue;
                String source = mapping.getSource();
                String key = Strings.isEmpty((CharSequence)source) ? mapping.getName() : source;
                Object value = map.getValue(key);
                if (JdbcDatabaseManager.logger().isTraceEnabled()) {
                    String valueStr = value instanceof String ? "\"" + value + "\"" : Objects.toString(value, null);
                    JdbcDatabaseManager.logger().trace("{} setObject({}, {}) for key '{}' and mapping '{}'", (Object)simpleName, (Object)j, (Object)valueStr, (Object)key, (Object)mapping.getName());
                }
                this.setStatementObject(j, mapping.getNameKey(), value);
                ++j;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setStatementObject(int j, String nameKey, Object value) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.statement == null) {
            throw new AppenderLoggingException("Cannot set a value when the PreparedStatement is null.");
        }
        if (value == null) {
            if (this.columnMetaData == null) {
                throw new AppenderLoggingException("Cannot set a value when the column metadata is null.");
            }
            this.statement.setNull(j, this.columnMetaData.get(nameKey).getType());
            return;
        }
        this.statement.setObject((int)var1_1, this.truncate((String)var2_2, var3_3));
    }

    @Override
    protected final boolean shutdownInternal() {
        if (this.reconnector != null) {
            this.reconnector.shutdown();
            this.reconnector.interrupt();
            this.reconnector = null;
        }
        return this.commitAndCloseAll();
    }

    @Override
    protected final void startupInternal() throws Exception {
    }

    /*
     * WARNING - void declaration
     */
    private Object truncate(String nameKey, Object value) {
        void var2_2;
        if (value != null && this.factoryData.truncateStrings && this.columnMetaData != null) {
            ResultSetColumnMetaData resultSetColumnMetaData = this.columnMetaData.get(nameKey);
            if (resultSetColumnMetaData != null) {
                if (resultSetColumnMetaData.isStringType()) {
                    void var3_3;
                    value = var3_3.truncate(value.toString());
                }
            } else {
                void var1_1;
                JdbcDatabaseManager.logger().error("Missing ResultSetColumnMetaData for {}, connection={}, statement={}", (Object)var1_1, (Object)this.connection, (Object)this.statement);
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected final void writeInternal(LogEvent event, Serializable serializable) {
        StringReader reader = null;
        try {
            block32: {
                block31: {
                    if (!this.isRunning()) break block31;
                    JdbcDatabaseManager jdbcDatabaseManager = this;
                    if (jdbcDatabaseManager.isClosed(jdbcDatabaseManager.connection)) break block31;
                    JdbcDatabaseManager jdbcDatabaseManager2 = this;
                    if (!jdbcDatabaseManager2.isClosed(jdbcDatabaseManager2.statement)) break block32;
                }
                throw new AppenderLoggingException("Cannot write logging event; JDBC manager not connected to the database, running=%s, [%s]).", this.isRunning(), this.fieldsToString());
            }
            this.statement.clearParameters();
            if (serializable instanceof MapMessage) {
                this.setFields((MapMessage)serializable);
            }
            int j = 1;
            if (this.factoryData.columnMappings != null) {
                for (ColumnMapping mapping : this.factoryData.columnMappings) {
                    if (ThreadContextMap.class.isAssignableFrom(mapping.getType()) || ReadOnlyStringMap.class.isAssignableFrom(mapping.getType())) {
                        this.statement.setObject(j++, event.getContextData().toMap());
                        continue;
                    }
                    if (ThreadContextStack.class.isAssignableFrom(mapping.getType())) {
                        this.statement.setObject(j++, event.getContextStack().asList());
                        continue;
                    }
                    if (Date.class.isAssignableFrom(mapping.getType())) {
                        this.statement.setObject(j++, DateTypeConverter.fromMillis(event.getTimeMillis(), mapping.getType().asSubclass(Date.class)));
                        continue;
                    }
                    StringLayout layout = mapping.getLayout();
                    if (layout == null) continue;
                    if (Clob.class.isAssignableFrom(mapping.getType())) {
                        this.statement.setClob(j++, new StringReader((String)layout.toSerializable(event)));
                        continue;
                    }
                    if (NClob.class.isAssignableFrom(mapping.getType())) {
                        this.statement.setNClob(j++, new StringReader((String)layout.toSerializable(event)));
                        continue;
                    }
                    Object value = TypeConverters.convert((String)layout.toSerializable(event), mapping.getType(), null);
                    this.setStatementObject(j++, mapping.getNameKey(), value);
                }
            }
            for (ColumnConfig column : this.columnConfigs) {
                if (column.isEventTimestamp()) {
                    this.statement.setTimestamp(j++, new Timestamp(event.getTimeMillis()));
                    continue;
                }
                if (column.isClob()) {
                    reader = new StringReader(column.getLayout().toSerializable(event));
                    if (column.isUnicode()) {
                        this.statement.setNClob(j++, reader);
                        continue;
                    }
                    this.statement.setClob(j++, reader);
                    continue;
                }
                if (column.isUnicode()) {
                    this.statement.setNString(j++, Objects.toString(this.truncate(column.getColumnNameKey(), column.getLayout().toSerializable(event)), null));
                    continue;
                }
                this.statement.setString(j++, Objects.toString(this.truncate(column.getColumnNameKey(), column.getLayout().toSerializable(event)), null));
            }
            if (this.isBuffered() && this.isBatchSupported) {
                JdbcDatabaseManager.logger().debug("addBatch for {}", (Object)this.statement);
                this.statement.addBatch();
            } else {
                int executeUpdate = this.statement.executeUpdate();
                JdbcDatabaseManager.logger().debug("executeUpdate = {} for {}", (Object)executeUpdate, (Object)this.statement);
                if (executeUpdate == 0) {
                    throw new AppenderLoggingException("No records inserted in database table for log event in JDBC manager [%s].", this.fieldsToString());
                }
            }
        }
        catch (SQLException e) {
            try {
                void var2_5;
                throw new DbAppenderLoggingException(e, "Failed to insert record for log event in JDBC manager: %s [%s]", var2_5, this.fieldsToString());
            }
            catch (Throwable throwable) {
                void var3_6;
                try {
                    if (this.statement != null) {
                        this.statement.clearParameters();
                    }
                }
                catch (SQLException sQLException) {}
                Closer.closeSilently((AutoCloseable)var3_6);
                throw throwable;
            }
        }
        try {
            if (this.statement != null) {
                this.statement.clearParameters();
            }
        }
        catch (SQLException sQLException) {}
        Closer.closeSilently(reader);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void writeThrough(LogEvent event, Serializable serializable) {
        this.connectAndStart();
        try {
            try {
                this.writeInternal(event, serializable);
            }
            finally {
                this.commitAndClose();
            }
        }
        catch (DbAppenderLoggingException e) {
            void var3_5;
            this.reconnectOn((Exception)var3_5);
            try {
                void var2_3;
                void var1_1;
                this.writeInternal((LogEvent)var1_1, (Serializable)var2_3);
                return;
            }
            finally {
                this.commitAndClose();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(String x0, FactoryData x1, StringBuilder x2) {
        void var2_2;
        void var1_1;
        JdbcDatabaseManager.appendColumnNames(x0, (FactoryData)var1_1, (StringBuilder)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Reconnector access$902(JdbcDatabaseManager x0, Reconnector x1) {
        void var1_1;
        x0.reconnector = var1_1;
        return x0.reconnector;
    }

    private static final class ResultSetColumnMetaData {
        private final String schemaName;
        private final String catalogName;
        private final String tableName;
        private final String name;
        private final String nameKey;
        private final String label;
        private final int displaySize;
        private final int type;
        private final String typeName;
        private final String className;
        private final int precision;
        private final int scale;
        private final boolean isStringType;

        /*
         * WARNING - void declaration
         */
        public ResultSetColumnMetaData(ResultSetMetaData rsMetaData, int j) throws SQLException {
            this(rsMetaData.getSchemaName(j), rsMetaData.getCatalogName(j), rsMetaData.getTableName(j), rsMetaData.getColumnName(j), rsMetaData.getColumnLabel(j), rsMetaData.getColumnDisplaySize(j), rsMetaData.getColumnType(j), rsMetaData.getColumnTypeName(j), rsMetaData.getColumnClassName(j), rsMetaData.getPrecision(j), var1_1.getScale((int)var2_2));
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private ResultSetColumnMetaData(String schemaName, String catalogName, String tableName, String name, String label, int displaySize, int type, String typeName, String className, int precision, int scale) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.schemaName = var1_1;
            this.catalogName = var2_2;
            this.tableName = var3_3;
            this.name = name;
            this.nameKey = ColumnMapping.toKey(name);
            this.label = label;
            this.displaySize = displaySize;
            this.type = type;
            this.typeName = typeName;
            this.className = className;
            this.precision = precision;
            this.scale = scale;
            this.isStringType = type == 1 || type == -16 || type == -1 || type == -9 || type == 12;
        }

        public final String getCatalogName() {
            return this.catalogName;
        }

        public final String getClassName() {
            return this.className;
        }

        public final int getDisplaySize() {
            return this.displaySize;
        }

        public final String getLabel() {
            return this.label;
        }

        public final String getName() {
            return this.name;
        }

        public final String getNameKey() {
            return this.nameKey;
        }

        public final int getPrecision() {
            return this.precision;
        }

        public final int getScale() {
            return this.scale;
        }

        public final String getSchemaName() {
            return this.schemaName;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final int getType() {
            return this.type;
        }

        public final String getTypeName() {
            return this.typeName;
        }

        public final boolean isStringType() {
            return this.isStringType;
        }

        public final String toString() {
            return String.format("ColumnMetaData [schemaName=%s, catalogName=%s, tableName=%s, name=%s, nameKey=%s, label=%s, displaySize=%s, type=%s, typeName=%s, className=%s, precision=%s, scale=%s, isStringType=%s]", this.schemaName, this.catalogName, this.tableName, this.name, this.nameKey, this.label, this.displaySize, this.type, this.typeName, this.className, this.precision, this.scale, this.isStringType);
        }

        /*
         * WARNING - void declaration
         */
        public final String truncate(String string) {
            void var1_1;
            if (this.precision > 0) {
                return Strings.left((String)string, (int)this.precision);
            }
            return var1_1;
        }
    }

    private final class Reconnector
    extends Log4jThread {
        private final CountDownLatch latch;
        private volatile boolean shutdown;

        private Reconnector() {
            super("JdbcDatabaseManager-Reconnector");
            this.latch = new CountDownLatch(1);
        }

        public final void latch() {
            try {
                this.latch.await();
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        final void reconnect() throws SQLException {
            JdbcDatabaseManager.this.closeResources(false);
            JdbcDatabaseManager.this.connectAndPrepare();
            JdbcDatabaseManager.access$902(JdbcDatabaseManager.this, null);
            this.shutdown = true;
            JdbcDatabaseManager.logger().debug("Connection reestablished to {}", (Object)JdbcDatabaseManager.this.factoryData);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void run() {
            while (!this.shutdown) {
                try {
                    Reconnector.sleep(JdbcDatabaseManager.this.factoryData.reconnectIntervalMillis);
                    this.reconnect();
                }
                catch (InterruptedException | SQLException e) {
                    void var1_1;
                    JdbcDatabaseManager.logger().debug("Cannot reestablish JDBC connection to {}: {}", (Object)JdbcDatabaseManager.this.factoryData, (Object)e.getLocalizedMessage(), (Object)var1_1);
                }
                finally {
                    this.latch.countDown();
                }
            }
        }

        public final void shutdown() {
            this.shutdown = true;
        }

        @Override
        public final String toString() {
            return String.format("Reconnector [latch=%s, shutdown=%s]", this.latch, this.shutdown);
        }
    }

    private static final class JdbcDatabaseManagerFactory
    implements ManagerFactory<JdbcDatabaseManager, FactoryData> {
        private static final char PARAMETER_MARKER = '?';

        private JdbcDatabaseManagerFactory() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final JdbcDatabaseManager createManager(String name, FactoryData data) {
            void var2_2;
            void var1_1;
            void var3_3;
            StringBuilder sb = new StringBuilder("insert into ").append(data.tableName).append(" (");
            JdbcDatabaseManager.access$100("INSERT", data, sb);
            sb.append(") values (");
            int i = 1;
            if (data.columnMappings != null) {
                for (ColumnMapping mapping : data.columnMappings) {
                    String mappingName = mapping.getName();
                    if (Strings.isNotEmpty((CharSequence)mapping.getLiteralValue())) {
                        JdbcDatabaseManager.logger().trace("Adding INSERT VALUES literal for ColumnMapping[{}]: {}={} ", (Object)i, (Object)mappingName, (Object)mapping.getLiteralValue());
                        sb.append(mapping.getLiteralValue());
                    } else if (Strings.isNotEmpty((CharSequence)mapping.getParameter())) {
                        JdbcDatabaseManager.logger().trace("Adding INSERT VALUES parameter for ColumnMapping[{}]: {}={} ", (Object)i, (Object)mappingName, (Object)mapping.getParameter());
                        sb.append(mapping.getParameter());
                    } else {
                        JdbcDatabaseManager.logger().trace("Adding INSERT VALUES parameter marker for ColumnMapping[{}]: {}={} ", (Object)i, (Object)mappingName, (Object)Character.valueOf('?'));
                        sb.append('?');
                    }
                    sb.append(',');
                    ++i;
                }
            }
            int columnConfigsLen = data.columnConfigs == null ? 0 : data.columnConfigs.length;
            ArrayList<ColumnConfig> columnConfigs = new ArrayList<ColumnConfig>(columnConfigsLen);
            if (data.columnConfigs != null) {
                for (ColumnConfig config : data.columnConfigs) {
                    if (Strings.isNotEmpty((CharSequence)config.getLiteralValue())) {
                        sb.append(config.getLiteralValue());
                    } else {
                        sb.append('?');
                        columnConfigs.add(config);
                    }
                    sb.append(',');
                }
            }
            StringBuilder stringBuilder = sb;
            stringBuilder.setCharAt(stringBuilder.length() - 1, ')');
            String sqlStatement = var3_3.toString();
            return new JdbcDatabaseManager((String)var1_1, sqlStatement, columnConfigs, (FactoryData)var2_2);
        }
    }

    private static final class FactoryData
    extends AbstractDatabaseManager.AbstractFactoryData {
        private final ConnectionSource connectionSource;
        private final String tableName;
        private final ColumnConfig[] columnConfigs;
        private final ColumnMapping[] columnMappings;
        private final boolean immediateFail;
        private final boolean retry;
        private final long reconnectIntervalMillis;
        private final boolean truncateStrings;

        /*
         * WARNING - void declaration
         */
        protected FactoryData(int bufferSize, Layout<? extends Serializable> layout, ConnectionSource connectionSource, String tableName, ColumnConfig[] columnConfigs, ColumnMapping[] columnMappings, boolean immediateFail, long reconnectIntervalMillis, boolean truncateStrings) {
            super((int)var1_1, (Layout<? extends Serializable>)var2_2);
            void var3_3;
            void var2_2;
            void var1_1;
            this.connectionSource = var3_3;
            this.tableName = tableName;
            this.columnConfigs = columnConfigs;
            this.columnMappings = columnMappings;
            this.immediateFail = immediateFail;
            this.retry = reconnectIntervalMillis > 0L;
            this.reconnectIntervalMillis = reconnectIntervalMillis;
            this.truncateStrings = truncateStrings;
        }

        public final String toString() {
            return String.format("FactoryData [connectionSource=%s, tableName=%s, columnConfigs=%s, columnMappings=%s, immediateFail=%s, retry=%s, reconnectIntervalMillis=%s, truncateStrings=%s]", this.connectionSource, this.tableName, Arrays.toString(this.columnConfigs), Arrays.toString(this.columnMappings), this.immediateFail, this.retry, this.reconnectIntervalMillis, this.truncateStrings);
        }
    }
}

