/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.db.jdbc;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.db.AbstractDatabaseAppender;
import org.apache.logging.log4j.core.appender.db.ColumnMapping;
import org.apache.logging.log4j.core.appender.db.jdbc.ColumnConfig;
import org.apache.logging.log4j.core.appender.db.jdbc.ConnectionSource;
import org.apache.logging.log4j.core.appender.db.jdbc.JdbcDatabaseManager;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.util.Assert;
import org.apache.logging.log4j.core.util.Booleans;

@Plugin(name="JDBC", category="Core", elementType="appender", printObject=true)
public final class JdbcAppender
extends AbstractDatabaseAppender<JdbcDatabaseManager> {
    private final String description = this.getName() + "{ manager=" + this.getManager() + " }";

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static <B extends Builder<B>> JdbcAppender createAppender(String name, String ignore, Filter filter, ConnectionSource connectionSource, String bufferSize, String tableName, ColumnConfig[] columnConfigs) {
        void var2_3;
        void var1_2;
        String string;
        void var3_4;
        Assert.requireNonEmpty(name, "Name cannot be empty");
        Objects.requireNonNull(connectionSource, "ConnectionSource cannot be null");
        Assert.requireNonEmpty(tableName, "Table name cannot be empty");
        Assert.requireNonEmpty(columnConfigs, "ColumnConfigs cannot be empty");
        int bufferSizeInt = AbstractAppender.parseInt(bufferSize, 0);
        boolean ignoreExceptions = Booleans.parseBoolean(ignore, true);
        return ((Builder)((Builder)((Builder)((AbstractAppender.Builder)((Builder)((Builder)((Builder)((Builder)JdbcAppender.newBuilder()).setBufferSize(bufferSizeInt)).setColumnConfigs(columnConfigs)).setConnectionSource((ConnectionSource)var3_4)).setTableName(tableName)).setName(string)).setIgnoreExceptions((boolean)var1_2)).setFilter((Filter)var2_3)).build();
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Builder)new Builder().asBuilder());
    }

    /*
     * WARNING - void declaration
     */
    private JdbcAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, Property[] properties, JdbcDatabaseManager manager) {
        super((String)var1_1, (Filter)var2_2, (Layout<? extends Serializable>)var3_3, ignoreExceptions, properties, manager);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    @Override
    public final String toString() {
        return this.description;
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractDatabaseAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<JdbcAppender> {
        @PluginElement(value="ConnectionSource")
        @Required(message="No ConnectionSource provided")
        private ConnectionSource connectionSource;
        @PluginBuilderAttribute
        private boolean immediateFail;
        @PluginBuilderAttribute
        private int bufferSize;
        @PluginBuilderAttribute
        @Required(message="No table name provided")
        private String tableName;
        @PluginElement(value="ColumnConfigs")
        private ColumnConfig[] columnConfigs;
        @PluginElement(value="ColumnMappings")
        private ColumnMapping[] columnMappings;
        @PluginBuilderAttribute
        private boolean truncateStrings = true;
        @PluginBuilderAttribute
        private long reconnectIntervalMillis = 5000L;

        @Override
        public JdbcAppender build() {
            if (Assert.isEmpty(this.columnConfigs) && Assert.isEmpty(this.columnMappings)) {
                LOGGER.error("Cannot create JdbcAppender without any columns.");
                return null;
            }
            String string = "JdbcManager{name=" + this.getName() + ", bufferSize=" + this.bufferSize + ", tableName=" + this.tableName + ", columnConfigs=" + Arrays.toString(this.columnConfigs) + ", columnMappings=" + Arrays.toString(this.columnMappings) + '}';
            JdbcDatabaseManager manager = JdbcDatabaseManager.getManager(string, this.bufferSize, this.getLayout(), this.connectionSource, this.tableName, this.columnConfigs, this.columnMappings, this.immediateFail, this.reconnectIntervalMillis, this.truncateStrings);
            if (manager == null) {
                return null;
            }
            return new JdbcAppender(this.getName(), this.getFilter(), this.getLayout(), this.isIgnoreExceptions(), this.getPropertyArray(), (JdbcDatabaseManager)((Object)string));
        }

        public long getReconnectIntervalMillis() {
            return this.reconnectIntervalMillis;
        }

        public boolean isImmediateFail() {
            return this.immediateFail;
        }

        /*
         * WARNING - void declaration
         */
        public B setBufferSize(int bufferSize) {
            void var1_1;
            this.bufferSize = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setColumnConfigs(ColumnConfig ... columnConfigs) {
            void var1_1;
            this.columnConfigs = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setColumnMappings(ColumnMapping ... columnMappings) {
            void var1_1;
            this.columnMappings = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setConnectionSource(ConnectionSource connectionSource) {
            void var1_1;
            this.connectionSource = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public void setImmediateFail(boolean immediateFail) {
            void var1_1;
            this.immediateFail = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void setReconnectIntervalMillis(long reconnectIntervalMillis) {
            void var1_1;
            this.reconnectIntervalMillis = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public B setTableName(String tableName) {
            void var1_1;
            this.tableName = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setTruncateStrings(boolean truncateStrings) {
            void var1_1;
            this.truncateStrings = var1_1;
            return (B)((Builder)this.asBuilder());
        }
    }
}

