/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.db.jdbc;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.db.jdbc.AbstractConnectionSource;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="ConnectionFactory", category="Core", elementType="connectionSource", printObject=true)
public final class FactoryMethodConnectionSource
extends AbstractConnectionSource {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final DataSource dataSource;
    private final String description;

    /*
     * WARNING - void declaration
     */
    private FactoryMethodConnectionSource(DataSource dataSource, String className, String methodName, String returnType) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.dataSource = var1_1;
        this.description = "factory{ public static " + returnType + ' ' + (String)var2_2 + '.' + (String)var3_3 + "() }";
    }

    @Override
    public final Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    @Override
    public final String toString() {
        return this.description;
    }

    /*
     * WARNING - void declaration
     */
    @PluginFactory
    public static FactoryMethodConnectionSource createConnectionSource(@PluginAttribute(value="class") String className, @PluginAttribute(value="method") String methodName) {
        void var1_2;
        void var2_5;
        String string;
        DataSource dataSource;
        Method method;
        Class<?> clazz;
        if (Strings.isEmpty((CharSequence)className) || Strings.isEmpty((CharSequence)methodName)) {
            LOGGER.error("No class name or method name specified for the connection factory method.");
            return null;
        }
        try {
            clazz = Loader.loadClass(className);
            method = clazz.getMethod(methodName, new Class[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.toString(), (Throwable)e);
            return null;
        }
        Class<?> returnType = method.getReturnType();
        String returnTypeString = returnType.getName();
        if (returnType == DataSource.class) {
            try {
                dataSource = (DataSource)method.invoke(null, new Object[0]);
                returnTypeString = returnTypeString + "[" + dataSource + ']';
            }
            catch (Exception e) {
                void var0_1;
                LOGGER.error(e.toString(), (Throwable)var0_1);
                return null;
            }
        } else if (returnType == Connection.class) {
            dataSource = new DataSource((Method)((Object)dataSource)){
                final /* synthetic */ Method val$method;
                {
                    this.val$method = method;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final Connection getConnection() throws SQLException {
                    try {
                        return (Connection)this.val$method.invoke(null, new Object[0]);
                    }
                    catch (Exception e) {
                        void var1_1;
                        throw new SQLException("Failed to obtain connection from factory method.", (Throwable)var1_1);
                    }
                }

                @Override
                public final Connection getConnection(String username, String password) throws SQLException {
                    throw new UnsupportedOperationException();
                }

                @Override
                public final int getLoginTimeout() throws SQLException {
                    throw new UnsupportedOperationException();
                }

                @Override
                public final PrintWriter getLogWriter() throws SQLException {
                    throw new UnsupportedOperationException();
                }

                @Override
                public final java.util.logging.Logger getParentLogger() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public final boolean isWrapperFor(Class<?> iface) throws SQLException {
                    return false;
                }

                @Override
                public final void setLoginTimeout(int seconds) throws SQLException {
                    throw new UnsupportedOperationException();
                }

                @Override
                public final void setLogWriter(PrintWriter out) throws SQLException {
                    throw new UnsupportedOperationException();
                }

                @Override
                public final <T> T unwrap(Class<T> iface) throws SQLException {
                    return null;
                }
            };
        } else {
            LOGGER.error("Method [{}.{}()] returns unsupported type [{}].", (Object)string, (Object)methodName, (Object)clazz.getName());
            return null;
        }
        return new FactoryMethodConnectionSource((DataSource)var2_5, string, (String)var1_2, returnTypeString);
    }
}

