/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.db.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.db.jdbc.AbstractConnectionSource;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.net.JndiManager;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="DataSource", category="Core", elementType="connectionSource", printObject=true)
public final class DataSourceConnectionSource
extends AbstractConnectionSource {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final DataSource dataSource;
    private final String description;

    /*
     * WARNING - void declaration
     */
    private DataSourceConnectionSource(String dataSourceName, DataSource dataSource) {
        void var2_2;
        void var1_1;
        this.dataSource = Objects.requireNonNull(dataSource, "dataSource");
        this.description = "dataSource{ name=" + (String)var1_1 + ", value=" + var2_2 + " }";
    }

    @Override
    public final Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    @Override
    public final String toString() {
        return this.description;
    }

    /*
     * WARNING - void declaration
     */
    @PluginFactory
    public static DataSourceConnectionSource createConnectionSource(@PluginAttribute(value="jndiName") String jndiName) {
        if (!JndiManager.isJndiJdbcEnabled()) {
            LOGGER.error("JNDI must be enabled by setting log4j2.enableJndiJdbc=true");
            return null;
        }
        if (Strings.isEmpty((CharSequence)jndiName)) {
            LOGGER.error("No JNDI name provided.");
            return null;
        }
        try {
            String string;
            DataSource dataSource = (DataSource)JndiManager.getDefaultManager(DataSourceConnectionSource.class.getCanonicalName()).lookup(jndiName);
            if (dataSource == null) {
                LOGGER.error("No DataSource found with JNDI name [" + jndiName + "].");
                return null;
            }
            return new DataSourceConnectionSource(string, dataSource);
        }
        catch (NamingException e) {
            void var1_2;
            LOGGER.error(e.getMessage(), (Throwable)var1_2);
            return null;
        }
    }
}

