/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.db.jdbc;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.db.ColumnMapping;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.util.Booleans;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="Column", category="Core", printObject=true)
public final class ColumnConfig {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final String columnName;
    private final String columnNameKey;
    private final PatternLayout layout;
    private final String literalValue;
    private final boolean eventTimestamp;
    private final boolean unicode;
    private final boolean clob;

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static ColumnConfig createColumnConfig(Configuration config, String name, String pattern, String literalValue, String eventTimestamp, String unicode, String clob) {
        void var3_3;
        void var2_2;
        void var1_1;
        Configuration configuration;
        if (Strings.isEmpty((CharSequence)name)) {
            LOGGER.error("The column config is not valid because it does not contain a column name.");
            return null;
        }
        boolean isEventTimestamp = Boolean.parseBoolean(eventTimestamp);
        boolean isUnicode = Booleans.parseBoolean(unicode, true);
        boolean isClob = Boolean.parseBoolean(clob);
        return ColumnConfig.newBuilder().setConfiguration(configuration).setName((String)var1_1).setPattern((String)var2_2).setLiteral((String)var3_3).setEventTimestamp(isEventTimestamp).setUnicode(isUnicode).setClob(isClob).build();
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    /*
     * WARNING - void declaration
     */
    private ColumnConfig(String columnName, PatternLayout layout, String literalValue, boolean eventDate, boolean unicode, boolean clob) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.columnName = columnName;
        this.columnNameKey = ColumnMapping.toKey((String)var1_1);
        this.layout = var2_2;
        this.literalValue = var3_3;
        this.eventTimestamp = eventDate;
        this.unicode = unicode;
        this.clob = clob;
    }

    public final String getColumnName() {
        return this.columnName;
    }

    public final String getColumnNameKey() {
        return this.columnNameKey;
    }

    public final PatternLayout getLayout() {
        return this.layout;
    }

    public final String getLiteralValue() {
        return this.literalValue;
    }

    public final boolean isClob() {
        return this.clob;
    }

    public final boolean isEventTimestamp() {
        return this.eventTimestamp;
    }

    public final boolean isUnicode() {
        return this.unicode;
    }

    public final String toString() {
        return "{ name=" + this.columnName + ", layout=" + this.layout + ", literal=" + this.literalValue + ", timestamp=" + this.eventTimestamp + " }";
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<ColumnConfig> {
        @PluginConfiguration
        private Configuration configuration;
        @PluginBuilderAttribute
        @Required(message="No name provided")
        private String name;
        @PluginBuilderAttribute
        private String pattern;
        @PluginBuilderAttribute
        private String literal;
        @PluginBuilderAttribute
        private boolean isEventTimestamp;
        @PluginBuilderAttribute
        private boolean isUnicode = true;
        @PluginBuilderAttribute
        private boolean isClob;

        /*
         * WARNING - void declaration
         */
        @Override
        public ColumnConfig build() {
            void var2_3;
            if (Strings.isEmpty((CharSequence)this.name)) {
                LOGGER.error("The column config is not valid because it does not contain a column name.");
                return null;
            }
            boolean isPattern = Strings.isNotEmpty((CharSequence)this.pattern);
            boolean isLiteralValue = Strings.isNotEmpty((CharSequence)this.literal);
            if (isPattern && isLiteralValue || isPattern && this.isEventTimestamp || isLiteralValue && this.isEventTimestamp) {
                LOGGER.error("The pattern, literal, and isEventTimestamp attributes are mutually exclusive.");
                return null;
            }
            if (this.isEventTimestamp) {
                return new ColumnConfig(this.name, null, null, true, false, false);
            }
            if (var2_3 != false) {
                return new ColumnConfig(this.name, null, this.literal, false, false, false);
            }
            if (isPattern) {
                void var1_2;
                PatternLayout layout = PatternLayout.newBuilder().withPattern(this.pattern).withConfiguration(this.configuration).withAlwaysWriteExceptions(false).build();
                return new ColumnConfig(this.name, (PatternLayout)var1_2, null, false, this.isUnicode, this.isClob);
            }
            LOGGER.error("To configure a column you must specify a pattern or literal or set isEventDate to true.");
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setClob(boolean clob) {
            void var1_1;
            this.isClob = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setConfiguration(Configuration configuration) {
            void var1_1;
            this.configuration = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setEventTimestamp(boolean eventTimestamp) {
            void var1_1;
            this.isEventTimestamp = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setLiteral(String literal) {
            void var1_1;
            this.literal = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setName(String name) {
            void var1_1;
            this.name = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setPattern(String pattern) {
            void var1_1;
            this.pattern = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setUnicode(boolean unicode) {
            void var1_1;
            this.isUnicode = var1_1;
            return this;
        }
    }
}

