/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.db.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.db.jdbc.AbstractConnectionSource;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.status.StatusLogger;

public class AbstractDriverManagerConnectionSource
extends AbstractConnectionSource {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final String actualConnectionString;
    private final String connectionString;
    private final String driverClassName;
    private final char[] password;
    private final Property[] properties;
    private final char[] userName;

    public static Logger getLogger() {
        return LOGGER;
    }

    /*
     * WARNING - void declaration
     */
    public AbstractDriverManagerConnectionSource(String driverClassName, String connectionString, String actualConnectionString, char[] userName, char[] password, Property[] properties) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.driverClassName = var1_1;
        this.connectionString = var2_2;
        this.actualConnectionString = var3_3;
        this.userName = userName;
        this.password = password;
        this.properties = properties;
    }

    public String getActualConnectionString() {
        return this.actualConnectionString;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection getConnection() throws SQLException {
        void var2_2;
        void var1_1;
        Connection connection;
        this.loadDriver();
        String actualConnectionString = this.getActualConnectionString();
        LOGGER.debug("{} getting connection for '{}'", (Object)this.getClass().getSimpleName(), (Object)actualConnectionString);
        if (this.properties != null && this.properties.length > 0) {
            if (this.userName != null || this.password != null) {
                throw new SQLException("Either set the userName and password, or set the Properties, but not both.");
            }
            AbstractDriverManagerConnectionSource abstractDriverManagerConnectionSource = this;
            connection = DriverManager.getConnection(actualConnectionString, abstractDriverManagerConnectionSource.toProperties(abstractDriverManagerConnectionSource.properties));
        } else {
            AbstractDriverManagerConnectionSource abstractDriverManagerConnectionSource = this;
            AbstractDriverManagerConnectionSource abstractDriverManagerConnectionSource2 = this;
            connection = DriverManager.getConnection(actualConnectionString, abstractDriverManagerConnectionSource.toString(abstractDriverManagerConnectionSource.userName), abstractDriverManagerConnectionSource2.toString(abstractDriverManagerConnectionSource2.password));
        }
        Connection connection2 = connection;
        LOGGER.debug("{} acquired connection for '{}': {} ({}@{})", (Object)this.getClass().getSimpleName(), (Object)var1_1, (Object)connection2, (Object)connection2.getClass().getName(), (Object)Integer.toHexString(connection.hashCode()));
        return var2_2;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public char[] getPassword() {
        return this.password;
    }

    public Property[] getProperties() {
        return this.properties;
    }

    public char[] getUserName() {
        return this.userName;
    }

    protected void loadDriver() throws SQLException {
        AbstractDriverManagerConnectionSource abstractDriverManagerConnectionSource = this;
        abstractDriverManagerConnectionSource.loadDriver(abstractDriverManagerConnectionSource.driverClassName);
    }

    /*
     * WARNING - void declaration
     */
    protected void loadDriver(String className) throws SQLException {
        if (className != null) {
            LOGGER.debug("Loading driver class {}", (Object)className);
            try {
                Class.forName(className);
                return;
            }
            catch (Exception e) {
                void var2_2;
                void var1_1;
                throw new SQLException(String.format("The %s could not load the JDBC driver %s: %s", this.getClass().getSimpleName(), var1_1, e.toString()), (Throwable)var2_2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Properties toProperties(Property[] properties) {
        void var2_2;
        void var1_1;
        Properties props = new Properties();
        for (void property : var1_1) {
            props.setProperty(property.getName(), property.getValue());
        }
        return var2_2;
    }

    @Override
    public String toString() {
        return this.connectionString;
    }

    /*
     * WARNING - void declaration
     */
    protected String toString(char[] value) {
        void var1_1;
        if (value == null) {
            return null;
        }
        return String.valueOf((char[])var1_1);
    }

    public static class Builder<B extends Builder<B>> {
        @PluginBuilderAttribute
        @Required
        protected String connectionString;
        @PluginBuilderAttribute
        protected String driverClassName;
        @PluginBuilderAttribute
        protected char[] password;
        @PluginElement(value="Properties")
        protected Property[] properties;
        @PluginBuilderAttribute
        protected char[] userName;

        protected B asBuilder() {
            return (B)this;
        }

        public String getConnectionString() {
            return this.connectionString;
        }

        public String getDriverClassName() {
            return this.driverClassName;
        }

        public char[] getPassword() {
            return this.password;
        }

        public Property[] getProperties() {
            return this.properties;
        }

        public char[] getUserName() {
            return this.userName;
        }

        /*
         * WARNING - void declaration
         */
        public B setConnectionString(String connectionString) {
            void var1_1;
            this.connectionString = var1_1;
            return this.asBuilder();
        }

        /*
         * WARNING - void declaration
         */
        public B setDriverClassName(String driverClassName) {
            void var1_1;
            this.driverClassName = var1_1;
            return this.asBuilder();
        }

        /*
         * WARNING - void declaration
         */
        public B setPassword(char[] password) {
            void var1_1;
            this.password = var1_1;
            return this.asBuilder();
        }

        /*
         * WARNING - void declaration
         */
        public B setProperties(Property[] properties) {
            void var1_1;
            this.properties = var1_1;
            return this.asBuilder();
        }

        /*
         * WARNING - void declaration
         */
        public B setUserName(char[] userName) {
            void var1_1;
            this.userName = var1_1;
            return this.asBuilder();
        }
    }
}

